/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Color;

public class ColorUtils {
    private ColorUtils() {
    }

    public static Color createColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color interpolateRBGA(Color color, Color color2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("distance out of range: " + d);
        }
        int n = (int)ColorUtils.interpolate(color.getRed(), color2.getRed(), d);
        int n2 = (int)ColorUtils.interpolate(color.getGreen(), color2.getGreen(), d);
        int n3 = (int)ColorUtils.interpolate(color.getBlue(), color2.getBlue(), d);
        int n4 = (int)ColorUtils.interpolate(color.getAlpha(), color2.getAlpha(), d);
        return new Color(n, n2, n3, n4);
    }

    private static double interpolate(double d, double d2, double d3) {
        assert (d3 >= 0.0 && d3 <= 1.0);
        return d + d3 * (d2 - d);
    }

    public static Color brighterColor(Color color, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("factor must be between 0 and 1: " + d);
        }
        int n = Math.min(255, color.getRed() + (int)(d * (double)(255 - color.getRed())));
        int n2 = Math.min(255, color.getGreen() + (int)(d * (double)(255 - color.getGreen())));
        int n3 = Math.min(255, color.getBlue() + (int)(d * (double)(255 - color.getBlue())));
        return new Color(n, n2, n3, color.getAlpha());
    }

    public static Color darkerColor(Color color, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("factor must be between 0 and 1: " + d);
        }
        int n = Math.max(0, color.getRed() - (int)(d * (double)color.getRed()));
        int n2 = Math.max(0, color.getGreen() - (int)(d * (double)color.getGreen()));
        int n3 = Math.max(0, color.getBlue() - (int)(d * (double)color.getBlue()));
        return new Color(n, n2, n3, color.getAlpha());
    }
}

