/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.tools;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.fourier.event.FourierDragHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;

public class MeasurementTool
extends CompositePhetGraphic
implements ApparatusPanel2.ChangeListener {
    private static final Font LABEL_FONT = new PhetFont(1, 16);
    private static final Color LABEL_COLOR = Color.BLACK;
    private HTMLGraphic _labelGraphic;
    private PhetShapeGraphic _labelBackgroundGraphic;
    private RoundRectangle2D _labelBackgroundShape;
    private PhetShapeGraphic _barGraphic;
    private GeneralPath _barPath;
    private FourierDragHandler _dragHandler;
    private float _width;

    public MeasurementTool(Component component) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._labelBackgroundShape = new RoundRectangle2D.Double();
        this._labelBackgroundGraphic = new PhetShapeGraphic(component);
        this._labelBackgroundGraphic.setShape(this._labelBackgroundShape);
        this.addGraphic(this._labelBackgroundGraphic, 1.0);
        this._labelGraphic = new HTMLGraphic(component, LABEL_FONT, "?", LABEL_COLOR);
        this.addGraphic(this._labelGraphic, 3.0);
        this.handleLabelSizeChange();
        this._barPath = new GeneralPath();
        this._barGraphic = new PhetShapeGraphic(component);
        this._barGraphic.setShape(this._barPath);
        this._barGraphic.centerRegistrationPoint();
        this._barGraphic.setLocation(0, 0);
        this.addGraphic(this._barGraphic, 2.0);
        this.setCursorHand();
        this._dragHandler = new FourierDragHandler(this);
        this.addMouseInputListener(this._dragHandler);
        this.setToolWidth(0.0f);
    }

    public void setLabelBackground(Color color) {
        this._labelBackgroundGraphic.setColor(color);
    }

    private void handleLabelSizeChange() {
        if (this._labelBackgroundGraphic.getPaint() != null) {
            int n = this._labelGraphic.getWidth() + 2;
            int n2 = this._labelGraphic.getHeight() + 2;
            this._labelBackgroundShape.setRoundRect(0.0, 0.0, n, n2, 3.0, 3.0);
            this._labelBackgroundGraphic.setShapeDirty();
            this._labelBackgroundGraphic.centerRegistrationPoint();
            this._labelBackgroundGraphic.setLocation(this._labelGraphic.getLocation());
        }
    }

    public void setLabel(String string) {
        this._labelGraphic.setHTML(string);
        this._labelGraphic.centerRegistrationPoint();
        int n = 0;
        int n2 = -(this._labelGraphic.getHeight() / 2 + 4);
        this._labelGraphic.setLocation(n, n2);
        this.handleLabelSizeChange();
    }

    public void setLabelColor(Color color) {
        this._labelGraphic.setColor(color);
    }

    public void setLabelFont(Font font) {
        this._labelGraphic.setFont(font);
        this.handleLabelSizeChange();
    }

    public void setFillColor(Color color) {
        this._barGraphic.setColor(color);
    }

    public void setBorderColor(Color color) {
        this._barGraphic.setBorderColor(color);
    }

    public void setStroke(Stroke stroke) {
        this._barGraphic.setStroke(stroke);
    }

    public void setToolWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("width must be >= 0 : " + f);
        }
        this._width = f;
        this.updatePath();
    }

    public void setDragBounds(Rectangle rectangle) {
        if (this._dragHandler != null) {
            this._dragHandler.setDragBounds(rectangle);
        }
    }

    private void updatePath() {
        this._barPath.reset();
        if (this._width > 0.0f) {
            this._barPath.moveTo(-this._width / 2.0f, -2.0f);
            this._barPath.lineTo(this._width / 2.0f, -2.0f);
            this._barPath.lineTo(this._width / 2.0f, 13.0f);
            this._barPath.lineTo(this._width / 2.0f - 3.0f, 2.0f);
            this._barPath.lineTo(-this._width / 2.0f + 3.0f, 2.0f);
            this._barPath.lineTo(-this._width / 2.0f, 13.0f);
            this._barPath.closePath();
        }
        this._barGraphic.setShapeDirty();
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._dragHandler.setDragBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
    }
}

