/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.tools;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.event.FourierDragHandler;
import edu.colorado.phet.fourier.event.HarmonicColorChangeEvent;
import edu.colorado.phet.fourier.event.HarmonicColorChangeListener;
import edu.colorado.phet.fourier.event.HarmonicFocusEvent;
import edu.colorado.phet.fourier.event.HarmonicFocusListener;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.AnimationCycleController;
import edu.colorado.phet.fourier.view.HarmonicColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class HarmonicPeriodDisplay
extends CompositePhetGraphic
implements ApparatusPanel2.ChangeListener,
HarmonicColorChangeListener,
AnimationCycleController.AnimationCycleListener {
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Font LABEL_FONT = new PhetFont(1, 16);
    private static final Color RING_CENTER_COLOR = new Color(255, 255, 255, 0);
    private static final Color RING_BORDER_COLOR = Color.BLACK;
    private static final Stroke RING_STROKE = new BasicStroke(3.0f);
    private static final String PERIOD_SYMBOL = "" + MathStrings.C_PERIOD;
    private Harmonic _harmonic;
    private HTMLGraphic _labelGraphic;
    private PhetShapeGraphic _pieGraphic;
    private Arc2D _pieArc;
    private FourierDragHandler _dragHandler;
    private EventListenerList _listenerList;
    private double _pieAngle;

    public HarmonicPeriodDisplay(Component component, Harmonic harmonic) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._labelGraphic = new HTMLGraphic(component, LABEL_FONT, "?", LABEL_COLOR);
        this._labelGraphic.setLocation(30, 0);
        this.addGraphic(this._labelGraphic, 3.0);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setShape(new Ellipse2D.Double(-15.0, -15.0, 30.0, 30.0));
        phetShapeGraphic.setPaint(RING_CENTER_COLOR);
        phetShapeGraphic.setBorderColor(RING_BORDER_COLOR);
        phetShapeGraphic.setStroke(RING_STROKE);
        this.addGraphic(phetShapeGraphic, 2.0);
        this._pieGraphic = new PhetShapeGraphic(component);
        this._pieArc = new Arc2D.Double(2);
        this._pieGraphic.setShape(this._pieArc);
        this.addGraphic(this._pieGraphic, 1.0);
        this._dragHandler = new FourierDragHandler(this);
        this.setCursorHand();
        this.addMouseInputListener(this._dragHandler);
        this.addMouseInputListener(new MouseFocusListener());
        this._listenerList = new EventListenerList();
        HarmonicColors.getInstance().addHarmonicColorChangeListener(this);
        this._pieAngle = 0.0;
        this.setHarmonic(harmonic);
    }

    public void setHarmonic(Harmonic harmonic) {
        assert (harmonic != null);
        this._harmonic = harmonic;
        this.updateSubscript();
        this.updateColor();
        this.updatePie();
    }

    private void updateSubscript() {
        String string = String.valueOf(this._harmonic.getOrder() + 1);
        this._labelGraphic.setHTML("<html>" + PERIOD_SYMBOL + "<sub>" + string + "</sub></html>");
        this._labelGraphic.centerRegistrationPoint();
    }

    private void updateColor() {
        Color color = HarmonicColors.getInstance().getColor(this._harmonic);
        this._pieGraphic.setPaint(color);
    }

    private void updatePie() {
        this._pieArc.setArc(-15.0, -15.0, 30.0, 30.0, 90.0, -this._pieAngle, 2);
        this._pieGraphic.setShape(this._pieArc);
        this._pieGraphic.setShapeDirty();
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._dragHandler.setDragBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
    }

    public void addHarmonicFocusListener(HarmonicFocusListener harmonicFocusListener) {
        this._listenerList.add(HarmonicFocusListener.class, harmonicFocusListener);
    }

    private void fireHarmonicFocusEvent(boolean bl) {
        HarmonicFocusEvent harmonicFocusEvent = new HarmonicFocusEvent(this, this._harmonic, bl);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != HarmonicFocusListener.class) continue;
            HarmonicFocusListener harmonicFocusListener = (HarmonicFocusListener)objectArray[i + 1];
            if (bl) {
                harmonicFocusListener.focusGained(harmonicFocusEvent);
                continue;
            }
            harmonicFocusListener.focusLost(harmonicFocusEvent);
        }
    }

    public void harmonicColorChanged(HarmonicColorChangeEvent harmonicColorChangeEvent) {
        if (harmonicColorChangeEvent.getOrder() == this._harmonic.getOrder()) {
            this.updateColor();
        }
    }

    public void animate(AnimationCycleController.AnimationCycleEvent animationCycleEvent) {
        if (this.isVisible()) {
            double d = animationCycleEvent.getCyclePoint();
            int n = this._harmonic.getOrder();
            this._pieAngle = d * 360.0 * (double)(n + 1);
            this._pieAngle %= 360.0;
            this.updatePie();
        }
    }

    private class MouseFocusListener
    extends MouseInputAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            HarmonicPeriodDisplay.this.fireHarmonicFocusEvent(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            HarmonicPeriodDisplay.this.fireHarmonicFocusEvent(false);
        }
    }
}

