/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.discrete;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.charts.StringLabelTable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetZoomControl;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.charts.HarmonicPlot;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.event.HarmonicFocusEvent;
import edu.colorado.phet.fourier.event.HarmonicFocusListener;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.AnimationCycleController;
import edu.colorado.phet.fourier.view.HarmonicColors;
import edu.colorado.phet.fourier.view.HarmonicsEquation;
import edu.colorado.phet.fourier.view.discrete.DiscreteHarmonicsChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;

public class DiscreteHarmonicsView
extends GraphicLayerSet
implements SimpleObserver,
PhetZoomControl.ZoomListener,
HarmonicFocusListener,
AnimationCycleController.AnimationCycleListener {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 216);
    private static final Color BACKGROUND_COLOR = new Color(215, 215, 215);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Point TITLE_LOCATION = new Point(40, 115);
    private static final Range2D CHART_RANGE = new Range2D(-0.5, -1.336901521971921, 0.5, 1.336901521971921);
    private static final Dimension CHART_SIZE = new Dimension(540, 135);
    private static final Stroke WAVE_NORMAL_STROKE = new BasicStroke(1.0f);
    private static final Stroke WAVE_FOCUS_STROKE = new BasicStroke(2.0f);
    private static final Stroke WAVE_DIMMED_STROKE = new BasicStroke(0.5f);
    private static final Color WAVE_DIMMED_COLOR = Color.GRAY;
    private static final double[] PIXELS_PER_POINT = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private FourierSeries _fourierSeries;
    private PhetShapeGraphic _backgroundGraphic;
    private PhetTextGraphic _titleGraphic;
    private PhetImageGraphic _minimizeButton;
    private DiscreteHarmonicsChart _chartGraphic;
    private PhetZoomControl _horizontalZoomControl;
    private HarmonicsEquation _mathGraphic;
    private ArrayList _harmonicPlots;
    private int _xZoomLevel;
    private Domain _domain;
    private MathForm _mathForm;
    private int _previousNumberOfHarmonics;
    private Preset _previousPreset;
    private WaveType _previousWaveType;

    public DiscreteHarmonicsView(Component component, FourierSeries fourierSeries) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._fourierSeries = fourierSeries;
        this._fourierSeries.addObserver(this);
        this._backgroundGraphic = new PhetShapeGraphic(component);
        this._backgroundGraphic.setShape(new Rectangle(0, 0, DiscreteHarmonicsView.BACKGROUND_SIZE.width, DiscreteHarmonicsView.BACKGROUND_SIZE.height));
        this._backgroundGraphic.setPaint(BACKGROUND_COLOR);
        this._backgroundGraphic.setStroke(BACKGROUND_STROKE);
        this._backgroundGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        this.addGraphic(this._backgroundGraphic, 1.0);
        this._backgroundGraphic.setLocation(0, 0);
        String string = FourierResources.getString("DiscreteHarmonicsView.title");
        this._titleGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        this._titleGraphic.centerRegistrationPoint();
        this._titleGraphic.rotate(-1.5707963267948966);
        this._titleGraphic.setLocation(TITLE_LOCATION);
        this.addGraphic(this._titleGraphic, 2.0);
        this._chartGraphic = new DiscreteHarmonicsChart(component, CHART_RANGE, CHART_SIZE);
        this.addGraphic(this._chartGraphic, 3.0);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(60, 50);
        this._minimizeButton = new PhetImageGraphic(component, FourierConstants.MINIMIZE_BUTTON_IMAGE);
        this.addGraphic(this._minimizeButton, 4.0);
        this._minimizeButton.centerRegistrationPoint();
        this._minimizeButton.setLocation(this._minimizeButton.getWidth() / 2 + 10, this._minimizeButton.getHeight() / 2 + 5);
        this._horizontalZoomControl = new PhetZoomControl(component, 0);
        this.addGraphic(this._horizontalZoomControl, 4.0);
        int n = this._chartGraphic.getX() + DiscreteHarmonicsView.CHART_SIZE.width + 20;
        int n2 = this._chartGraphic.getY();
        this._horizontalZoomControl.setLocation(n, n2);
        this._mathGraphic = new HarmonicsEquation(component);
        this.addGraphic(this._mathGraphic, 5.0);
        this._mathGraphic.centerRegistrationPoint();
        n = this._chartGraphic.getX() + DiscreteHarmonicsView.CHART_SIZE.width / 2;
        n2 = 28;
        this._mathGraphic.setLocation(n, n2);
        this._backgroundGraphic.setIgnoreMouse(true);
        this._titleGraphic.setIgnoreMouse(true);
        this._chartGraphic.setIgnoreMouse(true);
        this._mathGraphic.setIgnoreMouse(true);
        this._horizontalZoomControl.addZoomListener(this);
        this._minimizeButton.setCursorHand();
        this._harmonicPlots = new ArrayList();
        for (n = 0; n < 11; ++n) {
            this._harmonicPlots.add(new HarmonicPlot(component, this._chartGraphic));
        }
        this.reset();
    }

    public void reset() {
        this._domain = Domain.SPACE;
        this._xZoomLevel = 0;
        this._chartGraphic.setRange(CHART_RANGE);
        this.updateLabelsAndLines();
        this.updateZoomButtons();
        this._mathForm = MathForm.WAVE_NUMBER;
        this._mathGraphic.setVisible(false);
        this.updateMath();
        this._previousNumberOfHarmonics = 0;
        this._previousPreset = Preset.UNDEFINED;
        this._previousWaveType = WaveType.UNDEFINED;
        this.update();
    }

    public PhetZoomControl getHorizontalZoomControl() {
        return this._horizontalZoomControl;
    }

    public void setMathEnabled(boolean bl) {
        this._mathGraphic.setVisible(bl);
        this.updateLabelsAndLines();
    }

    public Chart getChart() {
        return this._chartGraphic;
    }

    public void setDomainAndMathForm(Domain domain, MathForm mathForm) {
        this._domain = domain;
        this._mathForm = mathForm;
        this.updateLabelsAndLines();
        this.updateMath();
        for (int i = 0; i < this._harmonicPlots.size(); ++i) {
            HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
            harmonicPlot.setStartX(0.0);
        }
    }

    public PhetImageGraphic getMinimizeButton() {
        return this._minimizeButton;
    }

    public void setHeight(int n) {
        if (n >= 150) {
            this._backgroundGraphic.setShape(new Rectangle(0, 0, DiscreteHarmonicsView.BACKGROUND_SIZE.width, n));
            this._chartGraphic.setChartSize(DiscreteHarmonicsView.CHART_SIZE.width, n - 75);
            this._titleGraphic.setLocation(DiscreteHarmonicsView.TITLE_LOCATION.x, n / 2);
            this.setBoundsDirty();
        }
    }

    public void update() {
        if (this.isVisible()) {
            int n = this._fourierSeries.getNumberOfHarmonics();
            if (n != this._previousNumberOfHarmonics) {
                this._chartGraphic.removeAllDataSetGraphics();
                for (int i = n - 1; i >= 0; --i) {
                    HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
                    harmonicPlot.setHarmonic(this._fourierSeries.getHarmonic(i));
                    harmonicPlot.setWaveType(WaveType.SINES);
                    harmonicPlot.setPeriod(1.0 / (double)(i + 1));
                    harmonicPlot.setPixelsPerPoint(PIXELS_PER_POINT[i]);
                    harmonicPlot.setStroke(WAVE_NORMAL_STROKE);
                    harmonicPlot.setBorderColor(HarmonicColors.getInstance().getColor(i));
                    harmonicPlot.setStartX(0.0);
                    this._chartGraphic.addDataSetGraphic(harmonicPlot);
                }
                this._previousNumberOfHarmonics = n;
            } else {
                Preset preset = this._fourierSeries.getPreset();
                WaveType waveType = this._fourierSeries.getWaveType();
                if (preset != this._previousPreset || waveType != this._previousWaveType) {
                    for (int i = 0; i < this._harmonicPlots.size(); ++i) {
                        HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
                        harmonicPlot.setStartX(0.0);
                        harmonicPlot.setWaveType(waveType);
                    }
                    this._previousPreset = preset;
                    this._previousWaveType = waveType;
                }
                this.updateMath();
            }
        }
    }

    public void zoomPerformed(PhetZoomControl.ZoomEvent zoomEvent) {
        int n = zoomEvent.getZoomType();
        if (n != 2 && n != 3) {
            throw new IllegalArgumentException("unexpected event: " + zoomEvent);
        }
        this.handleHorizontalZoom(n);
    }

    public void focusGained(HarmonicFocusEvent harmonicFocusEvent) {
        for (int i = 0; i < this._harmonicPlots.size(); ++i) {
            HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
            if (harmonicPlot.getHarmonic() != harmonicFocusEvent.getHarmonic()) {
                harmonicPlot.setBorderColor(WAVE_DIMMED_COLOR);
                harmonicPlot.setStroke(WAVE_DIMMED_STROKE);
                continue;
            }
            Harmonic harmonic = harmonicPlot.getHarmonic();
            if (harmonic != null) {
                Color color = HarmonicColors.getInstance().getColor(harmonic);
                harmonicPlot.setBorderColor(color);
            }
            harmonicPlot.setStroke(WAVE_FOCUS_STROKE);
        }
    }

    public void focusLost(HarmonicFocusEvent harmonicFocusEvent) {
        for (int i = 0; i < this._harmonicPlots.size(); ++i) {
            HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
            Harmonic harmonic = harmonicPlot.getHarmonic();
            if (harmonic != null) {
                Color color = HarmonicColors.getInstance().getColor(harmonic);
                harmonicPlot.setBorderColor(color);
            }
            harmonicPlot.setStroke(WAVE_NORMAL_STROKE);
        }
    }

    private void handleHorizontalZoom(int n) {
        this._xZoomLevel = n == 2 ? ++this._xZoomLevel : --this._xZoomLevel;
        double d = Math.pow(2.0, (double)Math.abs(this._xZoomLevel) / 2.0);
        Range2D range2D = this._chartGraphic.getRange();
        double d2 = this._xZoomLevel == 0 ? 0.5 : (this._xZoomLevel > 0 ? 0.5 / d : 0.5 * d);
        range2D.setMaxX(d2);
        range2D.setMinX(-d2);
        this._chartGraphic.setRange(range2D);
        this.updateLabelsAndLines();
        this.updateZoomButtons();
    }

    private void updateLabelsAndLines() {
        StringLabelTable stringLabelTable;
        boolean bl = this._mathGraphic.isVisible();
        if (bl) {
            stringLabelTable = this._xZoomLevel > -3 ? (this._domain == Domain.TIME ? this._chartGraphic.getSymbolicTimeLabels1() : this._chartGraphic.getSymbolicSpaceLabels1()) : (this._domain == Domain.TIME ? this._chartGraphic.getSymbolicTimeLabels2() : this._chartGraphic.getSymbolicSpaceLabels2());
        } else {
            double d = this._xZoomLevel > 0 ? 0.25 : (this._xZoomLevel == 0 || this._xZoomLevel == -1 ? 0.5 : (this._xZoomLevel == -2 || this._xZoomLevel == -3 ? 1.0 : 2.0));
            stringLabelTable = this._domain == Domain.TIME ? this._chartGraphic.getActualTimeLabels(d) : this._chartGraphic.getActualSpaceLabels(d);
        }
        this._chartGraphic.getHorizontalTicks().setMajorLabels(stringLabelTable);
        if (this._domain == Domain.TIME) {
            if (this._mathGraphic.isVisible()) {
                this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.t"));
            } else {
                this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.t.units"));
            }
        } else if (this._mathGraphic.isVisible()) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x"));
        } else {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x.units"));
        }
    }

    private void updateZoomButtons() {
        Range2D range2D = this._chartGraphic.getRange();
        if (range2D.getMaxX() >= 2.0) {
            this._horizontalZoomControl.setZoomOutEnabled(false);
            this._horizontalZoomControl.setZoomInEnabled(true);
        } else if (range2D.getMaxX() <= 0.25) {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(false);
        } else {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(true);
        }
    }

    private void updateMath() {
        this._mathGraphic.setForm(this._domain, this._mathForm, this._fourierSeries.getWaveType());
        this._mathGraphic.centerRegistrationPoint();
    }

    public void animate(AnimationCycleController.AnimationCycleEvent animationCycleEvent) {
        if (this._domain == Domain.SPACE_AND_TIME) {
            double d = animationCycleEvent.getCyclePoint();
            double d2 = d * 1.0;
            for (int i = 0; i < this._harmonicPlots.size(); ++i) {
                HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
                harmonicPlot.setStartX(d2);
            }
        }
    }
}

