/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.discrete;

import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.charts.FlattenedChart;
import edu.colorado.phet.fourier.event.HarmonicFocusEvent;
import edu.colorado.phet.fourier.event.HarmonicFocusListener;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.AmplitudeSlider;
import edu.colorado.phet.fourier.view.discrete.DiscreteAmplitudesChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DiscreteAmplitudesView
extends GraphicLayerSet
implements SimpleObserver {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 195);
    private static final Color BACKGROUND_COLOR = new Color(195, 195, 195);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Range2D CHART_RANGE = new Range2D(1.0, -1.2732395447351628, 11.0, 1.2732395447351628);
    private static final Dimension CHART_SIZE = new Dimension(640, 130);
    private FourierSeries _fourierSeries;
    private FlattenedChart _flattenedChart;
    private GraphicLayerSet _slidersGraphic;
    private ArrayList _sliders;
    private EventListenerList _listenerList;
    private EventPropagator _eventPropagator;
    private int _previousNumberOfHarmonics;

    public DiscreteAmplitudesView(Component component, FourierSeries fourierSeries) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._fourierSeries = fourierSeries;
        this._fourierSeries.addObserver(this);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setShape(new Rectangle(0, 0, DiscreteAmplitudesView.BACKGROUND_SIZE.width, DiscreteAmplitudesView.BACKGROUND_SIZE.height));
        phetShapeGraphic.setPaint(BACKGROUND_COLOR);
        phetShapeGraphic.setStroke(BACKGROUND_STROKE);
        phetShapeGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        phetShapeGraphic.setLocation(0, 0);
        this.addGraphic(phetShapeGraphic, 1.0);
        String string = FourierResources.getString("DiscreteAmplitudesView.title");
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        phetTextGraphic.centerRegistrationPoint();
        phetTextGraphic.rotate(-1.5707963267948966);
        phetTextGraphic.setLocation(40, DiscreteAmplitudesView.BACKGROUND_SIZE.height / 2);
        this.addGraphic(phetTextGraphic, 2.0);
        DiscreteAmplitudesChart discreteAmplitudesChart = new DiscreteAmplitudesChart(component, CHART_RANGE, CHART_SIZE);
        discreteAmplitudesChart.setLocation(0, 0);
        discreteAmplitudesChart.setRegistrationPoint(0, 0);
        int n = 25;
        int n2 = 0;
        this._flattenedChart = new FlattenedChart(component, discreteAmplitudesChart, n, n2);
        this.addGraphic(this._flattenedChart, 3.0);
        this._flattenedChart.setRegistrationPoint(n, DiscreteAmplitudesView.CHART_SIZE.height / 2);
        this._flattenedChart.setLocation(60, 50 + DiscreteAmplitudesView.CHART_SIZE.height / 2 - n2);
        this._slidersGraphic = new GraphicLayerSet(component);
        this.addGraphic(this._slidersGraphic, 4.0);
        phetShapeGraphic.setIgnoreMouse(true);
        phetTextGraphic.setIgnoreMouse(true);
        this._flattenedChart.setIgnoreMouse(true);
        this._sliders = new ArrayList();
        this._listenerList = new EventListenerList();
        this._eventPropagator = new EventPropagator();
        this.reset();
    }

    public void reset() {
        this._previousNumberOfHarmonics = 0;
        this.update();
    }

    public ArrayList getSliders() {
        return this._sliders;
    }

    public FourierSeries getFourierSeries() {
        return this._fourierSeries;
    }

    public void update() {
        int n = this._fourierSeries.getNumberOfHarmonics();
        if (n != this._previousNumberOfHarmonics) {
            this._slidersGraphic.clear();
            int n2 = 120;
            int n3 = (DiscreteAmplitudesView.CHART_SIZE.width - n2) / 11;
            double d = 400.0 / (double)(n - 1);
            for (int i = 0; i < n; ++i) {
                Harmonic harmonic = this._fourierSeries.getHarmonic(i);
                AmplitudeSlider amplitudeSlider = null;
                if (i < this._sliders.size()) {
                    amplitudeSlider = (AmplitudeSlider)this._sliders.get(i);
                    amplitudeSlider.setHarmonic(harmonic);
                } else {
                    amplitudeSlider = new AmplitudeSlider(this.getComponent(), harmonic);
                    amplitudeSlider.addHarmonicFocusListener(this._eventPropagator);
                    amplitudeSlider.addChangeListener(this._eventPropagator);
                    this._sliders.add(amplitudeSlider);
                }
                this._slidersGraphic.addGraphic(amplitudeSlider);
                amplitudeSlider.setMaxSize(n3, DiscreteAmplitudesView.CHART_SIZE.height);
                int n4 = this._flattenedChart.getLocation().x + (i + 1) * 10 + i * n3 + n3 / 2;
                int n5 = this._flattenedChart.getLocation().y;
                amplitudeSlider.setLocation(n4, n5);
                this._previousNumberOfHarmonics = n;
            }
        }
    }

    public void addHarmonicFocusListener(HarmonicFocusListener harmonicFocusListener) {
        this._listenerList.add(HarmonicFocusListener.class, harmonicFocusListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private class EventPropagator
    implements HarmonicFocusListener,
    ChangeListener {
        private EventPropagator() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = DiscreteAmplitudesView.this._listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
        }

        public void focusGained(HarmonicFocusEvent harmonicFocusEvent) {
            Object[] objectArray = DiscreteAmplitudesView.this._listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != HarmonicFocusListener.class) continue;
                ((HarmonicFocusListener)objectArray[i + 1]).focusGained(harmonicFocusEvent);
            }
        }

        public void focusLost(HarmonicFocusEvent harmonicFocusEvent) {
            Object[] objectArray = DiscreteAmplitudesView.this._listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != HarmonicFocusListener.class) continue;
                ((HarmonicFocusListener)objectArray[i + 1]).focusLost(harmonicFocusEvent);
            }
        }
    }
}

