/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.d2c;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.WaveType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.RenderingHints;

public class D2CSumEquation
extends CompositePhetGraphic {
    private static final Color EQUATION_COLOR = Color.BLACK;
    private static final Font LHS_FONT;
    private static final Font RHS_FONT;
    private static final Font SUMMATION_SYMBOL_FONT;
    private static final Font INTEGRAL_SYMBOL_FONT;
    private static final Font RANGE_FONT;
    private HTMLGraphic _lhsGraphic;
    private HTMLGraphic _rhsGraphic;
    private CompositePhetGraphic _summationGraphic;
    private CompositePhetGraphic _integralGraphic;

    public D2CSumEquation(Component component) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._lhsGraphic = new HTMLGraphic(component, LHS_FONT, "", EQUATION_COLOR);
        this.addGraphic(this._lhsGraphic);
        this._rhsGraphic = new HTMLGraphic(component, RHS_FONT, "", EQUATION_COLOR);
        this.addGraphic(this._rhsGraphic);
        this._summationGraphic = new CompositePhetGraphic(component);
        this.addGraphic(this._summationGraphic);
        String string = "<html>" + MathStrings.C_SIGMA + "</html>";
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component, SUMMATION_SYMBOL_FONT, string, EQUATION_COLOR);
        hTMLGraphic.setLocation(0, 0);
        this._summationGraphic.addGraphic(hTMLGraphic);
        String string2 = "n = -" + MathStrings.C_INFINITY;
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(component, RANGE_FONT, string2, EQUATION_COLOR);
        int n = hTMLGraphic.getX();
        int n2 = hTMLGraphic.getY() + hTMLGraphic.getHeight();
        phetTextGraphic.setLocation(n, n2);
        this._summationGraphic.addGraphic(phetTextGraphic);
        string2 = "" + MathStrings.C_INFINITY;
        phetTextGraphic = new PhetTextGraphic(component, RANGE_FONT, string2, EQUATION_COLOR);
        n = hTMLGraphic.getX() + hTMLGraphic.getWidth() + 2;
        n2 = hTMLGraphic.getY() + 5;
        phetTextGraphic.setLocation(n, n2);
        this._summationGraphic.addGraphic(phetTextGraphic);
        this._integralGraphic = new CompositePhetGraphic(component);
        this.addGraphic(this._integralGraphic);
        string = "<html>" + MathStrings.C_INTEGRAL + "</html>";
        hTMLGraphic = new HTMLGraphic(component, SUMMATION_SYMBOL_FONT, string, EQUATION_COLOR);
        hTMLGraphic.setLocation(0, 0);
        this._integralGraphic.addGraphic(hTMLGraphic);
        string2 = "-" + MathStrings.C_INFINITY;
        phetTextGraphic = new PhetTextGraphic(component, RANGE_FONT, string2, EQUATION_COLOR);
        n = hTMLGraphic.getX() + hTMLGraphic.getWidth() + 2;
        n2 = hTMLGraphic.getY() + hTMLGraphic.getHeight() - 10;
        phetTextGraphic.setLocation(n, n2);
        this._integralGraphic.addGraphic(phetTextGraphic);
        string2 = "+" + MathStrings.C_INFINITY;
        phetTextGraphic = new PhetTextGraphic(component, RANGE_FONT, string2, EQUATION_COLOR);
        n = hTMLGraphic.getX() + hTMLGraphic.getWidth() + 2;
        n2 = hTMLGraphic.getY() + 5;
        phetTextGraphic.setLocation(n, n2);
        this._integralGraphic.addGraphic(phetTextGraphic);
        this.setForm(Domain.SPACE, false, WaveType.COSINES);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setForm(Domain domain, boolean bl, WaveType waveType) {
        this._summationGraphic.setVisible(!bl);
        this._integralGraphic.setVisible(bl);
        String string = null;
        String string2 = null;
        if (!bl) {
            if (domain == Domain.SPACE) {
                string = "<html>F(x) = </html>";
                string2 = "<html>A<sub>n</sub> sin( k<sub>n</sub>x )</html>";
            } else {
                if (domain != Domain.TIME) throw new IllegalArgumentException("invalid or unsupported domain: " + domain);
                string = "<html>F(t) = </html>";
                string2 = "<html>A<sub>n</sub> sin( " + MathStrings.C_OMEGA + "<sub>n</sub>t )</html>";
            }
        } else if (domain == Domain.SPACE) {
            string = "<html>F(x) = </html>";
            string2 = "<html>A(k) sin( kx ) dk</html>";
        } else {
            if (domain != Domain.TIME) throw new IllegalArgumentException("invalid or unsupported domain: " + domain);
            string = "<html>F(t) = </html>";
            string2 = "<html>A(" + MathStrings.C_OMEGA + ") sin( " + MathStrings.C_OMEGA + "t ) d" + MathStrings.C_OMEGA + "</html>";
        }
        if (waveType == WaveType.COSINES) {
            string2 = string2.replaceAll("sin\\(", "cos(");
        }
        this._lhsGraphic.setHTML(string);
        this._rhsGraphic.setHTML(string2);
        int n = 0;
        int n2 = 0;
        this._lhsGraphic.setLocation(n, n2);
        n = this._lhsGraphic.getX() + this._lhsGraphic.getWidth() + 5;
        n2 = -5;
        this._summationGraphic.setLocation(n, n2);
        this._integralGraphic.setLocation(n, n2);
        n = bl ? this._integralGraphic.getX() + this._integralGraphic.getWidth() + 6 : this._summationGraphic.getX() + this._summationGraphic.getWidth() + 6;
        n2 = 0;
        this._rhsGraphic.setLocation(n, n2);
    }

    static {
        RHS_FONT = LHS_FONT = new PhetFont(0, 20);
        INTEGRAL_SYMBOL_FONT = SUMMATION_SYMBOL_FONT = new PhetFont(0, 30);
        RANGE_FONT = new PhetFont(0, 12);
    }
}

