/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.sound;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.model.Harmonic;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class FourierOscillator
extends AudioInputStream
implements SimpleObserver {
    private FourierSeries _fourierSeries;
    private byte[] _buffer;
    private int _bufferLength;
    private int _bufferIndex;
    private long _remainingFrames;
    private float _volume;
    private long _streamLength;
    private int _periodLengthInFrames;
    private boolean _enabled;

    public FourierOscillator(FourierSeries fourierSeries, float f, AudioFormat audioFormat, long l) {
        super(new ByteArrayInputStream(new byte[0]), audioFormat, l);
        assert (fourierSeries != null);
        assert (f >= -1.0f && f <= 1.0f);
        assert (audioFormat != null);
        assert (l > 0L || l == -1L);
        if (audioFormat.getSampleSizeInBits() != 16 || audioFormat.isBigEndian()) {
            throw new IllegalStateException("audio format must be 16-bit little endian");
        }
        this._fourierSeries = fourierSeries;
        this._fourierSeries.addObserver(this);
        this._volume = f;
        this._streamLength = l;
        this._periodLengthInFrames = Math.round(this.getFormat().getFrameRate() / (float)this._fourierSeries.getFundamentalFrequency());
        this._bufferLength = this._periodLengthInFrames * this.getFormat().getFrameSize();
        this._buffer = new byte[this._bufferLength];
        this.generateData();
        this._remainingFrames = this._streamLength;
        this._bufferIndex = 0;
        this._enabled = true;
    }

    public void cleanup() {
        this._fourierSeries.removeObserver(this);
        this._fourierSeries = null;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        this.update();
    }

    public void setVolume(float f) {
        if (f != this._volume) {
            this._volume = f;
            this.update();
        }
    }

    public float getVolume() {
        return this._volume;
    }

    private void generateData() {
        float f = (float)Math.pow(2.0, this.getFormat().getSampleSizeInBits() - 1) - 1.0f;
        float f2 = this._volume * f / 11.0f;
        int n = 0;
        byte[] byArray = new byte[this._bufferLength];
        for (int i = 0; i < this._periodLengthInFrames; ++i) {
            float f3 = (float)i / (float)this._periodLengthInFrames;
            float f4 = this.getFourierSum(f3);
            int n2 = Math.round(f4 * f2);
            int n3 = i * this.getFormat().getFrameSize();
            byArray[n3 + 0] = (byte)(n2 & 0xFF);
            byArray[n3 + 1] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n3 + 2] = (byte)(n2 & 0xFF);
            byArray[n3 + 3] = (byte)(n2 >>> 8 & 0xFF);
            if (n2 <= n) continue;
            n = n2;
        }
        if ((float)n > f) {
            System.out.println("WARNING: audio data exceeds the sample size! " + n + " > " + f);
        }
        this.setData(byArray);
    }

    private float getFourierSum(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < this._fourierSeries.getNumberOfHarmonics(); ++i) {
            Harmonic harmonic = this._fourierSeries.getHarmonic(i);
            double d = harmonic.getAmplitude() / 1.2732395447351628;
            if (d == 0.0) continue;
            double d2 = (double)(i + 1) * 2.0 * Math.PI;
            double d3 = (double)f * d2;
            f2 += (float)(d * Math.sin(d3));
        }
        return f2;
    }

    private synchronized void setData(byte[] byArray) {
        System.arraycopy(byArray, 0, this._buffer, 0, this._bufferLength);
    }

    public void update() {
        if (this._enabled) {
            this.generateData();
        }
    }

    public int available() {
        int n = 0;
        if (this._remainingFrames == -1L) {
            n = Integer.MAX_VALUE;
        } else {
            long l = this._remainingFrames * (long)this.getFormat().getFrameSize();
            n = (int)Math.min(l, Integer.MAX_VALUE);
        }
        return n;
    }

    public int read() throws IOException {
        throw new IOException("not implemented, see javadoc");
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 % this.getFormat().getFrameSize() != 0) {
            throw new IOException("length must be an integer multiple of frame size");
        }
        int n5 = n4 = Math.min(this.available(), n2);
        while (n5 > 0) {
            n3 = this._buffer.length - this._bufferIndex;
            n3 = Math.min(n3, n5);
            System.arraycopy(this._buffer, this._bufferIndex, byArray, n, n3);
            n5 -= n3;
            n += n3;
            this._bufferIndex = (this._bufferIndex + n3) % this._buffer.length;
        }
        n3 = n4 / this.getFormat().getFrameSize();
        if (this._remainingFrames != -1L) {
            this._remainingFrames -= (long)n3;
        }
        int n6 = n4;
        if (this._remainingFrames == 0L) {
            n6 = -1;
        }
        return n6;
    }
}

