/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.module;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.control.DiscreteControlPanel;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.help.HelpBubble;
import edu.colorado.phet.fourier.help.WiggleMeGraphic;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.module.FourierAbstractModule;
import edu.colorado.phet.fourier.persistence.FourierConfig;
import edu.colorado.phet.fourier.view.AnimationCycleController;
import edu.colorado.phet.fourier.view.MinimizedView;
import edu.colorado.phet.fourier.view.discrete.DiscreteAmplitudesView;
import edu.colorado.phet.fourier.view.discrete.DiscreteHarmonicsView;
import edu.colorado.phet.fourier.view.discrete.DiscreteSumView;
import edu.colorado.phet.fourier.view.tools.HarmonicPeriodDisplay;
import edu.colorado.phet.fourier.view.tools.HarmonicPeriodTool;
import edu.colorado.phet.fourier.view.tools.HarmonicWavelengthTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class DiscreteModule
extends FourierAbstractModule
implements ApparatusPanel2.ChangeListener {
    private static final Point WAVELENGTH_TOOL_LOCATION;
    private static final Point PERIOD_TOOL_LOCATION;
    private static final Point PERIOD_DISPLAY_LOCATION;
    private static final Point WIGGLE_ME_LOCATION;
    private static final Color APPARATUS_PANEL_BACKGROUND;
    private static final Color WIGGLE_ME_COLOR;
    private FourierSeries _fourierSeries;
    private DiscreteAmplitudesView _amplitudesView;
    private DiscreteHarmonicsView _harmonicsView;
    private MinimizedView _harmonicsMinimizedView;
    private DiscreteSumView _sumView;
    private MinimizedView _sumMinimizedView;
    private HarmonicWavelengthTool _wavelengthTool;
    private HarmonicPeriodTool _periodTool;
    private HarmonicPeriodDisplay _periodDisplay;
    private DiscreteControlPanel _controlPanel;
    private AnimationCycleController _animationCycleController;
    private Dimension _canvasSize;
    private boolean _soundEnabled;

    public DiscreteModule() {
        super(FourierResources.getString("DiscreteModule.title"));
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._fourierSeries = new FourierSeries(11, 440.0);
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(this.getClock(), 710, 630);
        this._canvasSize = apparatusPanel3.getSize();
        apparatusPanel3.setBackground(APPARATUS_PANEL_BACKGROUND);
        this.setApparatusPanel(apparatusPanel3);
        apparatusPanel3.addChangeListener(this);
        this._amplitudesView = new DiscreteAmplitudesView(apparatusPanel3, this._fourierSeries);
        this._amplitudesView.setLocation(0, 0);
        apparatusPanel3.addGraphic(this._amplitudesView, 1.0);
        this._harmonicsView = new DiscreteHarmonicsView(apparatusPanel3, this._fourierSeries);
        apparatusPanel3.addGraphic(this._harmonicsView, 2.0);
        this._harmonicsMinimizedView = new MinimizedView(apparatusPanel3, FourierResources.getString("DiscreteHarmonicsView.title"));
        apparatusPanel3.addGraphic(this._harmonicsMinimizedView, 4.0);
        this._sumView = new DiscreteSumView(apparatusPanel3, this._fourierSeries);
        apparatusPanel3.addGraphic(this._sumView, 3.0);
        this._sumMinimizedView = new MinimizedView(apparatusPanel3, FourierResources.getString("DiscreteSumView.title"));
        apparatusPanel3.addGraphic(this._sumMinimizedView, 5.0);
        this._wavelengthTool = new HarmonicWavelengthTool(apparatusPanel3, this._fourierSeries.getHarmonic(0), this._harmonicsView.getChart());
        apparatusPanel3.addGraphic(this._wavelengthTool, 6.0);
        apparatusPanel3.addChangeListener(this._wavelengthTool);
        this._periodTool = new HarmonicPeriodTool(apparatusPanel3, this._fourierSeries.getHarmonic(0), this._harmonicsView.getChart());
        apparatusPanel3.addGraphic(this._periodTool, 6.0);
        apparatusPanel3.addChangeListener(this._periodTool);
        this._periodDisplay = new HarmonicPeriodDisplay(apparatusPanel3, this._fourierSeries.getHarmonic(0));
        apparatusPanel3.addGraphic(this._periodDisplay, 6.0);
        apparatusPanel3.addChangeListener(this._periodDisplay);
        this._animationCycleController = new AnimationCycleController(50.0);
        this.getClock().addClockListener(this._animationCycleController);
        this._animationCycleController.addAnimationCycleListener(this._harmonicsView);
        this._animationCycleController.addAnimationCycleListener(this._sumView);
        this._animationCycleController.addAnimationCycleListener(this._periodDisplay);
        this._controlPanel = new DiscreteControlPanel(this, this._fourierSeries, this._harmonicsView, this._sumView, this._wavelengthTool, this._periodTool, this._periodDisplay, this._animationCycleController);
        this._controlPanel.addVerticalSpace(5);
        this._controlPanel.addResetAllButton(this);
        this.setControlPanel(this._controlPanel);
        this._harmonicsView.getHorizontalZoomControl().addZoomListener(this._sumView);
        this._sumView.getHorizontalZoomControl().addZoomListener(this._harmonicsView);
        this._amplitudesView.addHarmonicFocusListener(this._harmonicsView);
        this._wavelengthTool.addHarmonicFocusListener(this._harmonicsView);
        this._periodTool.addHarmonicFocusListener(this._harmonicsView);
        this._periodDisplay.addHarmonicFocusListener(this._harmonicsView);
        this._amplitudesView.addChangeListener(this._controlPanel);
        this._harmonicsView.getMinimizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                DiscreteModule.this._harmonicsView.setVisible(false);
                DiscreteModule.this._harmonicsMinimizedView.setVisible(true);
                DiscreteModule.this.layoutViews();
            }
        });
        this._harmonicsMinimizedView.getMaximizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                DiscreteModule.this._harmonicsView.setVisible(true);
                DiscreteModule.this._harmonicsMinimizedView.setVisible(false);
                DiscreteModule.this.setWaitCursorEnabled(true);
                DiscreteModule.this.layoutViews();
                DiscreteModule.this.setWaitCursorEnabled(false);
            }
        });
        this._sumView.getMinimizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                DiscreteModule.this._sumView.setVisible(false);
                DiscreteModule.this._sumMinimizedView.setVisible(true);
                DiscreteModule.this.layoutViews();
            }
        });
        this._sumMinimizedView.getMaximizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                DiscreteModule.this._sumView.setVisible(true);
                DiscreteModule.this._sumMinimizedView.setVisible(false);
                DiscreteModule.this.setWaitCursorEnabled(true);
                DiscreteModule.this.layoutViews();
                DiscreteModule.this.setWaitCursorEnabled(false);
            }
        });
        ThisWiggleMeGraphic thisWiggleMeGraphic = new ThisWiggleMeGraphic(apparatusPanel3, this.getClock());
        thisWiggleMeGraphic.setLocation(WIGGLE_ME_LOCATION);
        apparatusPanel3.addGraphic(thisWiggleMeGraphic, Double.POSITIVE_INFINITY);
        thisWiggleMeGraphic.setEnabled(true);
        HelpBubble helpBubble = new HelpBubble(apparatusPanel3, FourierResources.getString("DiscreteModule.help.sliders"));
        helpBubble.pointAt(new Point(94, 117), 0, 30);
        this.addHelpItem(helpBubble);
        HelpBubble helpBubble2 = new HelpBubble(apparatusPanel3, FourierResources.getString("DiscreteModule.help.textfields"));
        helpBubble2.pointAt(new Point(94, 44), 0, 15);
        this.addHelpItem(helpBubble2);
        HelpBubble helpBubble3 = new HelpBubble(apparatusPanel3, FourierResources.getString("DiscreteModule.help.minimize"));
        helpBubble3.pointAt(this._harmonicsView.getMinimizeButton(), 7, 15);
        this.addHelpItem(helpBubble3);
        HelpBubble helpBubble4 = new HelpBubble(apparatusPanel3, FourierResources.getString("DiscreteModule.help.wavelengthTool"));
        helpBubble4.pointAt(this._wavelengthTool, 1, 15);
        helpBubble4.setVisible(false);
        this.addHelpItem(helpBubble4);
        HelpBubble helpBubble5 = new HelpBubble(apparatusPanel3, FourierResources.getString("DiscreteModule.help.periodTool"));
        helpBubble5.pointAt(this._periodTool, 1, 15);
        helpBubble5.setVisible(false);
        this.addHelpItem(helpBubble5);
        HelpBubble helpBubble6 = new HelpBubble(apparatusPanel3, FourierResources.getString("DiscreteModule.help.periodDisplay"));
        helpBubble6.pointAt(this._periodDisplay, 10, 15);
        helpBubble6.setVisible(false);
        this.addHelpItem(helpBubble6);
        this.reset();
        this._fourierSeries.addObserver(thisWiggleMeGraphic);
    }

    public void reset() {
        this._controlPanel.setSoundEnabled(false);
        this._fourierSeries.setNumberOfHarmonics(11);
        this._fourierSeries.setFundamentalFrequency(440.0);
        this._fourierSeries.setPreset(Preset.SINE_COSINE);
        this._fourierSeries.setWaveType(WaveType.SINES);
        this._amplitudesView.reset();
        this._harmonicsView.reset();
        this._sumView.reset();
        this._harmonicsView.setVisible(true);
        this._harmonicsMinimizedView.setVisible(!this._harmonicsView.isVisible());
        this._sumView.setVisible(true);
        this._sumMinimizedView.setVisible(!this._sumView.isVisible());
        this.layoutViews();
        this._wavelengthTool.setVisible(false);
        this._wavelengthTool.setLocation(WAVELENGTH_TOOL_LOCATION);
        this._periodTool.setVisible(false);
        this._periodTool.setLocation(PERIOD_TOOL_LOCATION);
        this._periodDisplay.setVisible(false);
        this._periodDisplay.setLocation(PERIOD_DISPLAY_LOCATION);
        this._controlPanel.reset();
        this._soundEnabled = this._controlPanel.isSoundEnabled();
    }

    private void layoutViews() {
        int n = this._canvasSize.height;
        int n2 = n - this._amplitudesView.getHeight();
        this._harmonicsMinimizedView.setVisible(!this._harmonicsView.isVisible());
        this._sumMinimizedView.setVisible(!this._sumView.isVisible());
        if (this._harmonicsView.isVisible() && this._sumView.isVisible()) {
            this._harmonicsView.setHeight(n2 / 2);
            this._harmonicsView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumView.setHeight(n2 / 2);
            this._sumView.setLocation(this._amplitudesView.getX(), this._harmonicsView.getY() + this._harmonicsView.getHeight());
        } else if (this._harmonicsView.isVisible()) {
            this._harmonicsView.setHeight(n2 - this._sumMinimizedView.getHeight());
            this._harmonicsView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumMinimizedView.setLocation(this._amplitudesView.getX(), this._harmonicsView.getY() + this._harmonicsView.getHeight());
        } else if (this._sumView.isVisible()) {
            this._harmonicsMinimizedView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumView.setHeight(n2 - this._harmonicsMinimizedView.getHeight());
            this._sumView.setLocation(this._amplitudesView.getX(), this._harmonicsMinimizedView.getY() + this._harmonicsMinimizedView.getHeight());
        } else {
            this._harmonicsMinimizedView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumMinimizedView.setLocation(this._amplitudesView.getX(), this._harmonicsMinimizedView.getY() + this._harmonicsMinimizedView.getHeight());
        }
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._canvasSize.setSize(changeEvent.getCanvasSize());
        this.layoutViews();
    }

    public void activate() {
        super.activate();
        this._controlPanel.setSoundEnabled(this._soundEnabled);
    }

    public void deactivate() {
        super.deactivate();
        this._soundEnabled = this._controlPanel.isSoundEnabled();
        this._controlPanel.setSoundEnabled(false);
    }

    public FourierConfig.DiscreteConfig save() {
        FourierConfig.DiscreteConfig discreteConfig = new FourierConfig.DiscreteConfig();
        discreteConfig.setPresetName(this._controlPanel.getPreset().getName());
        discreteConfig.setShowInfiniteEnabled(this._controlPanel.isShowInfiniteEnabled());
        discreteConfig.setDomainName(this._controlPanel.getDomain().getName());
        discreteConfig.setWaveTypeName(this._controlPanel.getWaveType().getName());
        discreteConfig.setWavelengthToolEnabled(this._controlPanel.isWavelengthToolEnabled());
        discreteConfig.setPeriodToolEnabled(this._controlPanel.isPeriodToolEnabled());
        discreteConfig.setShowMathEnabled(this._controlPanel.isShowMathEnabled());
        discreteConfig.setMathFormName(this._controlPanel.getMathForm().getName());
        discreteConfig.setExpandSumEnabled(this._controlPanel.isExpandSumEnabled());
        discreteConfig.setSoundEnabled(this._controlPanel.isSoundEnabled());
        discreteConfig.setSoundVolume(this._controlPanel.getSoundVolume());
        discreteConfig.setHarmonicsViewMaximized(this._harmonicsView.isVisible());
        discreteConfig.setSumViewMaximized(this._sumView.isVisible());
        discreteConfig.setNumberOfHarmonics(this._fourierSeries.getNumberOfHarmonics());
        double[] dArray = new double[this._fourierSeries.getNumberOfHarmonics()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this._fourierSeries.getHarmonic(i).getAmplitude();
        }
        discreteConfig.setAmplitudes(dArray);
        return discreteConfig;
    }

    public void load(FourierConfig.DiscreteConfig discreteConfig) {
        this._controlPanel.setPreset(Preset.getByName(discreteConfig.getPresetName()));
        this._controlPanel.setNumberOfHarmonics(discreteConfig.getNumberOfHarmonics());
        this._controlPanel.setShowInfiniteEnabled(discreteConfig.isShowInfiniteEnabled());
        this._controlPanel.setDomain(Domain.getByName(discreteConfig.getDomainName()));
        this._controlPanel.setWaveType(WaveType.getByName(discreteConfig.getWaveTypeName()));
        this._controlPanel.setWavelengthToolEnabled(discreteConfig.isWavelengthToolEnabled());
        this._controlPanel.setPeriodToolEnabled(discreteConfig.isPeriodToolEnabled());
        this._controlPanel.setShowMathEnabled(discreteConfig.isShowMathEnabled());
        this._controlPanel.setMathForm(MathForm.getByName(discreteConfig.getMathFormName()));
        this._controlPanel.setExpandSumEnabled(discreteConfig.isExpandSumEnabled());
        this._controlPanel.setSoundEnabled(discreteConfig.isSoundEnabled());
        this._controlPanel.setSoundVolume(discreteConfig.getSoundVolume());
        this._harmonicsView.setVisible(discreteConfig.isHarmonicsViewMaximized());
        this._sumView.setVisible(discreteConfig.isSumViewMaximized());
        this.layoutViews();
        this._fourierSeries.setNumberOfHarmonics(discreteConfig.getNumberOfHarmonics());
        double[] dArray = discreteConfig.getAmplitudes();
        for (int i = 0; i < dArray.length; ++i) {
            this._fourierSeries.getHarmonic(i).setAmplitude(dArray[i]);
        }
    }

    static {
        PERIOD_TOOL_LOCATION = WAVELENGTH_TOOL_LOCATION = new Point(440, 236);
        PERIOD_DISPLAY_LOCATION = new Point(655, 355);
        WIGGLE_ME_LOCATION = new Point(115, 153);
        APPARATUS_PANEL_BACKGROUND = new Color(240, 255, 255);
        WIGGLE_ME_COLOR = Color.RED;
    }

    private static class ThisWiggleMeGraphic
    extends WiggleMeGraphic
    implements SimpleObserver {
        private MouseInputAdapter _mouseListener;

        public ThisWiggleMeGraphic(Component component, IClock iClock) {
            super(component, iClock);
            this.setText(FourierResources.getString("DiscreteModule.wiggleMe"), WIGGLE_ME_COLOR);
            this.addArrow(1, new Vector2D(0.0, -30.0), WIGGLE_ME_COLOR);
            this.setRange(0, 10);
            this.setCycleDuration(5);
            this.setEnabled(true);
            this._mouseListener = new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    ThisWiggleMeGraphic.this.setEnabled(false);
                    ThisWiggleMeGraphic.this.getComponent().removeMouseListener(this);
                }
            };
            component.addMouseListener(this._mouseListener);
        }

        public void update() {
            this.setEnabled(false);
            this.getComponent().removeMouseListener(this._mouseListener);
        }
    }
}

