/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control.sliders;

import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.control.sliders.AbstractFourierSlider;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.JLabel;

public class WavePacketKWidthSlider
extends AbstractFourierSlider {
    private DecimalFormat _widthFormatter;

    public WavePacketKWidthSlider() {
        super(FourierResources.getString("WavePacketKWidthSlider.format.space"));
        this.getSlider().setMinimum(1000);
        this.getSlider().setMaximum(12566);
        this.getSlider().setInverted(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(12566), new JLabel("1"));
        hashtable.put(new Integer(10424), new JLabel("" + MathStrings.C_PI));
        hashtable.put(new Integer(7283), new JLabel("2" + MathStrings.C_PI));
        hashtable.put(new Integer(4141), new JLabel("3" + MathStrings.C_PI));
        hashtable.put(new Integer(1000), new JLabel("4" + MathStrings.C_PI));
        this.getSlider().setLabelTable(hashtable);
        this.getSlider().setPaintLabels(true);
        this.getSlider().setMajorTickSpacing(11566);
        this.getSlider().setMinorTickSpacing(3141);
        this.getSlider().setPaintTicks(true);
    }

    public void setValue(double d) {
        int n = (int)(13566.370614359172 - d * 1000.0);
        this.getSlider().setValue(n);
    }

    public double getValue() {
        int n = this.getSlider().getValue();
        double d = (13566.370614359172 - (double)n) / 1000.0;
        return d;
    }

    protected void updateLabel() {
        String string = this.getFormat();
        double d = this.getValue();
        if (this._widthFormatter == null) {
            this._widthFormatter = new DecimalFormat("#.##");
        }
        String string2 = this._widthFormatter.format(d);
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(string, objectArray);
        this.getLabel().setText(string3);
    }
}

