/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control.sliders;

import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.control.sliders.AbstractFourierSlider;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.JLabel;

public class WavePacketCenterSlider
extends AbstractFourierSlider {
    private DecimalFormat _formatter;

    public WavePacketCenterSlider() {
        super(FourierResources.getString("WavePacketCenterSlider.format.space"));
        this.getSlider().setMinimum(900);
        this.getSlider().setMaximum(1500);
        this.getSlider().setValue(1200);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(900), new JLabel("9" + MathStrings.C_PI));
        hashtable.put(new Integer(1200), new JLabel("12" + MathStrings.C_PI));
        hashtable.put(new Integer(1500), new JLabel("15" + MathStrings.C_PI));
        this.getSlider().setLabelTable(hashtable);
        this.getSlider().setPaintLabels(true);
        this.getSlider().setMajorTickSpacing(300);
        this.getSlider().setMinorTickSpacing(100);
        this.getSlider().setSnapToTicks(false);
        this.getSlider().setPaintTicks(true);
    }

    public void setValue(double d) {
        if (d > 47.12388980384689 || d < Math.PI * 9) {
            throw new IllegalArgumentException("illegal k0 value: " + d);
        }
        int n = (int)(d * 100.0 / Math.PI);
        this.getSlider().setValue(n);
    }

    public double getValue() {
        int n = this.getSlider().getValue();
        return (double)n * Math.PI / 100.0;
    }

    protected void updateLabel() {
        String string = this.getFormat();
        double d = this.getValue();
        if (this._formatter == null) {
            this._formatter = new DecimalFormat("#.#");
        }
        String string2 = this._formatter.format(d);
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(string, objectArray);
        this.getLabel().setText(string3);
    }
}

