/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.control.FourierAbstractControlPanel;
import edu.colorado.phet.fourier.control.FourierComboBox;
import edu.colorado.phet.fourier.control.FourierTitledPanel;
import edu.colorado.phet.fourier.enums.GameLevel;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.module.FourierAbstractModule;
import edu.colorado.phet.fourier.view.game.GameManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GameControlPanel
extends FourierAbstractControlPanel
implements SimpleObserver {
    private static final DecimalFormat AMPLITUDE_FORMAT = new DecimalFormat("0.00");
    private GameManager _gameManager;
    private FourierComboBox _levelComboBox;
    private FourierComboBox _presetComboBox;
    private JButton _newGameButton;
    private JButton _hintButton;
    private JLabel _hintText;
    private int _hintLevel;
    private ArrayList _levelChoices;
    private ArrayList _presetChoices;
    private EventListener _eventListener;

    public GameControlPanel(FourierAbstractModule fourierAbstractModule, GameManager gameManager) {
        super(fourierAbstractModule);
        assert (gameManager != null);
        this._gameManager = gameManager;
        this._gameManager.getRandomFourierSeries().addObserver(this);
        int n = FourierResources.getInt("GameControlPanel.width", 275);
        this.setMinimumWidth(n);
        FourierTitledPanel fourierTitledPanel = new FourierTitledPanel(FourierResources.getString("GameControlPanel.gameControls"));
        Object object = FourierResources.getString("GameControlPanel.level");
        this._levelChoices = new ArrayList();
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL1, "1 (" + FourierResources.getString("GameControlPanel.level.easiest") + ")"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL2, "2"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL3, "3"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL4, "4"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL5, "5"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL6, "6"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL7, "7"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL8, "8"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL9, "9"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.LEVEL10, "10 ( " + FourierResources.getString("GameControlPanel.level.hardest") + ")"));
        this._levelChoices.add(new FourierComboBox.Choice(GameLevel.PRESET, FourierResources.getString("GameControlPanel.level.preset")));
        this._levelComboBox = new FourierComboBox((String)object, this._levelChoices);
        this._levelComboBox.getComboBox().setMaximumRowCount(this._levelChoices.size());
        object = FourierResources.getString("GameControlPanel.preset");
        this._presetChoices = new ArrayList();
        this._presetChoices.add(new FourierComboBox.Choice(Preset.SINE_COSINE, FourierResources.getString("preset.sine")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.TRIANGLE, FourierResources.getString("preset.triangle")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.SQUARE, FourierResources.getString("preset.square")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.SAWTOOTH, FourierResources.getString("preset.sawtooth")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.WAVE_PACKET, FourierResources.getString("preset.wavePacket")));
        this._presetComboBox = new FourierComboBox((String)object, this._presetChoices);
        this._presetComboBox.getComboBox().setMaximumRowCount(this._presetChoices.size());
        this._newGameButton = new JButton(FourierResources.getString("GameControlPanel.newGame"));
        object = new JPanel();
        Serializable serializable = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setAnchor(17);
        ((EasyGridBagLayout)serializable).setMinimumWidth(0, 25);
        int n2 = 0;
        int n3 = 1;
        ((EasyGridBagLayout)serializable).addComponent(this._levelComboBox, n2++, n3);
        ((EasyGridBagLayout)serializable).addComponent(this._presetComboBox, n2++, n3);
        ((EasyGridBagLayout)serializable).addComponent(this._newGameButton, n2++, n3);
        fourierTitledPanel.setLayout(new BorderLayout());
        fourierTitledPanel.add((Component)object, "West");
        object = new FourierTitledPanel(FourierResources.getString("GameControlPanel.hints"));
        this._hintButton = new JButton();
        this._hintText = new JLabel();
        serializable = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setMinimumWidth(0, 25);
        n3 = 0;
        int n4 = 1;
        easyGridBagLayout.addComponent(this._hintButton, n3++, n4);
        easyGridBagLayout.addComponent(this._hintText, n3++, n4);
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)serializable, "West");
        this.addFullWidth(fourierTitledPanel);
        this.addVerticalSpace(10);
        this.addFullWidth((Component)object);
        this.reset();
        this._eventListener = new EventListener();
        this._newGameButton.addActionListener(this._eventListener);
        this._hintButton.addActionListener(this._eventListener);
        this._levelComboBox.addItemListener(this._eventListener);
        this._presetComboBox.addItemListener(this._eventListener);
    }

    public void setGameLevel(GameLevel gameLevel) {
        if (gameLevel != null) {
            this._levelComboBox.setSelectedKey(gameLevel);
            this.handleLevel();
        }
    }

    public GameLevel getGameLevel() {
        return (GameLevel)this._levelComboBox.getSelectedKey();
    }

    public void setPreset(Preset preset) {
        if (preset != null) {
            this._presetComboBox.setSelectedKey(preset);
            this.handlePreset();
        }
    }

    public Preset getPreset() {
        return (Preset)this._presetComboBox.getSelectedKey();
    }

    public void reset() {
        this._levelComboBox.setSelectedKey(GameLevel.LEVEL1);
        this._presetComboBox.setSelectedKey(Preset.SINE_COSINE);
        this._presetComboBox.setEnabled(this._levelComboBox.getSelectedKey() == GameLevel.PRESET);
        this._gameManager.setGameLevel((GameLevel)this._levelComboBox.getSelectedKey());
        if (this._levelComboBox.getSelectedKey() == GameLevel.PRESET) {
            this._gameManager.setPreset((Preset)this._presetComboBox.getSelectedKey());
        } else {
            this._gameManager.setPreset(Preset.CUSTOM);
        }
        this.resetHints();
    }

    private void resetHints() {
        this._hintLevel = 0;
        this._hintText.setText("");
        this._hintButton.setText(FourierResources.getString("GameControlPanel.hintButton0"));
        this._hintButton.setEnabled(true);
    }

    public void update() {
        this.resetHints();
    }

    private void handleLevel() {
        this.setWaitCursorEnabled(true);
        GameLevel gameLevel = (GameLevel)this._levelComboBox.getSelectedKey();
        this._presetComboBox.setEnabled(gameLevel == GameLevel.PRESET);
        if (gameLevel == GameLevel.PRESET) {
            Preset preset = (Preset)this._presetComboBox.getSelectedKey();
            this._gameManager.setPreset(preset);
        }
        this._gameManager.setGameLevel(gameLevel);
        this.setWaitCursorEnabled(false);
    }

    private void handlePreset() {
        this.setWaitCursorEnabled(true);
        Preset preset = (Preset)this._presetComboBox.getSelectedKey();
        this._gameManager.setPreset(preset);
        this.setWaitCursorEnabled(false);
    }

    private void handleNewGame() {
        this.setWaitCursorEnabled(true);
        this._gameManager.newGame();
        this.setWaitCursorEnabled(false);
    }

    private void handleHint() {
        FourierSeries fourierSeries = this._gameManager.getRandomFourierSeries();
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        for (int i = 0; i < fourierSeries.getNumberOfHarmonics(); ++i) {
            double d = fourierSeries.getHarmonic(i).getAmplitude();
            if (d == 0.0) continue;
            ++n;
            int n2 = 0;
            n2 = d < 0.0 ? (int)(100.0 * d - 0.005) : (int)(100.0 * d + 0.005);
            double d2 = (double)n2 * 0.01;
            String string4 = AMPLITUDE_FORMAT.format(d2);
            string = string + "<br>A<sub>?</sub> = ?";
            string2 = string2 + "<br>A<sub>" + (i + 1) + "</sub> = ?";
            string3 = string3 + "<br>A<sub>" + (i + 1) + "</sub> = " + string4;
        }
        if (this._hintLevel == 0) {
            String string5 = null;
            if (n == 1) {
                string5 = FourierResources.getString("GameControlPanel.hint0.singular");
            } else {
                String string6 = FourierResources.getString("GameControlPanel.hint0.plural");
                Object[] objectArray = new Object[]{new Integer(n)};
                string5 = MessageFormat.format(string6, objectArray);
            }
            String string7 = "<html>" + string5 + "<br>" + string + "</html>";
            this._hintText.setText(string7);
            this._hintButton.setText(FourierResources.getString("GameControlPanel.hintButton1"));
        } else if (this._hintLevel == 1) {
            String string8 = "<html>";
            string8 = n == 1 ? string8 + FourierResources.getString("GameControlPanel.hint1.singular") : string8 + FourierResources.getString("GameControlPanel.hint1.plural");
            string8 = string8 + "<br>" + string2 + "</html>";
            this._hintText.setText(string8);
            this._hintButton.setText(FourierResources.getString("GameControlPanel.hintButton2"));
        } else {
            String string9 = "<html>";
            string9 = n == 1 ? string9 + FourierResources.getString("GameControlPanel.hint2.singular") : string9 + FourierResources.getString("GameControlPanel.hint2.plural");
            string9 = string9 + "<br>" + string3 + "</html>";
            this._hintText.setText(string9);
            this._hintButton.setEnabled(false);
        }
        ++this._hintLevel;
    }

    private class EventListener
    implements ActionListener,
    ItemListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GameControlPanel.this._newGameButton) {
                GameControlPanel.this.handleNewGame();
            } else if (actionEvent.getSource() == GameControlPanel.this._hintButton) {
                GameControlPanel.this.handleHint();
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == GameControlPanel.this._levelComboBox.getComboBox()) {
                    GameControlPanel.this.handleLevel();
                } else if (itemEvent.getSource() == GameControlPanel.this._presetComboBox.getComboBox()) {
                    GameControlPanel.this.handlePreset();
                } else {
                    throw new IllegalArgumentException("unexpected event: " + itemEvent);
                }
            }
        }
    }
}

