/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.fourier.charts.AbstractWavePacketWidthPlot;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import java.awt.Component;
import java.awt.geom.Point2D;

public class WavePacketKWidthPlot
extends AbstractWavePacketWidthPlot {
    public WavePacketKWidthPlot(Component component, Chart chart, GaussianWavePacket gaussianWavePacket) {
        super(component, chart, gaussianWavePacket);
    }

    public void setDomain(Domain domain) {
        if (domain == Domain.SPACE) {
            this.setLabel("<html>2\u03c3<sub>k</sub></html>");
        } else if (domain == Domain.TIME) {
            this.setLabel("<html>2\u03c3<sub>\u03c9</sub></html>");
        }
    }

    protected double getModelWidth() {
        return 2.0 * this.getWavePacket().getDeltaK();
    }

    protected Point2D getModelLocation() {
        double d = this.getWavePacket().getDeltaK();
        double d2 = this.getWavePacket().getK0();
        double d3 = this.getWavePacket().getK1();
        double d4 = d2;
        double d5 = GaussianWavePacket.getAmplitude(d2 + d, d2, d);
        if (d3 != 0.0) {
            d5 = d3 * d5;
        }
        return new Point2D.Double(d4, d5);
    }
}

