/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.fourier.charts.WidthPlot;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.geom.Point2D;

public abstract class AbstractWavePacketWidthPlot
extends WidthPlot
implements SimpleObserver {
    private static final Font LABEL_FONT = new PhetFont(1, 16);
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Color LABEL_BACKGROUND_COLOR = new Color(255, 255, 255, 150);
    private static final Color ARROW_COLOR = Color.RED;
    private GaussianWavePacket _wavePacket;

    public AbstractWavePacketWidthPlot(Component component, Chart chart, GaussianWavePacket gaussianWavePacket) {
        super(component, chart);
        assert (gaussianWavePacket != null);
        this._wavePacket = gaussianWavePacket;
        this._wavePacket.addObserver(this);
        this.setLabelFont(LABEL_FONT);
        this.setLabelColor(LABEL_COLOR);
        this.setLabelBackground(LABEL_BACKGROUND_COLOR);
        this.setArrowColor(ARROW_COLOR);
    }

    public void cleanup() {
        super.cleanup();
        this._wavePacket.removeObserver(this);
        this._wavePacket = null;
    }

    protected GaussianWavePacket getWavePacket() {
        return this._wavePacket;
    }

    protected abstract double getModelWidth();

    protected abstract Point2D getModelLocation();

    public void update() {
        double d = this.getModelWidth();
        this.setGraphicWidth(d);
        Point2D point2D = this.getModelLocation();
        this.getDataSet().clear();
        this.getDataSet().addPoint(point2D);
    }
}

