/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.fourier.control.FourierOptionsMenu;
import edu.colorado.phet.fourier.module.D2CModule;
import edu.colorado.phet.fourier.module.DiscreteModule;
import edu.colorado.phet.fourier.module.GameModule;
import edu.colorado.phet.fourier.persistence.FourierConfig;
import edu.colorado.phet.fourier.view.HarmonicColors;
import java.awt.Color;

public class FourierApplication
extends PiccoloPhetApplication {
    private DiscreteModule _discreteModule;
    private GameModule _gameModule;
    private D2CModule _d2cModule;
    private XMLPersistenceManager _persistenceManager;

    public FourierApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        this._discreteModule = new DiscreteModule();
        this.addModule(this._discreteModule);
        this._gameModule = new GameModule();
        this.addModule(this._gameModule);
        this._d2cModule = new D2CModule();
        this.addModule(this._d2cModule);
    }

    private void initMenubar() {
        PhetFrame phetFrame = this.getPhetFrame();
        phetFrame.addFileSaveLoadMenuItems();
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(phetFrame);
        }
        FourierOptionsMenu fourierOptionsMenu = new FourierOptionsMenu(this);
        this.getPhetFrame().addMenu(fourierOptionsMenu);
    }

    public void save() {
        FourierConfig fourierConfig = new FourierConfig();
        FourierConfig.GlobalConfig globalConfig = fourierConfig.getGlobalConfig();
        fourierConfig.setGlobalConfig(globalConfig);
        globalConfig.setVersionNumber(this.getSimInfo().getVersion().formatForTitleBar());
        int[] nArray = new int[HarmonicColors.getInstance().getNumberOfColors()];
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            Color color = HarmonicColors.getInstance().getColor(i);
            nArray[i] = color.getRed();
            nArray2[i] = color.getGreen();
            nArray3[i] = color.getBlue();
        }
        globalConfig.setHarmonicColorsRed(nArray);
        globalConfig.setHarmonicColorsGreen(nArray2);
        globalConfig.setHarmonicColorsBlue(nArray3);
        fourierConfig.setDiscreteConfig(this._discreteModule.save());
        fourierConfig.setGameConfig(this._gameModule.save());
        fourierConfig.setD2CConfig(this._d2cModule.save());
        this._persistenceManager.save(fourierConfig);
    }

    public void load() {
        Object object = this._persistenceManager.load();
        if (object != null) {
            if (object instanceof FourierConfig) {
                FourierConfig fourierConfig = (FourierConfig)object;
                int[] nArray = fourierConfig.getGlobalConfig().getHarmonicColorsRed();
                int[] nArray2 = fourierConfig.getGlobalConfig().getHarmonicColorsGreen();
                int[] nArray3 = fourierConfig.getGlobalConfig().getHarmonicColorsBlue();
                for (int i = 0; i < nArray.length; ++i) {
                    HarmonicColors.getInstance().setColor(i, new Color(nArray[i], nArray2[i], nArray3[i]));
                }
                this._discreteModule.load(fourierConfig.getDiscreteConfig());
                this._gameModule.load(fourierConfig.getGameConfig());
                this._d2cModule.load(fourierConfig.getD2CConfig());
            } else {
                String string = PhetCommonResources.getString("XMLPersistenceManager.message.notAConfigFile");
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(stringArray, "fourier", FourierApplication.class);
    }
}

