/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetcomponents;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class PhetZoomControl
extends GraphicLayerSet {
    private static final Point IN_LOCATION = new Point(31, 13);
    private static final Point OUT_LOCATION = new Point(3, 13);
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private int _orientation;
    private PhetImageGraphic _inButton;
    private PhetImageGraphic _inButtonPressed;
    private PhetImageGraphic _outButton;
    private PhetImageGraphic _outButtonPressed;
    private EventListenerList _listenerList;

    public PhetZoomControl(Component component, int n) {
        super(component);
        this._orientation = n;
        PhetImageGraphic phetImageGraphic = n == 0 ? new PhetImageGraphic(component, "images/zoom/zoomBackgroundHorizontal.png") : new PhetImageGraphic(component, "images/zoom/zoomBackgroundVertical.png");
        this.addGraphic(phetImageGraphic);
        this._inButton = new PhetImageGraphic(component, "images/zoom/zoomInButton.png");
        this._inButtonPressed = new PhetImageGraphic(component, "images/zoom/zoomInButtonPressed.png");
        this._inButton.setLocation(IN_LOCATION);
        this._inButtonPressed.setLocation(IN_LOCATION);
        this.addGraphic(this._inButton);
        this.addGraphic(this._inButtonPressed);
        this._outButton = new PhetImageGraphic(component, "images/zoom/zoomOutButton.png");
        this._outButtonPressed = new PhetImageGraphic(component, "images/zoom/zoomOutButtonPressed.png");
        this._outButton.setLocation(OUT_LOCATION);
        this._outButtonPressed.setLocation(OUT_LOCATION);
        this.addGraphic(this._outButton);
        this.addGraphic(this._outButtonPressed);
        phetImageGraphic.setIgnoreMouse(true);
        this._inButton.setCursorHand();
        this._inButtonPressed.setCursorHand();
        this._outButton.setCursorHand();
        this._outButtonPressed.setCursorHand();
        EventListener eventListener = new EventListener();
        this._inButton.addMouseInputListener(eventListener);
        this._inButtonPressed.addMouseInputListener(eventListener);
        this._outButton.addMouseInputListener(eventListener);
        this._outButtonPressed.addMouseInputListener(eventListener);
        this._inButtonPressed.setVisible(false);
        this._outButtonPressed.setVisible(false);
        this._listenerList = new EventListenerList();
    }

    public void setZoomInEnabled(boolean bl) {
        this._inButton.setVisible(bl);
    }

    public void setZoomOutEnabled(boolean bl) {
        this._outButton.setVisible(bl);
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this._listenerList.add(ZoomListener.class, zoomListener);
    }

    private void fireZoomEvent(int n) {
        ZoomEvent zoomEvent = new ZoomEvent(this, n);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ZoomListener.class) continue;
            ((ZoomListener)objectArray[i + 1]).zoomPerformed(zoomEvent);
        }
    }

    private class EventListener
    extends MouseInputAdapter {
        private boolean _inPressed;
        private boolean _outPressed;

        public void mousePressed(MouseEvent mouseEvent) {
            if (PhetZoomControl.this._inButton.getBounds().contains(mouseEvent.getPoint())) {
                if (!PhetZoomControl.this._inButtonPressed.isVisible()) {
                    PhetZoomControl.this._inButtonPressed.setVisible(true);
                    this._inPressed = true;
                }
            } else if (PhetZoomControl.this._outButton.getBounds().contains(mouseEvent.getPoint()) && !PhetZoomControl.this._outButtonPressed.isVisible()) {
                PhetZoomControl.this._outButtonPressed.setVisible(true);
                this._outPressed = true;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this._inPressed) {
                PhetZoomControl.this._inButtonPressed.setVisible(false);
                this._inPressed = false;
                if (PhetZoomControl.this._inButtonPressed.getBounds().contains(mouseEvent.getPoint())) {
                    Cursor cursor = PhetZoomControl.this.getComponent().getCursor();
                    PhetZoomControl.this.getComponent().setCursor(WAIT_CURSOR);
                    if (PhetZoomControl.this._orientation == 0) {
                        PhetZoomControl.this.fireZoomEvent(2);
                    } else {
                        PhetZoomControl.this.fireZoomEvent(0);
                    }
                    PhetZoomControl.this.getComponent().setCursor(cursor);
                }
            } else if (this._outPressed) {
                PhetZoomControl.this._outButtonPressed.setVisible(false);
                this._outPressed = false;
                if (PhetZoomControl.this._outButtonPressed.getBounds().contains(mouseEvent.getPoint())) {
                    Cursor cursor = PhetZoomControl.this.getComponent().getCursor();
                    PhetZoomControl.this.getComponent().setCursor(WAIT_CURSOR);
                    if (PhetZoomControl.this._orientation == 0) {
                        PhetZoomControl.this.fireZoomEvent(3);
                    } else {
                        PhetZoomControl.this.fireZoomEvent(1);
                    }
                    PhetZoomControl.this.getComponent().setCursor(cursor);
                }
            }
        }
    }

    public class ZoomEvent
    extends EventObject {
        private int _zoomType;

        public ZoomEvent(Object object, int n) {
            super(object);
            assert (this.isValidZoomType(n));
            this._zoomType = n;
        }

        public int getZoomType() {
            return this._zoomType;
        }

        public boolean isValidZoomType(int n) {
            return n == 0 || n == 1 || n == 2 || n == 3;
        }
    }

    public static interface ZoomListener
    extends java.util.EventListener {
        public void zoomPerformed(ZoomEvent var1);
    }
}

