/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class SinePlot
extends LinePlot {
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private double _period;
    private double _amplitude;
    private double _startX;
    private boolean _cosineEnabled;
    private boolean _showZeroAmplitude;
    private double _pixelsPerPoint;
    private Point2D[] _points;

    public SinePlot(Component component, Chart chart) {
        super(component, chart);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._period = 1.0;
        this._amplitude = 0.0;
        this._startX = 0.0;
        this._cosineEnabled = false;
        this._showZeroAmplitude = true;
        this._pixelsPerPoint = 1.0;
        this._points = null;
        this.setDataSet(new DataSet());
        this.setBorderColor(DEFAULT_COLOR);
        this.setStroke(DEFAULT_STROKE);
        this.updateDataSet();
    }

    public void setPeriod(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("period must be >= 0 : " + d);
        }
        if (d != this._period) {
            this._period = d;
            this.updateDataSet();
        }
    }

    public void setAmplitude(double d) {
        if (d != this._amplitude) {
            this._amplitude = d;
            this.updateDataSet();
        }
    }

    public void setStartX(double d) {
        if (d != this._startX) {
            this._startX = d;
            this.updateDataSet();
        }
    }

    public void setCosineEnabled(boolean bl) {
        if (bl != this._cosineEnabled) {
            this._cosineEnabled = bl;
            this.updateDataSet();
        }
    }

    public void setShowZeroAmplitudeEnabled(boolean bl) {
        if (bl != this._showZeroAmplitude) {
            this._showZeroAmplitude = bl;
            this.updateDataSet();
        }
    }

    public void setPixelsPerPoint(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("pixelsPerPoint must be > 0 : " + d);
        }
        if (d != this._pixelsPerPoint) {
            this._pixelsPerPoint = d;
            this.updateDataSet();
        }
    }

    public void transformChanged() {
        this.updateDataSet();
        super.transformChanged();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateDataSet();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateDataSet() {
        if (!this.isVisible()) return;
        Chart chart = this.getChart();
        Range2D range2D = chart.getRange();
        DataSet dataSet = this.getDataSet();
        dataSet.clear();
        if (this._amplitude == 0.0) {
            if (!this._showZeroAmplitude) return;
            Point2D[] point2DArray = new Point2D[]{new Point2D.Double(range2D.getMinX(), 0.0), new Point2D.Double(range2D.getMaxX(), 0.0)};
            dataSet.addAllPoints(point2DArray);
            return;
        } else {
            double d = this.modelToViewX(range2D.getMinX());
            double d2 = this.modelToViewX(range2D.getMaxX());
            double d3 = d2 - d + 1.0;
            int n = (int)(d3 / this._pixelsPerPoint);
            double d4 = Math.abs(range2D.getMaxX() - range2D.getMinX());
            double d5 = d4 / (double)n;
            double d6 = d4 / this._period;
            double d7 = d6 * (Math.PI * 2) / (double)n;
            double d8 = this.modelToViewX(this._startX);
            double d9 = Math.abs((d8 - d) / this._pixelsPerPoint) * d7;
            if (d8 > d) {
                d9 = -d9;
            }
            if (this._points == null || n + 1 != this._points.length) {
                this._points = new Point2D.Double[n + 1];
            }
            for (int i = 0; i < this._points.length; ++i) {
                double d10 = range2D.getMinX() + (double)i * d5;
                double d11 = d9 + (double)i * d7;
                double d12 = 0.0;
                d12 = this._cosineEnabled ? this._amplitude * Math.cos(d11) : this._amplitude * Math.sin(d11);
                if (this._points[i] == null) {
                    this._points[i] = new Point2D.Double(d10, d12);
                    continue;
                }
                this._points[i].setLocation(d10, d12);
            }
            dataSet.addAllPoints(this._points);
        }
    }

    private double modelToViewX(double d) {
        return this.getChart().transformXDouble(d);
    }
}

