/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class LinePlot
extends DataSetGraphic {
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private boolean generalPathIsEmpty = true;
    private GeneralPath generalPath = new GeneralPath();
    private PhetShapeGraphic phetShapeGraphic;

    public LinePlot(Component component, Chart chart) {
        this(component, chart, null);
    }

    public LinePlot(Component component, Chart chart, DataSet dataSet) {
        this(component, chart, dataSet, DEFAULT_STROKE, DEFAULT_COLOR);
    }

    public LinePlot(Component component, Chart chart, DataSet dataSet, Stroke stroke, Paint paint) {
        super(component, chart, dataSet);
        this.phetShapeGraphic = new PhetShapeGraphic(this.getComponent(), this.generalPath, stroke, paint);
        this.addGraphic(this.phetShapeGraphic);
        this.addAllPoints();
    }

    public void setStroke(Stroke stroke) {
        this.phetShapeGraphic.setStroke(stroke);
    }

    public void setBorderColor(Color color) {
        this.phetShapeGraphic.setBorderColor(color);
    }

    public void setStrokeColor(Color color) {
        this.phetShapeGraphic.setBorderColor(color);
    }

    public void transformChanged() {
        this.generalPath.reset();
        this.generalPathIsEmpty = true;
        this.addAllPoints();
    }

    public void cleared() {
        this.generalPath.reset();
        this.generalPathIsEmpty = true;
        this.repaintAll();
    }

    public void pointAdded(Point2D point2D) {
        this.pointAddedNoRepaint(point2D);
        this.repaintAll();
    }

    public void pointsAdded(Point2D[] point2DArray) {
        for (int i = 0; i < point2DArray.length; ++i) {
            this.pointAddedNoRepaint(point2DArray[i]);
        }
        this.repaintAll();
    }

    protected void pointAddedNoRepaint(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        Point2D point2D2 = this.getChart().transformDouble(point2D);
        if (this.generalPathIsEmpty) {
            this.generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
            this.generalPathIsEmpty = false;
        } else {
            this.generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        }
    }

    private void repaintAll() {
        this.phetShapeGraphic.setShapeDirty();
    }
}

