/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.AbstractTicks;
import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.GridStrategy;
import edu.colorado.phet.common.charts.Orientation;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Axis
extends GraphicLayerSet {
    private Chart chart;
    private AxisTicks minorTicks;
    private AxisTicks majorTicks;
    private Orientation orientation;
    private double crossesOtherAxisAt = 0.0;
    private GraphicLayerSet lineGraphic;
    private Stroke stroke;
    private Color color;
    private boolean inBounds = true;

    public Axis(Chart chart, Orientation orientation, Stroke stroke, Color color, double d, double d2) {
        this.minorTicks = new AxisTicks(chart, orientation.opposite(), stroke, color, d);
        this.minorTicks.setShowLabels(false);
        this.majorTicks = new AxisTicks(chart, orientation.opposite(), stroke, color, d2);
        this.majorTicks.setShowLabels(true);
        this.stroke = stroke;
        this.orientation = orientation;
        this.chart = chart;
        this.color = color;
        this.minorTicks.setVisible(false);
        this.lineGraphic = new GraphicLayerSet();
        this.addGraphic(this.lineGraphic);
        this.addGraphic(this.minorTicks);
        this.addGraphic(this.majorTicks);
        chart.addListener(new Chart.Listener(){

            public void transformChanged(Chart chart) {
                Axis.this.update();
            }
        });
        this.update();
    }

    public void update() {
        this.lineGraphic.clear();
        if (this.orientation.isHorizontal()) {
            Point2D.Double double_ = new Point2D.Double(this.chart.getRange().getMinX(), this.crossesOtherAxisAt);
            Point point = this.chart.transform(double_);
            Point2D.Double double_2 = new Point2D.Double(this.chart.getRange().getMaxX(), this.crossesOtherAxisAt);
            Point point2 = this.chart.transform(double_2);
            Line2D.Double double_3 = new Line2D.Double(point.x, point.y, point2.x, point2.y);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.chart.getComponent(), double_3, this.stroke, this.color);
            this.lineGraphic.addGraphic(phetShapeGraphic);
        } else if (this.orientation.isVertical()) {
            Point2D.Double double_ = new Point2D.Double(this.crossesOtherAxisAt, this.chart.getRange().getMinY());
            Point point = this.chart.transform(double_);
            Point2D.Double double_4 = new Point2D.Double(this.crossesOtherAxisAt, this.chart.getRange().getMaxY());
            Point point3 = this.chart.transform(double_4);
            Line2D.Double double_5 = new Line2D.Double(point.x, point.y, point3.x, point3.y);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.chart.getComponent(), double_5, this.stroke, this.color);
            this.lineGraphic.addGraphic(phetShapeGraphic);
        }
        this.majorTicks.update();
        this.minorTicks.update();
        this.inBounds = this.isInBounds();
        this.setBoundsDirty();
    }

    protected Rectangle determineBounds() {
        if (!this.inBounds) {
            return null;
        }
        return super.determineBounds();
    }

    private boolean isInBounds() {
        if (this.orientation.isHorizontal()) {
            return this.chart.getRange().containsY(this.crossesOtherAxisAt);
        }
        if (this.orientation.isVertical()) {
            return this.chart.getRange().containsX(this.crossesOtherAxisAt);
        }
        throw new RuntimeException("Illegal orientation");
    }

    public void paint(Graphics2D graphics2D) {
        if (this.inBounds) {
            super.paint(graphics2D);
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.update();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.update();
    }

    public void setMajorTicksVisible(boolean bl) {
        this.majorTicks.setVisible(bl);
    }

    public void setMajorTickLabelsVisible(boolean bl) {
        this.majorTicks.setLabelsVisible(bl);
    }

    public void setMinorTicksVisible(boolean bl) {
        this.minorTicks.setVisible(bl);
    }

    public void setMinorTickLabelsVisible(boolean bl) {
        this.minorTicks.setLabelsVisible(bl);
    }

    public static class AxisTicks
    extends AbstractTicks {
        public AxisTicks(Chart chart, Orientation orientation, Stroke stroke, Color color, double d) {
            super(chart, orientation, stroke, color, d, 0.0);
        }

        public int getVerticalTickX() {
            Point2D.Double double_ = new Point2D.Double(this.getCrossesOtherAxisAt(), this.getChart().getRange().getMinY());
            Point point = this.getChart().transform(double_);
            return point.x;
        }

        private double getCrossesOtherAxisAt() {
            if (this.getGridStrategy() instanceof GridStrategy.Relative) {
                return ((GridStrategy.Relative)this.getGridStrategy()).getCrossesOtherAxisAt();
            }
            throw new RuntimeException("Axes must use Relative grid strategy.");
        }

        public int getHorizontalTickY() {
            Point2D.Double double_ = new Point2D.Double(this.getChart().getRange().getMinX(), this.getCrossesOtherAxisAt());
            Point point = this.getChart().transform(double_);
            return point.y;
        }
    }
}

