/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class ThresholdedDragAdapter
implements MouseInputListener {
    private Point lastPressLocation;
    private long lastDragTime;
    private MouseInputListener target;
    private int thresholdX = 0;
    private int thresholdY = 0;
    private long thresholdMillis = 0L;
    private boolean isDragging = false;

    public ThresholdedDragAdapter(MouseInputListener mouseInputListener, int n, int n2, long l) {
        this.target = mouseInputListener;
        this.thresholdX = n;
        this.thresholdY = n2;
        this.thresholdMillis = l;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.target.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.target.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.target.mouseExited(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastPressLocation = mouseEvent.getPoint();
        this.target.mousePressed(mouseEvent);
        this.lastDragTime = System.currentTimeMillis();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastPressLocation = null;
        this.isDragging = false;
        this.target.mouseReleased(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (System.currentTimeMillis() - this.lastDragTime >= this.thresholdMillis) {
            this.resetDragging();
        }
        if (this.lastPressLocation == null) {
            this.lastPressLocation = mouseEvent.getPoint();
        }
        int n = Math.abs(this.lastPressLocation.x - mouseEvent.getX());
        int n2 = Math.abs(this.lastPressLocation.y - mouseEvent.getY());
        if (n >= this.thresholdX && n2 >= this.thresholdY) {
            this.isDragging = true;
        }
        if (this.isDragging) {
            this.target.mouseDragged(mouseEvent);
        }
        this.lastDragTime = System.currentTimeMillis();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.target.mouseMoved(mouseEvent);
    }

    public void resetDragging() {
        this.isDragging = false;
        this.lastPressLocation = null;
    }
}

