/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.model.Block;
import edu.colorado.phet.forces1d.view.BlockGraphic;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import edu.colorado.phet.forces1d.view.WalkwayGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class OffscreenPointerGraphic
extends GraphicLayerSet {
    private static final Font font = new Font(PhetFont.getDefaultFontName(), 1, 28);
    private DecimalFormat decimalFormat = new DecimalFormat("#0.0");
    private PhetTextGraphic textGraphic;
    private BlockGraphic blockGraphic;
    private WalkwayGraphic container;
    private int y = 50;

    public OffscreenPointerGraphic(Force1DPanel force1DPanel, final BlockGraphic blockGraphic, final WalkwayGraphic walkwayGraphic) {
        super(force1DPanel);
        this.blockGraphic = blockGraphic;
        this.container = walkwayGraphic;
        this.textGraphic = new PhetTextGraphic(force1DPanel, font, "", Color.blue, 0, 0);
        this.addGraphic(this.textGraphic);
        blockGraphic.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
                boolean bl = blockGraphic.getBounds().getX() <= walkwayGraphic.getBounds().getX();
                boolean bl2 = blockGraphic.getBounds().getX() >= walkwayGraphic.getBounds().getX() + (double)walkwayGraphic.getWidth();
                int n = 30;
                if (bl || bl2) {
                    Block block = blockGraphic.getBlock();
                    double d = block.getPosition();
                    String string = OffscreenPointerGraphic.this.decimalFormat.format(d);
                    OffscreenPointerGraphic.this.textGraphic.setText(string + " " + Force1DResources.get("OffscreenPointerGraphic.meters"));
                    int n2 = OffscreenPointerGraphic.this.textGraphic.getHeight() + 10;
                    Point2D.Double double_ = new Point2D.Double(OffscreenPointerGraphic.this.textGraphic.getWidth() / 2, n2);
                    Point2D.Double double_2 = new Point2D.Double(double_.getX() + d, n2);
                    Vector2D vector2D = new Vector2D(double_, double_2);
                    int n3 = OffscreenPointerGraphic.this.textGraphic.getWidth() / 2;
                    if (vector2D.magnitude() > (double)n3) {
                        vector2D = vector2D.getInstanceOfMagnitude(n3);
                    }
                    OffscreenPointerGraphic.this.setBoundsDirty();
                    Rectangle rectangle = OffscreenPointerGraphic.this.getBounds();
                    if (bl2) {
                        OffscreenPointerGraphic.this.setLocation((int)(walkwayGraphic.getBounds().getX() + (double)walkwayGraphic.getWidth() - (double)rectangle.width - (double)n), OffscreenPointerGraphic.this.y);
                    } else {
                        OffscreenPointerGraphic.this.setLocation((int)(walkwayGraphic.getBounds().getX() + (double)n), OffscreenPointerGraphic.this.y);
                    }
                    OffscreenPointerGraphic.this.setVisible(true);
                } else {
                    OffscreenPointerGraphic.this.setVisible(false);
                }
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
            }
        });
    }
}

