/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.FrameSequence;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.forces1d.Forces1DModule;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import edu.colorado.phet.forces1d.view.OffsetManager;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class LeanerGraphic
extends PhetImageGraphic {
    private FrameSequence animation;
    private PhetGraphic target;
    private OffsetManager offsetManager;
    private Force1DPanel forcePanel;
    private Forces1DModule module;
    private double max = 500.0;
    private FrameSequence flippedAnimation;
    private BufferedImage standingStill;

    public LeanerGraphic(Force1DPanel force1DPanel, PhetGraphic phetGraphic, OffsetManager offsetManager) throws IOException {
        super((Component)force1DPanel, (BufferedImage)null);
        offsetManager.addListener(new OffsetManager.Listener(){

            public void offsetChanged() {
                LeanerGraphic.this.update(true);
            }
        });
        this.forcePanel = force1DPanel;
        this.target = phetGraphic;
        this.offsetManager = offsetManager;
        this.module = force1DPanel.getModule();
        this.standingStill = ImageLoader.loadBufferedImage("forces-1d/images/standing-man.png");
        this.animation = new FrameSequence("forces-1d/images/pusher-leaning/pusher-leaning", 15);
        BufferedImage[] bufferedImageArray = new BufferedImage[this.animation.getNumFrames()];
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            bufferedImageArray[i] = BufferedImageUtils.flipX(this.animation.getFrame(i));
        }
        this.flippedAnimation = new FrameSequence(bufferedImageArray);
        super.setImage(this.animation.getFrame(0));
        final long l = System.currentTimeMillis();
        phetGraphic.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
                long l2 = System.currentTimeMillis() - l;
                if (LeanerGraphic.this.module.getForceModel().getAppliedForce() != 0.0) {
                    LeanerGraphic.this.update(false);
                }
                if (l2 < 5000L) {
                    LeanerGraphic.this.update(true);
                }
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                LeanerGraphic.this.setVisible(phetGraphic.isVisible());
            }
        });
        this.module.getForceModel().addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                LeanerGraphic.this.update(false);
            }

            public void gravityChanged() {
            }
        });
        this.setIgnoreMouse(true);
        this.update(true);
    }

    private BufferedImage getFrame(boolean bl) {
        double d = Math.abs(this.module.getForceModel().getAppliedForce());
        int n = (int)((double)this.animation.getNumFrames() * d / this.max);
        if (n >= this.animation.getNumFrames()) {
            n = this.animation.getNumFrames() - 1;
        }
        if (this.module.getForceModel().getAppliedForce() == 0.0) {
            return this.standingStill;
        }
        if (bl) {
            return this.animation.getFrame(n);
        }
        return this.flippedAnimation.getFrame(n);
    }

    public void screenSizeChanged() {
        this.update(true);
    }

    private void update(boolean bl) {
        double d;
        int n;
        boolean bl2 = true;
        double d2 = this.module.getForceModel().getAppliedForce();
        if (d2 < 0.0) {
            bl2 = false;
        }
        BufferedImage bufferedImage = this.getFrame(bl2);
        int n2 = 5;
        if (bl2) {
            n = (int)(this.target.getBounds().getX() - (double)bufferedImage.getWidth()) + n2;
            d = this.forcePanel.getWalkwayGraphic().getFloorY() - this.getHeight();
        } else {
            n = (int)(this.target.getBounds().getX() + (double)this.target.getWidth()) - n2;
            d = this.forcePanel.getWalkwayGraphic().getFloorY() - this.getHeight();
        }
        if (d2 != 0.0 || bl) {
            this.setLocation(n, (int)(d + this.offsetManager.getOffset()));
        }
        this.setImage(bufferedImage);
    }
}

