/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Forces1DModule;
import edu.colorado.phet.forces1d.common.ControlPanel;
import edu.colorado.phet.forces1d.view.FreeBodyDiagramPanel;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FreeBodyDiagramSuite {
    private FreeBodyDiagramPanel freeBodyDiagramPanel;
    private Forces1DModule module;
    private JDialog dialog;
    private JPanel dialogContentPane;
    private ControlPanel controlPanel;
    private int dialogInsetX;
    private int dialogInsetY;
    private PSwing buttonPanelPSwing;
    private boolean panelVisible;
    private ArrayList listeners = new ArrayList();

    public FreeBodyDiagramSuite(Forces1DModule forces1DModule) {
        this.module = forces1DModule;
        this.freeBodyDiagramPanel = new FreeBodyDiagramPanel(forces1DModule);
        JPanel jPanel = new JPanel(new FlowLayout(1, 1, 1));
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageLoader.loadBufferedImage("forces-1d/images/tear-20.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BufferedImage bufferedImage2 = null;
        try {
            bufferedImage2 = ImageLoader.loadBufferedImage("forces-1d/images/x-20.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JButton jButton = new JButton(new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, 14)));
        JButton jButton2 = new JButton(new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage2, 14)));
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton2.setMargin(new Insets(2, 2, 2, 2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FreeBodyDiagramSuite.this.dialog == null || !FreeBodyDiagramSuite.this.dialog.isVisible()) {
                    FreeBodyDiagramSuite.this.setWindowed();
                } else {
                    FreeBodyDiagramSuite.this.closeDialog();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FreeBodyDiagramSuite.this.setPanelVisible(false);
            }
        });
        this.buttonPanelPSwing = new PSwing(jPanel);
        this.getFreeBodyDiagramPanel().addScreenChild(this.buttonPanelPSwing);
        this.updateButtonLocations();
        this.setPanelVisible(false);
        this.freeBodyDiagramPanel.addIgnoreArea(this.buttonPanelPSwing);
    }

    public FreeBodyDiagramPanel getFreeBodyDiagramPanel() {
        return this.freeBodyDiagramPanel;
    }

    public boolean isFBDVisible() {
        return this.panelVisible;
    }

    public void setPanelVisible(boolean bl) {
        this.getFreeBodyDiagramPanel().setVisible(bl);
        this.updateButtonLocations();
        this.panelVisible = bl;
        this.notifyListener();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListener() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).visibilityChanged();
        }
    }

    private void updateButtonLocations() {
        int n = (int)this.getFreeBodyDiagramPanel().getPreferredSize().getWidth();
        this.buttonPanelPSwing.setOffset((double)(n - 3) - this.buttonPanelPSwing.getFullBounds().getWidth(), 3.0);
    }

    private void setWindowed() {
        if (this.dialog == null) {
            this.createDialog();
        }
        this.dialog.pack();
        int n = this.dialog.getWidth();
        Point point = this.controlPanel.getLocationOnScreen();
        point.x -= n;
        this.dialog.setLocation(point);
        this.dialogContentPane.add(this.getFreeBodyDiagramPanel());
        this.getFreeBodyDiagramPanel().setLocation(this.dialogInsetX, this.dialogInsetY);
        this.dialog.setVisible(true);
        this.controlPanel.invalidate();
        this.controlPanel.doLayout();
        this.controlPanel.validate();
        this.updateButtonLocations();
    }

    private void createDialog() {
        this.dialog = new JDialog((Frame)this.module.getPhetFrame(), Force1DResources.get("FreeBodyDiagramSuite.freeBodyDiagram"));
        this.dialog.setResizable(false);
        this.dialogContentPane = new JPanel(null);
        this.dialogInsetX = 15;
        this.dialogInsetY = 15;
        FreeBodyDiagramPanel freeBodyDiagramPanel = this.getFreeBodyDiagramPanel();
        Dimension dimension = new Dimension(freeBodyDiagramPanel.getWidth() + this.dialogInsetX * 2, freeBodyDiagramPanel.getHeight() + this.dialogInsetY * 2);
        this.dialogContentPane.setSize(dimension);
        this.dialogContentPane.setPreferredSize(dimension);
        this.dialogContentPane.add(freeBodyDiagramPanel);
        freeBodyDiagramPanel.setLocation(this.dialogInsetX, this.dialogInsetY);
        this.dialog.setContentPane(this.dialogContentPane);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FreeBodyDiagramSuite.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        this.controlPanel.getControlPane().setGridY(1);
        this.controlPanel.addControl(this.getFreeBodyDiagramPanel());
        this.dialog.setVisible(false);
        this.updateButtonLocations();
        Window window = SwingUtilities.getWindowAncestor(this.controlPanel);
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.invalidate();
            jFrame.validate();
            jFrame.repaint();
        }
    }

    public void setControlPanel(ControlPanel controlPanel) {
        this.controlPanel = controlPanel;
    }

    public void reset() {
        this.freeBodyDiagramPanel.reset();
    }

    public void updateGraphics() {
        this.freeBodyDiagramPanel.updateGraphics();
    }

    public void controlsChanged() {
        this.updateButtonLocations();
    }

    public static interface Listener {
        public void visibilityChanged();
    }
}

