/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Forces1DModule;
import edu.colorado.phet.forces1d.common.WiggleMe;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDevice;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.FreeBodyDiagramNode;
import edu.colorado.phet.forces1d.view.ThresholdedDragAdapter;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.MouseInputAdapter;

public class FreeBodyDiagramPanel
extends PhetPCanvas {
    private FreeBodyDiagramNode freeBodyDiagram;
    private WiggleMe fbdWiggleMe;
    private PlotDevice forcePlotDevice;
    private ArrayList ignoreAreas = new ArrayList();

    public FreeBodyDiagramPanel(Forces1DModule forces1DModule) {
        this.setLayout(null);
        int n = 180;
        if (Toolkit.getDefaultToolkit().getScreenSize().width < 1280) {
            n = 157;
        }
        this.setPreferredSize(new Dimension(n, n));
        this.freeBodyDiagram = new FreeBodyDiagramNode(forces1DModule);
        this.addScreenChild(this.freeBodyDiagram);
        this.freeBodyDiagram.setSize(n, n);
        WiggleMe.Target target = new WiggleMe.Target(){

            public Point getLocation() {
                return new Point(FreeBodyDiagramPanel.this.getWidth() - 10, this.getHeight() / 2 - FreeBodyDiagramPanel.this.fbdWiggleMe.getHeight());
            }

            public int getHeight() {
                return 0;
            }
        };
        this.fbdWiggleMe = new WiggleMe((Component)this, forces1DModule.getClock(), Force1DResources.get("FreeBodyDiagramPanel.clickHelp"), target);
        this.fbdWiggleMe.setArrowColor(new Color(0, 30, 240, 128));
        this.fbdWiggleMe.setFont(new Font(PhetFont.getDefaultFontName(), 1, 14));
        this.fbdWiggleMe.setArrow(0.0, 40.0);
        this.fbdWiggleMe.setAmplitude(10.0);
        this.fbdWiggleMe.setFrequency(5.0);
        this.fbdWiggleMe.setOscillationAxis(new MutableVector2D(1.0, 0.0));
        this.fbdWiggleMe.setVisible(false);
        forces1DModule.getForceModel().addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                FreeBodyDiagramPanel.this.fbdWiggleMe.setVisible(false);
            }

            public void gravityChanged() {
            }
        });
        this.forcePlotDevice = forces1DModule.getForcePanel().getPlotDevice();
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!FreeBodyDiagramPanel.this.ignore(mouseEvent)) {
                    FreeBodyDiagramPanel.this.forcePlotDevice.getPlotDeviceModel().setRecordMode();
                    FreeBodyDiagramPanel.this.forcePlotDevice.getPlotDeviceModel().setPaused(false);
                }
            }
        };
        this.addMouseListener(mouseInputAdapter);
        MouseInputAdapter mouseInputAdapter2 = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!FreeBodyDiagramPanel.this.ignore(mouseEvent)) {
                    FreeBodyDiagramPanel.this.freeBodyDiagram.setForce(mouseEvent.getPoint());
                    FreeBodyDiagramPanel.this.freeBodyDiagram.setUserClicked(true);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                FreeBodyDiagramPanel.this.freeBodyDiagram.setForce(mouseEvent.getPoint());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                FreeBodyDiagramPanel.this.freeBodyDiagram.setAppliedForce(0.0);
            }
        };
        ThresholdedDragAdapter thresholdedDragAdapter = new ThresholdedDragAdapter(mouseInputAdapter2, 10, 0, 1000L);
        this.addMouseListener(thresholdedDragAdapter);
        this.addMouseMotionListener(thresholdedDragAdapter);
    }

    private boolean ignore(MouseEvent mouseEvent) {
        for (int i = 0; i < this.ignoreAreas.size(); ++i) {
            PNode pNode = (PNode)this.ignoreAreas.get(i);
            if (!pNode.getGlobalFullBounds().contains(mouseEvent.getPoint())) continue;
            return true;
        }
        return false;
    }

    public void updateGraphics() {
        this.freeBodyDiagram.updateAll();
    }

    public void reset() {
        if (!this.freeBodyDiagram.isUserClicked()) {
            this.fbdWiggleMe.setVisible(true);
            if (!this.containsGraphic(this.fbdWiggleMe)) {
                // empty if block
            }
        }
    }

    private boolean containsGraphic(PhetGraphic phetGraphic) {
        return false;
    }

    public void addIgnoreArea(PNode pNode) {
        this.ignoreAreas.add(pNode);
    }
}

