/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.Forces1DModule;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.Arrow;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FreeBodyDiagramNode
extends PNode {
    private AxesGraphic axes;
    private Force1DModel model;
    private ForceArrow mg;
    private ForceArrow normal;
    private ForceArrow appliedForce;
    private ForceArrow wallForce;
    private ForceArrow frictionForce;
    private ForceArrow netForce;
    private double yScale = 0.025;
    private double xScale = 0.1;
    private boolean userClicked = false;
    private double width = 400.0;
    private double height = 400.0;
    private PhetPPath background;

    public FreeBodyDiagramNode(Forces1DModule forces1DModule) {
        this.model = forces1DModule.getForceModel();
        Force1DLookAndFeel force1DLookAndFeel = forces1DModule.getForce1DLookAndFeel();
        this.background = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, this.width, this.height), Color.white, new BasicStroke(1.0f), Color.black);
        this.background.addInputEventListener(new CursorHandler());
        this.addChild(this.background);
        this.axes = new AxesGraphic();
        this.addChild(this.axes);
        this.axes.setVisible(false);
        this.mg = new ForceArrow(this, force1DLookAndFeel.getWeightColor(), Force1DResources.get("FreeBodyDiagram.gravity"), new MutableVector2D(0.0, 80.0));
        this.addForceArrow(this.mg);
        this.normal = new ForceArrow(this, force1DLookAndFeel.getNormalColor(), Force1DResources.get("FreeBodyDiagram.normal"), new MutableVector2D(0.0, 80.0));
        this.addForceArrow(this.normal);
        this.appliedForce = new ForceArrow(this, force1DLookAndFeel.getAppliedForceColor(), Force1DResources.get("FreeBodyDiagram.applied"), new MutableVector2D());
        this.addForceArrow(this.appliedForce);
        this.frictionForce = new ForceArrow(this, force1DLookAndFeel.getFrictionForceColor(), Force1DResources.get("FreeBodyDiagram.friction"), new MutableVector2D());
        this.addForceArrow(this.frictionForce);
        this.netForce = new ForceArrow(this, force1DLookAndFeel.getNetForceColor(), Force1DResources.get("FreeBodyDiagram.total"), new MutableVector2D());
        this.netForce.setOrigin(0.0, -30.0);
        this.wallForce = new ForceArrow(this, force1DLookAndFeel.getWallForceColor(), Force1DResources.get("FreeBodyDiagram.wall"), new MutableVector2D());
        this.addForceArrow(this.wallForce);
        this.wallForce.setOrigin(0.0, -30.0);
        this.addInputEventListener(new CursorHandler());
    }

    public void setForce(Point point) {
        double d = point.getX();
        double d2 = d - this.getCenter().getX();
        double d3 = d2 / this.xScale;
        this.model.setAppliedForce(d3);
    }

    private void updateXForces() {
        MutableVector2D mutableVector2D = new MutableVector2D(this.model.getAppliedForce() * this.xScale, 0.0);
        this.appliedForce.setVector(mutableVector2D);
        MutableVector2D mutableVector2D2 = new MutableVector2D(this.model.getFrictionForce() * this.xScale, 0.0);
        this.frictionForce.setVector(mutableVector2D2);
        MutableVector2D mutableVector2D3 = new MutableVector2D(this.model.getNetForce() * this.xScale, 0.0);
        this.netForce.setVector(mutableVector2D3);
        MutableVector2D mutableVector2D4 = new MutableVector2D(this.model.getWallForce() * this.xScale, 0.0);
        this.wallForce.setVector(mutableVector2D4);
    }

    private void updateMG() {
        double d = this.model.getGravity();
        double d2 = this.model.getBlock().getMass();
        MutableVector2D mutableVector2D = new MutableVector2D(0.0, d * d2 * this.yScale);
        Vector2D vector2D = mutableVector2D.times(-1.0);
        this.mg.setVector(mutableVector2D);
        this.normal.setVector(vector2D);
    }

    public void addForceArrow(ForceArrow forceArrow) {
        this.addChild(forceArrow);
    }

    private Point2D getCenter() {
        return new Point2D.Double(this.width / 2.0, this.height / 2.0);
    }

    public void updateAll() {
        this.updateXForces();
        this.updateMG();
        this.axes.update();
        this.background.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.updateAll();
    }

    public void setUserClicked(boolean bl) {
        this.userClicked = bl;
    }

    public void setAppliedForce(double d) {
        this.model.setAppliedForce(d);
    }

    public boolean isUserClicked() {
        return this.userClicked;
    }

    public class AxesGraphic
    extends PNode {
        private PPath xAxis;
        private PPath yAxis;
        private PNode xLabel;
        private PNode yLabel;

        public AxesGraphic() {
            BasicStroke basicStroke = new BasicStroke(1.0f);
            Color color = Color.black;
            this.xAxis = new PhetPPath(basicStroke, color);
            this.yAxis = new PhetPPath(basicStroke, color);
            this.addChild(this.xAxis);
            this.addChild(this.yAxis);
            Font font = new Font(PhetFont.getDefaultFontName(), 0, 16);
            this.xLabel = new HTMLNode(Force1DResources.get("FreeBodyDiagram.fx"), Color.black, font);
            this.yLabel = new HTMLNode(Force1DResources.get("FreeBodyDiagram.fy"), Color.black, font);
            this.addChild(this.xLabel);
            this.addChild(this.yLabel);
            this.update();
        }

        public void update() {
            Line2D.Double double_ = new Line2D.Double(0.0, FreeBodyDiagramNode.this.height / 2.0, FreeBodyDiagramNode.this.width, FreeBodyDiagramNode.this.height / 2.0);
            Line2D.Double double_2 = new Line2D.Double(FreeBodyDiagramNode.this.width / 2.0, 0.0, FreeBodyDiagramNode.this.width / 2.0, FreeBodyDiagramNode.this.height);
            this.xAxis.setPathTo(double_);
            this.yAxis.setPathTo(double_2);
            this.xLabel.setOffset((double)((int)double_.getX2()) - this.xLabel.getWidth(), (int)double_.getY2());
            this.yLabel.setOffset((int)double_2.getX1() + 3, (int)double_2.getY1());
        }
    }

    public static class ForceArrow
    extends PNode {
        private PhetPPath shapeGraphic;
        private HTMLNode textGraphic;
        private FreeBodyDiagramNode fbd;
        private double dx;
        private double dy;
        private Arrow lastArrow;

        public ForceArrow(FreeBodyDiagramNode freeBodyDiagramNode, Color color, String string, MutableVector2D mutableVector2D) {
            this.fbd = freeBodyDiagramNode;
            this.shapeGraphic = new PhetPPath(Force1DUtil.transparify(color, 150), new BasicStroke(2.0f, 1, 1), Force1DUtil.transparify(Color.black, 128));
            this.addChild(this.shapeGraphic);
            Font font = new Font(PhetFont.getDefaultFontName(), 1, 18);
            this.textGraphic = new HTMLNode(string, color, font);
            this.addChild(this.textGraphic);
            this.setVector(mutableVector2D);
            this.setPickable(false);
            this.setChildrenPickable(false);
        }

        public void setOrigin(double d, double d2) {
            this.dx = d;
            this.dy = d2;
        }

        public void setVector(AbstractVector2D abstractVector2D) {
            Point2D point2D = this.fbd.getCenter();
            point2D = new Point2D.Double(point2D.getX() + this.dx, point2D.getY() + this.dy);
            Arrow arrow = new Arrow(point2D, abstractVector2D.getDestination(point2D), 30.0, 30.0, 10.0, 0.5, true);
            GeneralPath generalPath = arrow.getShape();
            if (this.lastArrow == null || !this.lastArrow.equals(arrow)) {
                this.shapeGraphic.setPathTo(generalPath);
            }
            this.lastArrow = arrow;
            Rectangle rectangle = generalPath.getBounds();
            Point point = RectangleUtils.getCenter(rectangle);
            if (abstractVector2D.getX() > 0.0) {
                this.textGraphic.setOffset(rectangle.x + rectangle.width + 5, (double)point.y - this.textGraphic.getHeight() / 2.0);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getX() < 0.0) {
                this.textGraphic.setOffset((double)rectangle.x - this.textGraphic.getWidth() - 5.0, (double)point.y - this.textGraphic.getHeight() / 2.0);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getY() > 0.0) {
                this.textGraphic.setOffset((double)point.x - this.textGraphic.getWidth() / 2.0, rectangle.y + rectangle.height);
                this.textGraphic.setVisible(true);
            } else if (abstractVector2D.getY() < 0.0) {
                this.textGraphic.setOffset((double)point.x - this.textGraphic.getWidth() / 2.0, (double)rectangle.y - this.textGraphic.getHeight());
                this.textGraphic.setVisible(true);
            } else {
                this.textGraphic.setVisible(false);
            }
            if (abstractVector2D.magnitude() <= 0.05) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
        }
    }
}

