/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common.phetgraphics.view.util.BasicGraphicsSetup;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.Forces1DModule;
import edu.colorado.phet.forces1d.common.HelpItem2;
import edu.colorado.phet.forces1d.common.LayoutUtil;
import edu.colorado.phet.forces1d.common.RelativeLocationSetter;
import edu.colorado.phet.forces1d.common.TitleLayout;
import edu.colorado.phet.forces1d.common.WiggleMe;
import edu.colorado.phet.forces1d.common.phetcomponents.PhetButton;
import edu.colorado.phet.forces1d.common.plotdevice.FloatingControl;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDevice;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.ArrowSetGraphic;
import edu.colorado.phet.forces1d.view.BlockGraphic;
import edu.colorado.phet.forces1d.view.BufferedPhetGraphic;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.colorado.phet.forces1d.view.Force1DPlotDeviceView;
import edu.colorado.phet.forces1d.view.LeanerGraphic;
import edu.colorado.phet.forces1d.view.OffscreenPointerGraphic;
import edu.colorado.phet.forces1d.view.OffsetManager;
import edu.colorado.phet.forces1d.view.WalkwayGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class Force1DPanel
extends ApparatusPanel2
implements OffsetManager {
    private ArrayList offsetListeners = new ArrayList();
    private Forces1DModule module;
    private BlockGraphic blockGraphic;
    private ArrowSetGraphic arrowSetGraphic;
    private ModelViewTransform2D transform2D;
    private Function.LinearFunction walkwayTransform;
    private PlotDevice forcePlotDevice;
    private WalkwayGraphic walkwayGraphic;
    private LeanerGraphic leanerGraphic;
    private Force1DModel model;
    private Force1DLookAndFeel lookAndFeel = new Force1DLookAndFeel();
    private BufferedPhetGraphic backgroundGraphic = new BufferedPhetGraphic(this, 800, 800, Color.white);
    private PlotDevice accelPlotDevice;
    private PlotDevice velPlotDevice;
    private PlotDevice posPlotDevice;
    private WiggleMe wiggleMe;
    private WiggleMe sliderWiggleMe;
    private HelpItem2 soloGoButtonHelp;
    private boolean goButtonPressed;
    private PhetGraphic goPauseClearGraphic;
    private PhetGraphic checkBoxPanelGraphic;
    public static int Y_OFFSET = 400;
    private boolean didLayout = false;

    public Force1DPanel(final Forces1DModule forces1DModule) throws IOException {
        super(forces1DModule.getClock());
        this.backgroundGraphic.setGraphicsSetup(new BasicGraphicsSetup());
        this.module = forces1DModule;
        this.model = forces1DModule.getForceModel();
        this.addGraphicsSetup(new BasicGraphicsSetup());
        this.walkwayTransform = new Function.LinearFunction(-12.0, 12.0, 0.0, 400.0);
        this.walkwayGraphic = new WalkwayGraphic(this, forces1DModule, 21, this.walkwayTransform, this);
        this.blockGraphic = new BlockGraphic(this, forces1DModule.getForceModel().getBlock(), this.model, this.walkwayTransform, forces1DModule.getObject(0), this);
        this.arrowSetGraphic = new ArrowSetGraphic(this, this.blockGraphic, this.model, this.transform2D, this);
        this.leanerGraphic = new LeanerGraphic(this, this.blockGraphic, this);
        this.backgroundGraphic.addGraphic(this.walkwayGraphic);
        this.backgroundGraphic.repaintBuffer();
        this.addGraphic(this.backgroundGraphic);
        this.addGraphic(this.blockGraphic);
        this.addGraphic(this.leanerGraphic, 1000.0);
        this.leanerGraphic.setLocation(400, 100);
        this.addGraphic(this.arrowSetGraphic);
        int n = 3;
        Force1DPlotDeviceView force1DPlotDeviceView = new Force1DPlotDeviceView(forces1DModule, this);
        double d = 1000.0;
        Force1DLookAndFeel force1DLookAndFeel = forces1DModule.getForce1DLookAndFeel();
        PlotDevice.ParameterSet parameterSet = new PlotDevice.ParameterSet(this, Force1DResources.get("Force1DPanel.appliedForce"), this.model.getPlotDeviceModel(), force1DPlotDeviceView, this.model.getAppliedForceDataSeries().getSmoothedDataSeries(), Color.black, new BasicStroke(10.0f), new Rectangle2D.Double(0.0, -d, this.model.getPlotDeviceModel().getMaxTime(), d * 2.0), 0.0, Force1DResources.get("Force1DPanel.newtonsAbbrev"), Force1DResources.get("Force1DPanel.appliedForce"), true, Force1DResources.get("Force1DPanel.forceWithUnits"));
        parameterSet.setZoomRates(300, 100, 5000.0);
        this.forcePlotDevice = new PlotDevice(parameterSet, this.backgroundGraphic, this);
        this.forcePlotDevice.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                Force1DPanel.this.checkBoxPanelGraphic.setVisible(phetGraphic.isVisible());
            }
        });
        this.forcePlotDevice.removeDefaultDataSeries();
        this.forcePlotDevice.setDisplayTextField(true);
        this.forcePlotDevice.setLabelText(Force1DResources.get("Force1DPanel.appliedForceHTML"));
        float f = 3.0f;
        float f2 = 3.0f;
        float f3 = 3.0f;
        int n2 = 190;
        Color color = Force1DUtil.transparify(force1DLookAndFeel.getFrictionForceColor(), n2);
        Color color2 = Force1DUtil.transparify(force1DLookAndFeel.getAppliedForceColor(), n2);
        Color color3 = Force1DUtil.transparify(force1DLookAndFeel.getNetForceColor(), n2);
        int n3 = 0;
        int n4 = 1;
        this.forcePlotDevice.addDataSeries(this.model.getAppliedForceSeries().getSmoothedDataSeries(), color2, Force1DResources.get("ArrowSetGraphic.appliedForce"), new BasicStroke(f2, n3, n4));
        this.forcePlotDevice.addDataSeries(this.model.getFrictionForceSeries(), color, Force1DResources.get("ArrowSetGraphic.frictionForce"), new BasicStroke(f, n3, n4));
        this.forcePlotDevice.addDataSeries(this.model.getNetForceSeries(), color3, Force1DResources.get("ArrowSetGraphic.totalForce"), new BasicStroke(f3, n3, n4));
        this.backgroundGraphic.addGraphic(this.forcePlotDevice);
        this.addGraphic(this.forcePlotDevice.getVerticalChartSlider());
        double d2 = 10.0;
        PlotDevice.ParameterSet parameterSet2 = new PlotDevice.ParameterSet(this, Force1DResources.get("Force1DPanel.acceleration"), this.model.getPlotDeviceModel(), force1DPlotDeviceView, this.model.getAccelerationDataSeries(), force1DLookAndFeel.getAccelerationColor(), new BasicStroke(n), new Rectangle2D.Double(0.0, -d2, this.model.getPlotDeviceModel().getMaxTime(), d2 * 2.0), 0.0, Force1DResources.get("Force1DPanel.accelerationUnitsHTML"), Force1DResources.get("Force1DPanel.acceleration"), false, Force1DResources.get("Force1DPanel.accelerationAndUnitsHTML"));
        this.accelPlotDevice = new PlotDevice(parameterSet2, this.backgroundGraphic, this);
        this.backgroundGraphic.addGraphic(this.accelPlotDevice);
        double d3 = 10.0;
        PlotDevice.ParameterSet parameterSet3 = new PlotDevice.ParameterSet(this, Force1DResources.get("Force1DPanel.velocity"), this.model.getPlotDeviceModel(), force1DPlotDeviceView, this.model.getVelocityDataSeries().getSmoothedDataSeries(), force1DLookAndFeel.getVelocityColor(), new BasicStroke(n), new Rectangle2D.Double(0.0, -d3, this.model.getPlotDeviceModel().getMaxTime(), d3 * 2.0), 0.0, Force1DResources.get("Force1DPanel.velocityUnits"), Force1DResources.get("Force1DPanel.velocity"), false, Force1DResources.get("Force1DPanel.velocityAndUnits"));
        this.velPlotDevice = new PlotDevice(parameterSet3, this.backgroundGraphic, this);
        this.backgroundGraphic.addGraphic(this.velPlotDevice);
        double d4 = 10.0;
        PlotDevice.ParameterSet parameterSet4 = new PlotDevice.ParameterSet(this, Force1DResources.get("Force1DPanel.position"), this.model.getPlotDeviceModel(), force1DPlotDeviceView, this.model.getPositionDataSeries().getSmoothedDataSeries(), force1DLookAndFeel.getPositionColor(), new BasicStroke(n), new Rectangle2D.Double(0.0, -d4, this.model.getPlotDeviceModel().getMaxTime(), d4 * 2.0), 0.0, Force1DResources.get("Force1DPanel.positionUnits"), Force1DResources.get("Force1DPanel.position"), false, Force1DResources.get("Force1DPanel.positionAndUnits"));
        this.posPlotDevice = new PlotDevice(parameterSet4, this.backgroundGraphic, this);
        this.backgroundGraphic.addGraphic(this.posPlotDevice);
        this.forcePlotDevice.addListener(new PlotDevice.Listener(){

            public void readoutChanged(double d) {
            }

            public void valueChanged(double d) {
                Force1DPanel.this.model.setAppliedForce(d);
            }
        });
        this.model.addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                Force1DPanel.this.forcePlotDevice.setValue(Force1DPanel.this.model.getAppliedForce());
            }

            public void gravityChanged() {
            }
        });
        Font font = new Font(PhetFont.getDefaultFontName(), 0, 13);
        String string = Force1DResources.get("Force1DPanel.showFTotalHTML");
        final JCheckBox jCheckBox = new JCheckBox(string, true);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.setShowForceSeries(2, jCheckBox.isSelected());
            }
        });
        jCheckBox.setFont(font);
        String string2 = Force1DResources.get("Force1DPanel.showFrictionHTML");
        final JCheckBox jCheckBox2 = new JCheckBox(string2, true);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.setShowForceSeries(1, jCheckBox2.isSelected());
            }
        });
        jCheckBox2.setFont(font);
        final JCheckBox jCheckBox3 = new JCheckBox(Force1DResources.get("Force1DPanel.showAppliedHTML"), true);
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.setShowForceSeries(0, jCheckBox3.isSelected());
            }
        });
        jCheckBox3.setFont(font);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        ((Container)verticalLayoutPanel).add(jCheckBox);
        ((Container)verticalLayoutPanel).add(jCheckBox2);
        ((Container)verticalLayoutPanel).add(jCheckBox3);
        this.checkBoxPanelGraphic = PhetJComponent.newInstance(this, verticalLayoutPanel);
        FloatingControl floatingControl = new FloatingControl(this.forcePlotDevice.getPlotDeviceModel(), this);
        this.goPauseClearGraphic = PhetJComponent.newInstance(this, floatingControl);
        this.goPauseClearGraphic.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
                Force1DPanel.this.checkBoxPanelGraphic.setLocation(Force1DPanel.this.goPauseClearGraphic.getX(), Force1DPanel.this.goPauseClearGraphic.getY() + Force1DPanel.this.goPauseClearGraphic.getHeight() + 2);
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
            }
        });
        this.addGraphic(this.goPauseClearGraphic, Double.POSITIVE_INFINITY);
        this.model.getPlotDeviceModel().addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingStarted() {
                Force1DPanel.this.repaintGoPauseClear();
            }

            public void recordingPaused() {
                Force1DPanel.this.repaintGoPauseClear();
            }

            public void playbackStarted() {
                Force1DPanel.this.repaintGoPauseClear();
            }

            public void playbackPaused() {
                Force1DPanel.this.repaintGoPauseClear();
            }

            public void reset() {
                Force1DPanel.this.repaintGoPauseClear();
            }

            public void rewind() {
                Force1DPanel.this.repaintGoPauseClear();
            }
        });
        this.addGraphic(this.checkBoxPanelGraphic, Double.POSITIVE_INFINITY);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Force1DPanel.this.requestFocus();
            }
        });
        OffscreenPointerGraphic offscreenPointerGraphic = new OffscreenPointerGraphic(this, this.blockGraphic, this.walkwayGraphic);
        this.addGraphic(offscreenPointerGraphic, 1000.0);
        offscreenPointerGraphic.setLocation(400, 50);
        PhetButton phetButton = new PhetButton(this, Force1DResources.get("Force1DPanel.reset"));
        phetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Resetted.");
                forces1DModule.reset();
            }
        });
        this.addGraphic(phetButton);
        TitleLayout.layout(phetButton, offscreenPointerGraphic);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Force1DPanel.this.forcePlotDevice.getPlotDeviceModel().setRecordMode();
                Force1DPanel.this.forcePlotDevice.getPlotDeviceModel().setPaused(false);
            }
        };
        this.blockGraphic.addMouseInputListener(mouseInputAdapter);
        this.wiggleMe = new WiggleMe((Component)this, forces1DModule.getClock(), Force1DResources.get("Force1DPanel.applyForce"), this.blockGraphic);
        this.wiggleMe.setOscillationAxis(new MutableVector2D(1.0, 0.0));
        this.addGraphic(this.wiggleMe, 10000.0);
        this.model.addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
                Force1DPanel.this.wiggleMe.setVisible(false);
                Force1DPanel.this.removeGraphic(Force1DPanel.this.wiggleMe);
            }

            public void gravityChanged() {
            }
        });
        this.sliderWiggleMe = new WiggleMe((Component)this, forces1DModule.getClock(), Force1DResources.get("Force1DPanel.wiggleMeText"), new WiggleMe.Target(){

            public Point getLocation() {
                int n = Force1DPanel.this.forcePlotDevice.getVerticalChartSlider().getSlider().getX() + Force1DPanel.this.sliderWiggleMe.getWidth() + 10;
                int n2 = Force1DPanel.this.forcePlotDevice.getY() + Force1DPanel.this.forcePlotDevice.getVerticalChartSlider().getSlider().getHeight() / 2;
                return new Point(n, n2);
            }
        });
        this.sliderWiggleMe.setArrow(-30.0, 5.0);
        this.forcePlotDevice.getVerticalChartSlider().getSlider().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Force1DPanel.this.sliderWiggleMe.setVisible(false);
                if (!Force1DPanel.this.goButtonPressed && forces1DModule.getForceModel().getPlotDeviceModel().isPaused()) {
                    Force1DPanel.this.soloGoButtonHelp.setVisible(true);
                }
            }
        });
        floatingControl.getGoButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Force1DPanel.this.soloGoButtonHelp.setVisible(false);
                Force1DPanel.this.goButtonPressed = true;
            }
        });
        this.addGraphic(this.sliderWiggleMe, Double.POSITIVE_INFINITY);
        this.sliderWiggleMe.setVisible(false);
        this.forcePlotDevice.setVisible(false);
        this.accelPlotDevice.setVisible(false);
        this.velPlotDevice.setVisible(false);
        this.posPlotDevice.setVisible(false);
        this.model.getPlotDeviceModel().addListener(new PlotDeviceModel.ListenerAdapter(){

            public void rewind() {
                Force1DPanel.this.updateGraphics();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Force1DPanel.this.setReferenceSize();
            }
        });
        HelpItem2 helpItem2 = new HelpItem2(this, Force1DResources.get("Force1DPanel.sliderHelp"));
        helpItem2.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(this.forcePlotDevice.getVerticalChartSlider().getSliderGraphic()), 30);
        HelpItem2 helpItem22 = new HelpItem2(this, Force1DResources.get("Force1DPanel.goRecordHelp"));
        PhetGraphic phetGraphic = this.getGoButtonGraphic();
        helpItem22.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(phetGraphic), 30);
        HelpItem2 helpItem23 = new HelpItem2(this, Force1DResources.get("Force1DPanel.applyForceHelp"));
        helpItem23.pointUpAt(this.blockGraphic, 15);
        HelpItem2 helpItem24 = new HelpItem2(this, Force1DResources.get("Force1DPanel.zoomHelp"));
        helpItem24.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(this.forcePlotDevice.getChartComponent().getMagPlusGraphic()), 30);
        HelpItem2 helpItem25 = new HelpItem2(this, Force1DResources.get("Force1DPanel.typeHelp"));
        helpItem25.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(this.forcePlotDevice.getTextFieldGraphic()), 20);
        forces1DModule.getHelpManager().addGraphic(helpItem2);
        forces1DModule.getHelpManager().addGraphic(helpItem22);
        forces1DModule.getHelpManager().addGraphic(helpItem23);
        forces1DModule.getHelpManager().addGraphic(helpItem24);
        forces1DModule.getHelpManager().addGraphic(helpItem25);
        this.soloGoButtonHelp = new HelpItem2(this, Force1DResources.get("Force1DPanel.pressGoHelp"));
        this.soloGoButtonHelp.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(phetGraphic), 30);
        this.addGraphic(this.soloGoButtonHelp, Double.POSITIVE_INFINITY);
        this.soloGoButtonHelp.setVisible(false);
        this.setUseOffscreenBuffer(true);
        PlotDevice[] plotDeviceArray = this.getPlotDevices();
        for (int i = 0; i < plotDeviceArray.length; ++i) {
            PlotDevice plotDevice = plotDeviceArray[i];
            plotDevice.addPhetGraphicListener(new PhetGraphicListener(){

                public void phetGraphicChanged(PhetGraphic phetGraphic) {
                }

                public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                    Force1DPanel.this.updateLayout(Force1DPanel.this.getWidth(), Force1DPanel.this.getHeight());
                    for (int i = 0; i < Force1DPanel.this.offsetListeners.size(); ++i) {
                        OffsetManager.Listener listener = (OffsetManager.Listener)Force1DPanel.this.offsetListeners.get(i);
                        listener.offsetChanged();
                    }
                }
            });
        }
    }

    private void repaintGoPauseClear() {
        this.goPauseClearGraphic.repaint();
    }

    private PhetGraphic getGoButtonGraphic() {
        return ((GraphicLayerSet)this.goPauseClearGraphic).getGraphics()[1];
    }

    public void paint(Graphics graphics) {
        super.paintComponent(graphics);
    }

    private void setShowForceSeries(int n, boolean bl) {
        this.forcePlotDevice.setDataSeriesVisible(n, bl);
        this.repaintBuffer();
        this.repaint();
    }

    public Force1DLookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setReferenceSize() {
        super.setReferenceSize();
        this.updateLayout(this.getWidth(), this.getHeight());
        this.leanerGraphic.screenSizeChanged();
    }

    public void updateLayout(int n, int n2) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int n3;
            this.backgroundGraphic.setSize(n, n2);
            Paint paint = this.module.getBackgroundColor();
            this.backgroundGraphic.setBackground(paint);
            int n4 = n / 6;
            int n5 = n3 = 5;
            int n6 = 0;
            int n7 = n - n3 * 2;
            n6 = (int)((double)n6 + this.getOffset());
            this.walkwayTransform.setOutput(n5, n5 + n7);
            this.walkwayGraphic.setBounds(n5, n6, n7, n4);
            this.layoutPlots(n, n2);
            int n8 = 5;
            double d = this.forcePlotDevice.getTextFieldGraphic().getY() + this.forcePlotDevice.getTextFieldGraphic().getHeight() + 10;
            this.goPauseClearGraphic.setLocation(n8, (int)d);
            this.updateGraphics();
            this.repaint();
            this.didLayout = true;
        }
    }

    private int getMaximizedChartCount() {
        PlotDevice[] plotDeviceArray = this.getPlotDevices();
        int n = 0;
        for (int i = 0; i < plotDeviceArray.length; ++i) {
            PlotDevice plotDevice = plotDeviceArray[i];
            if (plotDevice == null || !plotDevice.isVisible()) continue;
            ++n;
        }
        return n;
    }

    public void layoutPlots(int n, int n2) {
        int n3 = n;
        int n4 = 200;
        int n5 = n3 - n4 - 25;
        int n6 = this.walkwayGraphic.getY() + this.walkwayGraphic.getHeight() + 20;
        int n7 = this.forcePlotDevice.getChart().getHorizontalTicks().getMajorTickTextBounds().height * 2;
        Rectangle rectangle = new Rectangle(n4, (int)((double)(n6 + n7) + this.getOffset()), n5, n2 - n6 - n7 * 2);
        if (rectangle.width > 0 && rectangle.height > 0) {
            LayoutUtil.LayoutElement layoutElement;
            int n8;
            int n9 = 7;
            LayoutUtil layoutUtil = new LayoutUtil(rectangle.getY(), rectangle.getHeight() + rectangle.getY(), n9);
            PlotDevice[] plotDeviceArray = this.getPlotDevices();
            LayoutUtil.LayoutElement[] layoutElementArray = new LayoutUtil.LayoutElement[plotDeviceArray.length];
            int n10 = plotDeviceArray[0].getButtonHeight();
            for (n8 = 0; n8 < layoutElementArray.length; ++n8) {
                layoutElement = new LayoutUtil.Dynamic();
                layoutElementArray[n8] = plotDeviceArray[n8].isVisible() ? layoutElement : new LayoutUtil.Fixed(n10);
            }
            layoutUtil.layout(layoutElementArray);
            for (n8 = 0; n8 < layoutElementArray.length; ++n8) {
                layoutElement = layoutElementArray[n8];
                if (plotDeviceArray[n8].isVisible()) {
                    plotDeviceArray[n8].setViewBounds(this.restrictBounds(rectangle, layoutElement));
                    continue;
                }
                plotDeviceArray[n8].setButtonLoc(n4, layoutElement.getMin());
            }
        }
        this.repaintBuffer();
    }

    private PlotDevice[] getPlotDevices() {
        return new PlotDevice[]{this.forcePlotDevice, this.accelPlotDevice, this.velPlotDevice, this.posPlotDevice};
    }

    public void repaintBuffer() {
        this.backgroundGraphic.repaintBuffer();
        this.forcePlotDevice.repaintBuffer();
        this.accelPlotDevice.repaintBuffer();
        this.velPlotDevice.repaintBuffer();
        this.posPlotDevice.repaintBuffer();
    }

    private Rectangle restrictBounds(Rectangle rectangle, LayoutUtil.LayoutElement layoutElement) {
        return new Rectangle(rectangle.x, (int)layoutElement.getMin(), rectangle.width, (int)layoutElement.getSize());
    }

    public WalkwayGraphic getWalkwayGraphic() {
        return this.walkwayGraphic;
    }

    public void updateGraphics() {
        this.repaintGoPauseClear();
        this.arrowSetGraphic.updateGraphics();
        this.blockGraphic.update();
    }

    public void reset() {
        this.repaintBuffer();
        this.forcePlotDevice.reset();
        this.repaint(0, 0, this.getWidth(), this.getHeight());
        this.handleWiggleMes();
    }

    private void handleWiggleMes() {
        boolean bl = this.forcePlotDevice.getVerticalChartSlider().hasMoved();
        if (bl || this.forcePlotDevice.isVisible()) {
            // empty if block
        }
    }

    public Forces1DModule getModule() {
        return this.module;
    }

    public BlockGraphic getBlockGraphic() {
        return this.blockGraphic;
    }

    public void cursorMovedToTime(double d, int n) {
        this.model.setPlaybackIndex(n);
        this.forcePlotDevice.cursorMovedToTime(d, n);
        this.accelPlotDevice.cursorMovedToTime(d, n);
        this.velPlotDevice.cursorMovedToTime(d, n);
        this.posPlotDevice.cursorMovedToTime(d, n);
        this.updateGraphics();
    }

    public void setHelpEnabled(boolean bl) {
        if (bl) {
            this.removeGraphic(this.wiggleMe);
            this.addGraphic(this.wiggleMe, 10000.0);
            this.wiggleMe.setVisible(true);
        } else {
            this.wiggleMe.setVisible(false);
            this.removeGraphic(this.wiggleMe);
        }
    }

    public void layoutPlots() {
        this.layoutPlots(this.getWidth(), this.getHeight());
        this.invalidate();
        this.repaint();
    }

    public void setChartBackground(Color color) {
        System.out.println("color = " + color.getRed() + ", " + color.getBlue() + ", " + color.getGreen());
        this.forcePlotDevice.setChartBackground(color);
        this.accelPlotDevice.setChartBackground(color);
        this.velPlotDevice.setChartBackground(color);
        this.posPlotDevice.setChartBackground(color);
        this.repaintBuffer();
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        this.setReferenceSize();
    }

    public PlotDevice getPlotDevice() {
        return this.forcePlotDevice;
    }

    public void clearData() {
        this.forcePlotDevice.clearData();
    }

    public double getOffset() {
        return this.getMaximizedChartCount() > 0 ? 0.0 : (double)(this.getHeight() / 3);
    }

    public void addListener(OffsetManager.Listener listener) {
        this.offsetListeners.add(listener);
    }

    public boolean isShowComponentForces() {
        return this.arrowSetGraphic.isShowComponentForces();
    }

    public void setShowComponentForces(boolean bl) {
        this.arrowSetGraphic.setShowComponentForces(bl);
    }

    public boolean isShowTotalForce() {
        return this.arrowSetGraphic.isShowTotalForce();
    }

    public void setShowTotalForce(boolean bl) {
        this.arrowSetGraphic.setShowTotalForce(bl);
    }
}

