/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShadowTextGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.view.Arrow;
import edu.colorado.phet.forces1d.view.BlockGraphic;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import edu.colorado.phet.forces1d.view.OffsetManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ArrowSetGraphic
extends CompositePhetGraphic {
    private Force1DPanel force1DPanel;
    private BlockGraphic blockGraphic;
    private Force1DModel model;
    private ModelViewTransform2D transform2D;
    private OffsetManager offsetManager;
    private ForceArrowGraphic applied;
    private ForceArrowGraphic friction;
    private ForceArrowGraphic total;
    private ForceArrowGraphic wall;
    private double arrowTailWidth = 30.0;
    private double arrowHeadHeight = 55.0;
    private Force1DLookAndFeel laf;
    private boolean showComponentForces = true;
    private boolean showTotalForce = true;

    public ArrowSetGraphic(Force1DPanel force1DPanel, BlockGraphic blockGraphic, final Force1DModel force1DModel, ModelViewTransform2D modelViewTransform2D, OffsetManager offsetManager) {
        super(force1DPanel);
        offsetManager.addListener(new OffsetManager.Listener(){

            public void offsetChanged() {
                ArrowSetGraphic.this.updateGraphics();
            }
        });
        this.force1DPanel = force1DPanel;
        this.blockGraphic = blockGraphic;
        this.model = force1DModel;
        this.transform2D = modelViewTransform2D;
        this.offsetManager = offsetManager;
        this.laf = force1DPanel.getLookAndFeel();
        this.applied = new ForceArrowGraphic(force1DPanel, Force1DResources.get("ArrowSetGraphic.appliedForce"), this.laf.getAppliedForceColor(), 0, new ForceComponent(){

            public double getForce() {
                return force1DModel.getAppliedForce();
            }

            public boolean isVisible() {
                return ArrowSetGraphic.this.isShowComponentForces();
            }
        });
        this.friction = new ForceArrowGraphic(force1DPanel, Force1DResources.get("ArrowSetGraphic.frictionForce"), this.laf.getFrictionForceColor(), 0, new ForceComponent(){

            public double getForce() {
                return force1DModel.getStoredFrictionForceValue();
            }

            public boolean isVisible() {
                return ArrowSetGraphic.this.isShowComponentForces();
            }
        });
        this.total = new ForceArrowGraphic(force1DPanel, Force1DResources.get("ArrowSetGraphic.totalForce"), this.laf.getNetForceColor(), 120, new ForceComponent(){

            public double getForce() {
                return force1DModel.getNetForce();
            }

            public boolean isVisible() {
                return ArrowSetGraphic.this.isShowTotalForce();
            }
        });
        this.total.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
        this.wall = new ForceArrowGraphic(force1DPanel, Force1DResources.get("ArrowSetGraphic.wallForce"), this.laf.getWallForceColor(), 60, new ForceComponent(){

            public double getForce() {
                return force1DModel.getWallForce();
            }

            public boolean isVisible() {
                return ArrowSetGraphic.this.isShowComponentForces();
            }
        });
        this.addGraphic(this.applied);
        this.addGraphic(this.friction);
        this.addGraphic(this.total);
        this.addGraphic(this.wall);
    }

    public boolean isShowComponentForces() {
        return this.showComponentForces;
    }

    public void setShowComponentForces(boolean bl) {
        this.showComponentForces = bl;
        this.updateForceArrows();
    }

    public boolean isShowTotalForce() {
        return this.showTotalForce;
    }

    public void setShowTotalForce(boolean bl) {
        this.showTotalForce = bl;
        this.updateForceArrows();
    }

    private void updateForceArrows() {
        this.friction.update();
        this.applied.update();
        this.wall.update();
        this.total.update();
        this.checkTextOverlap();
    }

    private void checkTextOverlap() {
        Rectangle rectangle;
        Rectangle rectangle2;
        if (this.friction.textGraphic.isVisible() && this.applied.textGraphic.isVisible() && (rectangle2 = this.friction.textGraphic.getBounds()).intersects(rectangle = this.applied.textGraphic.getBounds())) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            int n = rectangle3.width;
            int n2 = n / 2 + 5;
            if (rectangle2.x < rectangle.x) {
                this.friction.textGraphic.setLocation(rectangle2.x - n2, this.friction.textGraphic.getY());
                this.applied.textGraphic.setLocation(rectangle.x + n2, this.applied.textGraphic.getY());
            } else {
                this.friction.textGraphic.setLocation(rectangle2.x + n2, this.friction.textGraphic.getY());
                this.applied.textGraphic.setLocation(rectangle.x - n2, this.applied.textGraphic.getY());
            }
        }
    }

    public void updateGraphics() {
        this.updateForceArrows();
    }

    class ForceArrowGraphic
    extends CompositePhetGraphic {
        private String name;
        private Color color;
        private int dy;
        private ForceComponent forceComponent;
        PhetShadowTextGraphic textGraphic;
        PhetShapeGraphic shapeGraphic;
        final Font font;
        private Arrow lastArrow;

        public ForceArrowGraphic(Component component, String string, Color color, int n, ForceComponent forceComponent) {
            super(component);
            this.font = new Font(PhetFont.getDefaultFontName(), 1, 13);
            this.name = string;
            this.color = color = Force1DUtil.transparify(color, 128);
            this.dy = n;
            this.forceComponent = forceComponent;
            this.textGraphic = new PhetShadowTextGraphic(component, this.font, string, Color.black, 1, 1, Color.yellow);
            this.shapeGraphic = new PhetShapeGraphic(component, null, color, new BasicStroke(1.0f), Color.black);
            this.addGraphic(this.shapeGraphic);
            this.addGraphic(this.textGraphic);
            this.update();
        }

        public void update() {
            double d = this.forceComponent.getForce();
            if (d == 0.0) {
                this.setVisible(false);
                return;
            }
            this.setVisible(this.forceComponent.isVisible());
            double d2 = d * 0.5;
            Point point = ArrowSetGraphic.this.blockGraphic.getCenter();
            point.y += ((ArrowSetGraphic)ArrowSetGraphic.this).blockGraphic.computeDimension().height / 2;
            point.y -= this.dy;
            point.y = (int)((double)point.y + ArrowSetGraphic.this.offsetManager.getOffset());
            Point2D.Double double_ = new Point2D.Double(point.x, point.y);
            Point2D.Double double_2 = new MutableVector2D(d2, 0.0).getDestination(double_);
            Arrow arrow = new Arrow(double_, double_2, ArrowSetGraphic.this.arrowHeadHeight, ArrowSetGraphic.this.arrowHeadHeight, ArrowSetGraphic.this.arrowTailWidth, 0.5, false);
            GeneralPath generalPath = arrow.getShape();
            if (this.lastArrow == null || !this.lastArrow.equals(arrow)) {
                this.shapeGraphic.setShape(generalPath);
                GeneralPath generalPath2 = arrow.getTailShape();
                double d3 = this.textGraphic.getHeight();
                double d4 = generalPath2.getBounds().getHeight();
                double d5 = generalPath2.getBounds().getY() + d4 / 2.0 - d3 / 2.0;
                this.textGraphic.setLocation(generalPath2.getBounds().x, (int)d5);
            }
            this.lastArrow = arrow;
        }

        public void setStroke(Stroke stroke) {
            this.shapeGraphic.setStroke(stroke);
        }
    }

    static interface ForceComponent {
        public double getForce();

        public boolean isVisible();
    }
}

