/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Arrow {
    private GeneralPath arrowPath = new GeneralPath();
    private GeneralPath headShape = new GeneralPath();
    private GeneralPath tailShape = new GeneralPath();
    private Point2D tailLocation;
    private Point2D tipLocation;
    private double headHeight;
    private double headWidth;
    private double tailWidth;
    private Vector2D direction;
    private Vector2D norm;
    boolean isHeadDynamic = false;
    private double fractionalHeadHeight;
    private boolean scaleTailToo;

    public boolean equals(Object object) {
        if (object instanceof Arrow) {
            Arrow arrow = (Arrow)object;
            return arrow.tailLocation.equals(this.tailLocation) && arrow.tipLocation.equals(this.tipLocation) && arrow.headHeight == this.headHeight && arrow.headWidth == this.headWidth && arrow.tailWidth == this.tailWidth && arrow.isHeadDynamic == this.isHeadDynamic;
        }
        return false;
    }

    public Arrow(Point2D point2D, Point2D point2D2, double d, double d2, double d3) {
        this.init(point2D, point2D2, d, d2, d3);
        this.computeArrow();
    }

    public Arrow(Point2D point2D, Point2D point2D2, double d, double d2, double d3, double d4, boolean bl) {
        this.fractionalHeadHeight = d4;
        this.scaleTailToo = bl;
        this.isHeadDynamic = true;
        this.init(point2D, point2D2, d, d2, d3);
        this.computeArrow();
    }

    void init(Point2D point2D, Point2D point2D2, double d, double d2, double d3) {
        this.tailLocation = point2D;
        this.tipLocation = point2D2;
        this.headHeight = d;
        this.headWidth = d2;
        this.tailWidth = d3;
    }

    private void computeArrow() {
        if (this.tailLocation.equals(this.tipLocation)) {
            return;
        }
        Vector2D vector2D = new Vector2D(this.tailLocation);
        Vector2D vector2D2 = new Vector2D(this.tipLocation);
        this.direction = vector2D2.minus(vector2D).normalized();
        double d = this.tipLocation.distance(this.tailLocation);
        double d2 = this.headHeight;
        double d3 = this.headWidth;
        double d4 = this.tailWidth;
        if (this.isHeadDynamic && d < this.headHeight / this.fractionalHeadHeight) {
            d2 = d * this.fractionalHeadHeight;
            if (this.scaleTailToo) {
                d4 = this.tailWidth * d2 / this.headHeight;
                d3 = this.headWidth * d2 / this.headHeight;
            }
        } else if (d < this.headHeight) {
            throw new RuntimeException("Head too big.");
        }
        this.norm = this.direction.getPerpendicularVector();
        Vector2D vector2D3 = this.getPoint(-1.0 * d2, -d3 / 2.0);
        Vector2D vector2D4 = this.getPoint(-1.0 * d2, d3 / 2.0);
        Vector2D vector2D5 = this.getPoint(-1.0 * d2, -d4 / 2.0);
        Vector2D vector2D6 = this.getPoint(-1.0 * d2, d4 / 2.0);
        Vector2D vector2D7 = this.getPoint(-1.0 * d, -d4 / 2.0);
        Vector2D vector2D8 = this.getPoint(-1.0 * d, d4 / 2.0);
        this.arrowPath.reset();
        this.arrowPath.moveTo((float)vector2D2.getX(), (float)vector2D2.getY());
        this.lineTo(this.arrowPath, vector2D3);
        this.lineTo(this.arrowPath, vector2D5);
        this.lineTo(this.arrowPath, vector2D7);
        this.lineTo(this.arrowPath, vector2D8);
        this.lineTo(this.arrowPath, vector2D6);
        this.lineTo(this.arrowPath, vector2D4);
        this.lineTo(this.arrowPath, vector2D2);
        this.headShape.reset();
        this.headShape.moveTo((float)vector2D2.getX(), (float)vector2D2.getY());
        this.lineTo(this.headShape, vector2D3);
        this.lineTo(this.headShape, vector2D4);
        this.lineTo(this.headShape, vector2D2);
        this.tailShape.reset();
        this.tailShape.moveTo((float)vector2D5.getX(), (float)vector2D5.getY());
        this.lineTo(this.tailShape, vector2D7);
        this.lineTo(this.tailShape, vector2D8);
        this.lineTo(this.tailShape, vector2D6);
        this.lineTo(this.tailShape, vector2D5);
    }

    private void lineTo(GeneralPath generalPath, Vector2D vector2D) {
        generalPath.lineTo((float)vector2D.getX(), (float)vector2D.getY());
    }

    private Vector2D getPoint(double d, double d2) {
        Vector2D vector2D = this.direction.times(d).plus(this.norm.times(d2));
        Vector2D vector2D2 = new Vector2D(vector2D.getX() + this.tipLocation.getX(), vector2D.getY() + this.tipLocation.getY());
        return vector2D2;
    }

    public GeneralPath getShape() {
        return this.arrowPath;
    }

    public GeneralPath getTailShape() {
        return this.tailShape;
    }
}

