/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.forces1d.model.DataSeries;

public class SmoothDataSeries {
    private DataSeries data = new DataSeries();
    private DataSeries smoothed = new DataSeries();
    private int windowSize;

    public SmoothDataSeries(int n) {
        this.windowSize = n;
    }

    private void updateSmoothedSeries() {
        MathUtil.Average average = new MathUtil.Average();
        int n = this.windowSize;
        n = Math.min(n, this.data.size());
        for (int i = 0; i < n; ++i) {
            average.addValue(this.data.lastPointAt(i));
        }
        double d = average.getAverage();
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        this.smoothed.addPoint(d);
    }

    public DataSeries getSmoothedDataSeries() {
        return this.smoothed;
    }

    public void addPoint(double d) {
        this.data.addPoint(d);
        this.updateSmoothedSeries();
    }

    public int numSmoothedPoints() {
        return this.smoothed.size();
    }

    public void reset() {
        this.data.reset();
        this.smoothed.reset();
    }

    public double smoothedPointAt(int n) {
        return this.smoothed.pointAt(n);
    }
}

