/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import java.util.ArrayList;

public class PhetTimer
implements ModelElement {
    private double time = 0.0;
    private String name;
    private ArrayList listeners = new ArrayList();

    public PhetTimer(String string) {
        this.name = string;
    }

    public void stepInTime(double d) {
        this.time += d;
        this.updateObservers();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void updateObservers() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.timeChanged(this);
        }
    }

    public String toString() {
        return "PhetTimer, name=" + this.name;
    }

    public double getTime() {
        return this.time;
    }

    public void reset() {
        this.time = 0.0;
        this.updateObservers();
    }

    public static interface Listener {
        public void timeChanged(PhetTimer var1);
    }
}

