/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.forces1d.Forces1DModule;
import edu.colorado.phet.forces1d.common.EventChannel;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.model.Block;
import edu.colorado.phet.forces1d.model.BoundaryCondition;
import edu.colorado.phet.forces1d.model.DataSeries;
import edu.colorado.phet.forces1d.model.Force1DPlotDeviceModel;
import edu.colorado.phet.forces1d.model.SmoothDataSeries;
import java.util.ArrayList;
import java.util.EventListener;

public class Force1DModel
implements ModelElement {
    private double gravity = 9.8;
    private double appliedForce;
    private double frictionForce;
    private double netForce;
    private double wallForce = 0.0;
    private Block block;
    private SmoothDataSeries appliedForceDataSeries;
    private SmoothDataSeries netForceDataSeries;
    private SmoothDataSeries accelerationDataSeries;
    private SmoothDataSeries frictionForceDataSeries;
    private SmoothDataSeries velocityDataSeries;
    private SmoothDataSeries positionDataSeries;
    private DataSeries timeSeries;
    private SmoothDataSeries gravitySeries;
    private SmoothDataSeries staticSeries;
    private SmoothDataSeries kineticSeries;
    private SmoothDataSeries massSeries;
    private ArrayList listeners = new ArrayList();
    private Force1DPlotDeviceModel plotDeviceModel;
    private BoundaryCondition open;
    private BoundaryCondition walls;
    private BoundaryCondition boundaryCondition;
    private ArrayList boundaryConditionListeners = new ArrayList();
    private ArrayList imageSeries = new ArrayList();
    private Forces1DModule module;
    private boolean friction = true;
    EventChannel eventChannel = new EventChannel(CollisionListener.class);

    public Force1DModel(Forces1DModule forces1DModule) {
        this.module = forces1DModule;
        this.block = new Block(this);
        this.open = new BoundaryCondition.Open(this);
        this.walls = new BoundaryCondition.Walls(this);
        this.boundaryCondition = this.open;
        int n = 8;
        this.plotDeviceModel = new Force1DPlotDeviceModel(forces1DModule, this, 20.0, 0.02);
        this.appliedForceDataSeries = new SmoothDataSeries(n);
        this.netForceDataSeries = new SmoothDataSeries(n);
        this.accelerationDataSeries = new SmoothDataSeries(n);
        this.frictionForceDataSeries = new SmoothDataSeries(n);
        this.velocityDataSeries = new SmoothDataSeries(n);
        this.positionDataSeries = new SmoothDataSeries(n);
        this.gravitySeries = new SmoothDataSeries(n);
        this.staticSeries = new SmoothDataSeries(n);
        this.kineticSeries = new SmoothDataSeries(n);
        this.massSeries = new SmoothDataSeries(n);
        this.timeSeries = new DataSeries();
    }

    public double getNetForce() {
        return this.netForce;
    }

    public void addBoundaryConditionListener(BoundaryCondition.Listener listener) {
        this.boundaryConditionListeners.add(listener);
    }

    void setWallForce(double d) {
        if (this.wallForce != d) {
            this.wallForce = d;
        }
    }

    public double getWallForce() {
        return this.wallForce;
    }

    public void setBoundsOpen() {
        this.boundaryCondition = this.open;
        for (int i = 0; i < this.boundaryConditionListeners.size(); ++i) {
            BoundaryCondition.Listener listener = (BoundaryCondition.Listener)this.boundaryConditionListeners.get(i);
            listener.boundaryConditionOpen();
        }
    }

    public void setBoundsWalled() {
        this.boundaryCondition = this.walls;
        for (int i = 0; i < this.boundaryConditionListeners.size(); ++i) {
            ((BoundaryCondition.Listener)this.boundaryConditionListeners.get(i)).boundaryConditionWalls();
        }
    }

    public boolean isBoundsWalled() {
        return this.boundaryCondition == this.walls;
    }

    public void setPlaybackIndex(int n) {
        int n2 = this.netForceDataSeries.numSmoothedPoints();
        if (n < n2) {
            double d;
            double d2;
            double d3;
            if (n == 0) {
                this.netForce = 0.0;
                this.frictionForce = 0.0;
            } else {
                this.netForce = this.netForceDataSeries.smoothedPointAt(n);
                this.frictionForce = this.frictionForceDataSeries.smoothedPointAt(n);
            }
            this.setAppliedForce(this.appliedForceDataSeries.smoothedPointAt(n));
            this.block.setAcceleration(this.accelerationDataSeries.smoothedPointAt(n));
            this.block.setVelocity(this.velocityDataSeries.smoothedPointAt(n));
            this.block.setPosition(this.positionDataSeries.smoothedPointAt(n));
            this.appliedForceChanged();
            double d4 = this.gravitySeries.smoothedPointAt(n);
            if (d4 != this.gravity) {
                this.gravity = d4;
                this.fireGravityChanged();
            }
            if ((d3 = this.kineticSeries.smoothedPointAt(n)) != this.block.getStaticFriction()) {
                this.block.setKineticFriction(d3);
            }
            if ((d2 = this.staticSeries.smoothedPointAt(n)) != this.block.getStaticFriction()) {
                this.block.setStaticFriction(d2);
            }
            if ((d = this.massSeries.smoothedPointAt(n)) != this.block.getMass()) {
                this.block.setMass(d);
            }
            int n3 = (Integer)this.imageSeries.get(n);
            this.module.setImageIndex(n3);
        }
    }

    public void stepInTime(double d) {
        this.plotDeviceModel.stepInTime(d);
    }

    public void stepRecord(double d) {
        this.updateBlockAcceleration();
        this.block.stepInTime(d);
        double d2 = this.boundaryCondition.apply();
        if (d2 != 0.0) {
            this.netForce = this.block.getMass() * this.block.getAcceleration();
        }
        this.netForceDataSeries.addPoint(this.netForce);
        this.frictionForceDataSeries.addPoint(this.frictionForce);
        this.appliedForceDataSeries.addPoint(this.getAppliedForce());
        this.accelerationDataSeries.addPoint(this.block.getAcceleration());
        this.velocityDataSeries.addPoint(this.block.getVelocity());
        this.positionDataSeries.addPoint(this.block.getPosition());
        this.gravitySeries.addPoint(this.getGravity());
        this.kineticSeries.addPoint(this.block.getKineticFriction());
        this.staticSeries.addPoint(this.block.getStaticFriction());
        this.massSeries.addPoint(this.block.getMass());
        this.timeSeries.addPoint(this.plotDeviceModel.getRecordingTimer().getTime());
        this.imageSeries.add(new Integer(this.module.getImageIndex()));
    }

    public void stepPlayback(double d, int n) {
        this.plotDeviceModel.cursorMovedToTime(d, n);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getStoredFrictionForceValue() {
        return this.frictionForce;
    }

    public PlotDeviceModel getPlotDeviceModel() {
        return this.plotDeviceModel;
    }

    public void reset() {
        this.frictionForce = 0.0;
        this.netForce = 0.0;
        this.block.setPosition(-7.0);
        this.block.setVelocity(0.0);
        this.setAppliedForce(0.0);
        this.netForceDataSeries.reset();
        this.appliedForceDataSeries.reset();
        this.frictionForceDataSeries.reset();
        this.accelerationDataSeries.reset();
        this.positionDataSeries.reset();
        this.velocityDataSeries.reset();
        this.gravitySeries.reset();
        this.kineticSeries.reset();
        this.staticSeries.reset();
        this.massSeries.reset();
        this.timeSeries.reset();
        this.imageSeries.clear();
        this.updateBlockAcceleration();
        this.fireGravityChanged();
        this.plotDeviceModel.doReset();
        this.plotDeviceModel.clearData();
    }

    public DataSeries getNetForceSeries() {
        return this.netForceDataSeries.getSmoothedDataSeries();
    }

    public DataSeries getFrictionForceSeries() {
        return this.frictionForceDataSeries.getSmoothedDataSeries();
    }

    public void setFrictionEnabled(boolean bl) {
        this.friction = bl;
    }

    public SmoothDataSeries getAppliedForceSeries() {
        return this.appliedForceDataSeries;
    }

    public boolean isFrictionEnabled() {
        return this.friction;
    }

    public void fireCollisionHappened(double d) {
        CollisionListener collisionListener = (CollisionListener)this.eventChannel.getListenerProxy();
        CollisionEvent collisionEvent = new CollisionEvent(d);
        collisionListener.collisionOccurred(collisionEvent);
    }

    public void addCollisionListener(CollisionListener collisionListener) {
        this.eventChannel.addListener(collisionListener);
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double d) {
        this.gravity = d;
        this.updateBlockAcceleration();
        this.fireGravityChanged();
    }

    private void fireGravityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.gravityChanged();
        }
    }

    public double getAppliedForce() {
        return this.appliedForce;
    }

    public void setAppliedForce(double d) {
        if (d != this.appliedForce) {
            this.appliedForce = d;
            this.updateBlockAcceleration();
            this.appliedForceChanged();
        }
    }

    private void appliedForceChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.appliedForceChanged();
        }
    }

    void updateBlockAcceleration() {
        this.frictionForce = this.getFrictionForce();
        this.wallForce = this.boundaryCondition.getWallForce(this.appliedForce, this.frictionForce);
        this.netForce = this.appliedForce + this.frictionForce + this.wallForce;
        double d = this.netForce / this.block.getMass();
        this.block.setAcceleration(d);
    }

    public double getFrictionForce() {
        if (!this.friction) {
            return 0.0;
        }
        if (this.block.isMoving()) {
            double d = this.block.getVelocity() >= 0.0 ? -1.0 : 1.0;
            double d2 = d * this.block.getKineticFriction() * this.block.getMass() * this.gravity;
            return d2;
        }
        double d = Math.max(this.block.getKineticFriction(), this.block.getStaticFriction());
        double d3 = d * this.block.getMass() * this.gravity;
        if (Math.abs(d3) > Math.abs(this.appliedForce)) {
            return -this.appliedForce;
        }
        double d4 = this.appliedForce >= 0.0 ? -1.0 : 1.0;
        double d5 = d * this.block.getMass() * this.gravity * d4;
        return d5;
    }

    public Block getBlock() {
        return this.block;
    }

    public SmoothDataSeries getAppliedForceDataSeries() {
        return this.appliedForceDataSeries;
    }

    public DataSeries getAccelerationDataSeries() {
        return this.accelerationDataSeries.getSmoothedDataSeries();
    }

    public SmoothDataSeries getVelocityDataSeries() {
        return this.velocityDataSeries;
    }

    public SmoothDataSeries getPositionDataSeries() {
        return this.positionDataSeries;
    }

    public static class CollisionEvent {
        double momentum = 0.0;

        public CollisionEvent(double d) {
            this.momentum = d;
        }

        public double getMomentum() {
            return this.momentum;
        }
    }

    public static interface CollisionListener
    extends EventListener {
        public void collisionOccurred(CollisionEvent var1);
    }

    public static interface Listener {
        public void appliedForceChanged();

        public void gravityChanged();
    }
}

