/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.model;

import edu.colorado.phet.forces1d.model.Block;
import edu.colorado.phet.forces1d.model.Force1DModel;

public abstract class BoundaryCondition {
    Force1DModel model;

    protected BoundaryCondition(Force1DModel force1DModel) {
        this.model = force1DModel;
    }

    public abstract double apply();

    public abstract double getWallForce(double var1, double var3);

    public static interface Listener {
        public void boundaryConditionOpen();

        public void boundaryConditionWalls();
    }

    public static class Open
    extends BoundaryCondition {
        public Open(Force1DModel force1DModel) {
            super(force1DModel);
        }

        public double apply() {
            this.model.setWallForce(0.0);
            return 0.0;
        }

        public double getWallForce(double d, double d2) {
            return 0.0;
        }
    }

    public static class Walls
    extends BoundaryCondition {
        private Block block;

        public Walls(Force1DModel force1DModel) {
            super(force1DModel);
            this.block = force1DModel.getBlock();
        }

        public double apply() {
            if (this.block.getPosition() > 10.0) {
                double d = Math.abs(this.block.getMass() * this.block.getVelocity());
                this.block.setPosition(10.0);
                this.block.setAcceleration(-20.0);
                this.block.setVelocity(0.0);
                this.model.fireCollisionHappened(d);
                return -20.0;
            }
            if (this.block.getPosition() < -10.0) {
                double d = Math.abs(this.block.getMass() * this.block.getVelocity());
                this.block.setPosition(-10.0);
                this.block.setAcceleration(20.0);
                this.block.setVelocity(0.0);
                this.model.fireCollisionHappened(d);
                return 20.0;
            }
            return 0.0;
        }

        public double getWallForce(double d, double d2) {
            boolean bl;
            boolean bl2 = this.block.getPosition() >= 10.0 && d > 0.0;
            boolean bl3 = bl = this.block.getPosition() <= -10.0 && d < 0.0;
            if (bl2 || bl) {
                return -(d + d2);
            }
            return 0.0;
        }
    }
}

