/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.model;

import edu.colorado.phet.forces1d.model.Force1DModel;
import java.util.ArrayList;

public class Block {
    private double kineticFriction = 1.0;
    private double staticFriction = 2.0;
    private double mass = 1.0;
    private double position = -7.0;
    private double velocity = 0.0;
    private double acceleration = 0.0;
    private ArrayList listeners = new ArrayList();
    private Force1DModel model;

    public Block(Force1DModel force1DModel) {
        this.model = force1DModel;
    }

    public double getKineticFriction() {
        return this.kineticFriction;
    }

    public void setKineticFriction(double d) {
        this.kineticFriction = d;
        this.model.updateBlockAcceleration();
        this.firePropertyChanged();
    }

    public double getStaticFriction() {
        return this.staticFriction;
    }

    public void setStaticFriction(double d) {
        this.staticFriction = d;
        this.model.updateBlockAcceleration();
        this.firePropertyChanged();
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        this.mass = d;
        this.model.updateBlockAcceleration();
        this.firePropertyChanged();
    }

    private void firePropertyChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.propertyChanged();
        }
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double d) {
        this.velocity = d;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(double d) {
        this.acceleration = d;
    }

    public void stepInTime(double d) {
        double d2 = this.position;
        double d3 = this.velocity;
        this.velocity += this.acceleration * d;
        if (this.changedSign(d3, this.velocity)) {
            this.velocity = 0.0;
        }
        this.position += this.velocity * d;
        if (d2 != this.position) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.positionChanged();
            }
        }
    }

    public void setStaticAndKineticFriction(double d, double d2) {
        this.setStaticFriction(d);
        this.setKineticFriction(d2);
        if (this.getStaticFriction() < this.getKineticFriction()) {
            this.setStaticFriction(this.getKineticFriction());
        }
    }

    public void userSetKineticFriction(double d) {
        this.setKineticFriction(d);
        if (this.getStaticFriction() < this.getKineticFriction()) {
            this.setStaticFriction(this.getKineticFriction());
        }
    }

    public void userSetStaticFriction(double d) {
        this.setStaticFriction(d);
    }

    private boolean changedSign(double d, double d2) {
        Sign sign = Sign.toSign(d);
        Sign sign2 = Sign.toSign(d2);
        boolean bl = sign.equals(Sign.POSITIVE) && sign2.equals(Sign.NEGATIVE);
        boolean bl2 = sign.equals(Sign.NEGATIVE) && sign2.equals(Sign.POSITIVE);
        boolean bl3 = bl || bl2;
        return bl3;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean isMoving() {
        return this.velocity != 0.0;
    }

    public static interface Listener {
        public void positionChanged();

        public void propertyChanged();
    }

    static class Sign {
        static final Sign POSITIVE = new Sign("+");
        static final Sign NEGATIVE = new Sign("-");
        static final Sign ZERO = new Sign("0");
        private String s;

        public static Sign toSign(double d) {
            if (d > 0.0) {
                return POSITIVE;
            }
            if (d < 0.0) {
                return NEGATIVE;
            }
            return ZERO;
        }

        public Sign(String string) {
            this.s = string;
        }

        public boolean equals(Object object) {
            return object instanceof Sign && ((Sign)object).s.equals(this.s);
        }
    }
}

