/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common.plotdevice;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.forces1d.model.DataSeries;
import edu.colorado.phet.forces1d.model.PhetTimer;
import java.util.ArrayList;

public abstract class PlotDeviceModel
implements ModelElement {
    private double minTime = 0.0;
    private double maxTime;
    private double timeScale;
    private boolean paused;
    private RecordMode recordMode = new RecordMode();
    private PlaybackMode playbackMode = new PlaybackMode();
    private Mode currentMode = this.recordMode;
    private ArrayList listeners = new ArrayList();

    protected PlotDeviceModel(double d, double d2) {
        this.maxTime = d;
        this.timeScale = d2;
        this.paused = true;
    }

    public void setPaused(boolean bl) {
        if (this.paused != bl) {
            this.paused = bl;
            if (this.paused) {
                this.currentMode.firePaused();
            } else {
                this.currentMode.fireUnpaused();
            }
        }
    }

    public void setRecordMode() {
        this.currentMode = this.recordMode;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.recordingStarted();
        }
    }

    public void stepInTime(double d) {
        boolean bl;
        boolean bl2 = bl = this.currentMode == null;
        if (!bl && !this.paused) {
            this.currentMode.stepInTime(d * this.timeScale);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public PhetTimer getRecordingTimer() {
        return this.recordMode.timer;
    }

    public PhetTimer getPlaybackTimer() {
        return this.playbackMode.timer;
    }

    public boolean isTakingData() {
        return this.currentMode == this.recordMode && !this.paused;
    }

    public double getMinTime() {
        return this.minTime;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public abstract void cursorMovedToTime(double var1, int var3);

    public abstract void reset();

    public int convertTimeToIndex(double d) {
        if (this.recordMode.recordedTimes.size() == 0) {
            return 0;
        }
        double d2 = this.recordMode.recordedTimes.getLastPoint();
        double d3 = this.recordMode.recordedTimes.size();
        double d4 = d3 / d2;
        int n = (int)(d * d4);
        if (n < 0) {
            n = 0;
        }
        if (n >= this.recordMode.recordedTimes.size()) {
            n = this.recordMode.recordedTimes.size() - 1;
        }
        return n;
    }

    public double convertIndexToTime(int n) {
        return this.recordMode.recordedTimes.pointAt(n);
    }

    protected abstract void stepRecord(double var1);

    protected abstract void stepPlayback(double var1, int var3);

    public void doReset() {
        this.setPaused(true);
        this.playbackMode.reset();
        this.recordMode.reset();
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.reset();
        }
    }

    public void setPlaybackMode() {
        this.currentMode = this.playbackMode;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.playbackStarted();
        }
    }

    public void rewind() {
        this.playbackMode.rewind();
        this.stepPlayback(0.0, 0);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.rewind();
        }
    }

    public static interface Listener {
        public void recordingStarted();

        public void recordingPaused();

        public void playbackStarted();

        public void playbackPaused();

        public void reset();

        public void rewind();
    }

    public static class ListenerAdapter
    implements Listener {
        public void recordingStarted() {
        }

        public void recordingPaused() {
        }

        public void playbackStarted() {
        }

        public void playbackPaused() {
        }

        public void reset() {
        }

        public void rewind() {
        }
    }

    private abstract class Mode {
        PhetTimer timer;

        protected Mode(String string) {
            this.timer = new PhetTimer(string);
        }

        public abstract void stepInTime(double var1);

        public abstract void firePaused();

        public abstract void fireUnpaused();

        public void reset() {
            this.timer.reset();
            PlotDeviceModel.this.cursorMovedToTime(0.0, 0);
        }
    }

    private class PlaybackMode
    extends Mode {
        int playbackIndex;
        private double conversionFactor;

        public PlaybackMode() {
            super("playback");
            this.playbackIndex = 0;
        }

        public void rewind() {
            this.playbackIndex = 0;
            this.timer.reset();
        }

        public void stepInTime(double d) {
            this.timer.stepInTime(d);
            this.conversionFactor = this.timer.getTime() / (double)this.playbackIndex;
            PlotDeviceModel.this.stepPlayback(this.timer.getTime(), this.playbackIndex++);
        }

        public void firePaused() {
            for (int i = 0; i < PlotDeviceModel.this.listeners.size(); ++i) {
                Listener listener = (Listener)PlotDeviceModel.this.listeners.get(i);
                listener.playbackPaused();
            }
        }

        public void fireUnpaused() {
            for (int i = 0; i < PlotDeviceModel.this.listeners.size(); ++i) {
                Listener listener = (Listener)PlotDeviceModel.this.listeners.get(i);
                listener.playbackStarted();
            }
        }

        public void reset() {
            this.playbackIndex = 0;
            super.reset();
        }
    }

    private class RecordMode
    extends Mode {
        int recordIndex;
        DataSeries recordedTimes;

        public RecordMode() {
            super("record.path");
            this.recordIndex = 0;
            this.recordedTimes = new DataSeries();
        }

        public void stepInTime(double d) {
            this.timer.stepInTime(d);
            this.recordedTimes.addPoint(this.timer.getTime());
            PlotDeviceModel.this.stepRecord(d);
        }

        public void firePaused() {
            for (int i = 0; i < PlotDeviceModel.this.listeners.size(); ++i) {
                Listener listener = (Listener)PlotDeviceModel.this.listeners.get(i);
                listener.recordingPaused();
            }
        }

        public void fireUnpaused() {
            for (int i = 0; i < PlotDeviceModel.this.listeners.size(); ++i) {
                Listener listener = (Listener)PlotDeviceModel.this.listeners.get(i);
                listener.recordingStarted();
            }
        }

        public void reset() {
            this.recordedTimes.reset();
            this.recordIndex = 0;
            super.reset();
        }
    }
}

