/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common.plotdevice;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.charts.BufferedLinePlot;
import edu.colorado.phet.forces1d.charts.Chart;
import edu.colorado.phet.forces1d.charts.DataSet;
import edu.colorado.phet.forces1d.charts.Range2D;
import edu.colorado.phet.forces1d.charts.controllers.HorizontalCursor2;
import edu.colorado.phet.forces1d.charts.controllers.VerticalChartSlider2;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceView;
import edu.colorado.phet.forces1d.model.DataSeries;
import edu.colorado.phet.forces1d.model.PhetTimer;
import edu.colorado.phet.forces1d.view.BufferedPhetGraphic;
import edu.colorado.phet.forces1d.view.OffsetManager;
import edu.colorado.phet.forces1d.view.PlotDeviceFontManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PlotDevice
extends GraphicLayerSet {
    private boolean displayTextField = false;
    private Color chartBackgroundColor = new Color(255, 247, 204);
    private String title;
    private PlotDeviceModel plotDeviceModel;
    private PlotDeviceView plotDeviceView;
    private PhetTimer timer;
    private Color color;
    private Stroke stroke;
    private VerticalChartSlider2 verticalChartSlider;
    private HorizontalCursor2 horizontalCursor;
    private TextBox textBox;
    private ChartComponent chartComponent;
    private PhetGraphic showButtonGraphic;
    private DecimalFormat format = new DecimalFormat("0.00");
    private String units;
    private Font verticalTitleFont = PlotDeviceFontManager.getFontSet().getVerticalTitleFont();
    private ArrayList listeners = new ArrayList();
    private PhetTextGraphic timeLabel;
    private double value = Double.NaN;
    private BufferedPhetGraphic bufferedPhetGraphic;
    private boolean controllable;
    private Point buttonLoc = new Point();
    private PhetGraphic textFieldGraphic;
    private ApparatusPanel apparatusPanel;
    private OffsetManager offsetManager;
    double lastTextValue = Double.NaN;

    public PlotDevice(final ParameterSet parameterSet, BufferedPhetGraphic bufferedPhetGraphic, OffsetManager offsetManager) throws IOException {
        super(parameterSet.panel);
        this.offsetManager = offsetManager;
        this.controllable = parameterSet.controllable;
        this.bufferedPhetGraphic = bufferedPhetGraphic;
        this.plotDeviceView = parameterSet.plotDeviceView;
        this.units = parameterSet.units;
        this.title = parameterSet.title;
        this.plotDeviceModel = parameterSet.plotDeviceModel;
        this.timer = parameterSet.plotDeviceModel.getRecordingTimer();
        this.color = parameterSet.color;
        this.stroke = parameterSet.stroke;
        int n = parameterSet.singleClickZoom;
        int n2 = parameterSet.holdDownZoom;
        double d = parameterSet.maxZoomRange;
        this.chartComponent = new ChartComponent(parameterSet.panel, parameterSet.inputBox, parameterSet.series, parameterSet.xShift, n2, n, d, parameterSet.verticalTitle);
        final ApparatusPanel apparatusPanel = parameterSet.panel;
        Rectangle2D.Double double_ = parameterSet.inputBox;
        this.horizontalCursor = new HorizontalCursor2(apparatusPanel, this.chartComponent.getChart(), new Color(15, 0, 255, 50), new Color(50, 0, 255, 150), 8);
        this.horizontalCursor.addListener(new HorizontalCursor2.Listener(){

            public void modelValueChanged(double d) {
                PlotDevice.this.plotDeviceModel.setPlaybackMode();
                PlotDevice.this.plotDeviceModel.setPaused(true);
                int n = PlotDevice.this.plotDeviceModel.convertTimeToIndex(d);
                PlotDevice.this.plotDeviceModel.cursorMovedToTime(d, n);
            }
        });
        apparatusPanel.addGraphic(this.horizontalCursor, 1000.0);
        this.setInputRange(double_);
        this.timer.addListener(new PhetTimer.Listener(){

            public void timeChanged(PhetTimer phetTimer) {
                PlotDevice.this.update();
            }
        });
        ChartButton chartButton = new ChartButton(Force1DResources.get("PlotDevice.graph") + " " + this.title);
        chartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotDevice.this.setVisible(true);
            }
        });
        this.showButtonGraphic = PhetJComponent.newInstance(apparatusPanel, chartButton);
        this.verticalChartSlider = new VerticalChartSlider2(apparatusPanel, this.chartComponent.getChart());
        this.verticalChartSlider.addListener(new VerticalChartSlider2.Listener(){

            public void valueChanged(double d) {
                for (int i = 0; i < PlotDevice.this.listeners.size(); ++i) {
                    Listener listener = (Listener)PlotDevice.this.listeners.get(i);
                    listener.valueChanged(d);
                }
            }
        });
        this.setCloseHandler(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotDevice.this.setVisible(false);
                PlotDevice.this.plotDeviceView.relayout();
            }
        });
        this.textBox = new TextBox(this.plotDeviceModel, 9, parameterSet.labelStr, this);
        this.textBox.setHorizontalAlignment(4);
        this.textFieldGraphic = PhetJComponent.newInstance(apparatusPanel, this.textBox.textField);
        this.addListener(new Listener(){

            public void readoutChanged(double d) {
                PlotDevice.this.textFieldGraphic.repaint();
            }

            public void valueChanged(double d) {
                PlotDevice.this.textFieldGraphic.repaint();
            }
        });
        this.apparatusPanel = parameterSet.panel;
        this.plotDeviceModel.addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingPaused() {
                Timer timer = new Timer(30, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        if (PlotDevice.this.displayTextField) {
                            if (apparatusPanel instanceof ApparatusPanel2) {
                                ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)apparatusPanel;
                                apparatusPanel2.getGraphic().setKeyFocus(PlotDevice.this.textFieldGraphic);
                            }
                            PlotDevice.this.textFieldGraphic.gainedKeyFocus();
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }

            public void recordingStarted() {
                PlotDevice.this.textFieldGraphic.lostKeyFocus();
            }

            public void playbackStarted() {
                PlotDevice.this.textFieldGraphic.lostKeyFocus();
            }

            public void playbackPaused() {
                PlotDevice.this.textFieldGraphic.gainedKeyFocus();
            }
        });
        this.setTextValue(0.0);
        this.plotDeviceModel.getRecordingTimer().addListener(new PhetTimer.Listener(){

            public void timeChanged(PhetTimer phetTimer) {
                PlotDevice.this.updateTextBox(PlotDevice.this.plotDeviceModel, parameterSet.series);
            }
        });
        this.plotDeviceModel.getPlaybackTimer().addListener(new PhetTimer.Listener(){

            public void timeChanged(PhetTimer phetTimer) {
                PlotDevice.this.updateTextBox(PlotDevice.this.plotDeviceModel, parameterSet.series);
            }
        });
        this.plotDeviceModel.addListener(new PlotDeviceModel.ListenerAdapter(){

            public void rewind() {
                PlotDevice.this.horizontalCursor.setX(0.0);
            }
        });
        this.timeLabel = new PhetTextGraphic(apparatusPanel, PlotDeviceFontManager.getFontSet().getTimeLabelFont(), Force1DResources.get("PlotDevice.time"), Color.red, 0, 0);
        this.addGraphic(this.chartComponent.getChart());
        this.addGraphic(this.timeLabel);
        this.updateControllable();
        this.plotDeviceModel.addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingStarted() {
                if (PlotDevice.this.isVisible()) {
                    PlotDevice.this.horizontalCursor.setVisible(false);
                }
            }

            public void recordingPaused() {
                if (PlotDevice.this.isVisible()) {
                    PlotDevice.this.horizontalCursor.setVisible(true);
                    PlotDevice.this.horizontalCursor.setModelX(PlotDevice.this.horizontalCursor.getMaxX());
                }
            }

            public void playbackStarted() {
                if (PlotDevice.this.isVisible()) {
                    PlotDevice.this.horizontalCursor.setVisible(true);
                }
            }

            public void playbackPaused() {
                if (PlotDevice.this.isVisible()) {
                    PlotDevice.this.horizontalCursor.setVisible(true);
                }
            }

            public void reset() {
            }

            public void rewind() {
                if (PlotDevice.this.isVisible()) {
                    PlotDevice.this.horizontalCursor.setVisible(true);
                }
            }
        });
        this.horizontalCursor.setVisible(false);
    }

    public PhetGraphic getTextFieldGraphic() {
        return this.textFieldGraphic;
    }

    public ChartComponent getChartComponent() {
        return this.chartComponent;
    }

    public void setDisplayTextField(boolean bl) {
        this.displayTextField = bl;
        if (bl) {
            this.apparatusPanel.addGraphic(this.textFieldGraphic);
        } else {
            this.apparatusPanel.removeGraphic(this.textFieldGraphic);
        }
    }

    public void setDataSeriesVisible(int n, boolean bl) {
        this.chartComponent.setDataSeriesVisible(n, bl);
    }

    private void updateControllable() {
        if (!this.controllable) {
            this.setSliderVisible(false);
            this.textBox.setEditable(false);
        }
    }

    private void setInputRange(Rectangle2D.Double double_) {
        Range2D range2D = new Range2D(double_);
        this.getChart().setRange(range2D);
        this.plotDeviceView.repaintBackground(this.getChart().getViewBounds());
    }

    private void updateTextBox(PlotDeviceModel plotDeviceModel, DataSeries dataSeries) {
        double d;
        int n = 0;
        if (plotDeviceModel.isTakingData()) {
            n = dataSeries.size() - 1;
        } else {
            d = plotDeviceModel.getPlaybackTimer().getTime() + this.chartComponent.getxShift();
            n = (int)d;
        }
        if (dataSeries.indexInBounds(n)) {
            d = dataSeries.pointAt(n);
            this.setTextValue(d);
        }
    }

    public void setValue(double d) {
        if (d != this.value) {
            this.verticalChartSlider.setValue(d);
            this.setTextValue(d);
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.valueChanged(d);
            }
            this.value = d;
        }
    }

    public Chart getChart() {
        return this.chartComponent.getChart();
    }

    public void addDataSeries(DataSeries dataSeries, Color color, String string, Stroke stroke) {
        this.chartComponent.addSeries(dataSeries, color, string, stroke);
    }

    public void setButtonLoc(int n, double d) {
        this.buttonLoc.setLocation((double)n, d);
        this.showButtonGraphic.setLocation(this.buttonLoc.x, this.buttonLoc.y);
        this.textFieldGraphic.setLocation(20, (int)d);
    }

    public int getButtonHeight() {
        return this.showButtonGraphic.getHeight();
    }

    public void repaintBuffer() {
        if (this.isVisible()) {
            this.chartComponent.repaintBuffer();
        }
    }

    public void setChartBackground(Color color) {
        this.chartComponent.setBackground(color);
    }

    public void clearData() {
        this.chartComponent.clearData();
    }

    public void removeDefaultDataSeries() {
        this.chartComponent.removeDefaultDataSeries();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setTextValue(double d) {
        if (this.lastTextValue != d) {
            this.lastTextValue = d;
            String string = this.format.format(d);
            if (string.equals("-0.00")) {
                string = "0.00";
            }
            if (!this.textBox.getText().equals(string)) {
                this.textBox.setText(string);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    Listener listener = (Listener)this.listeners.get(i);
                    listener.readoutChanged(d);
                }
            }
        }
    }

    public void setLabelText(String string) {
        this.textBox.setLabelText(string);
    }

    private double[] getYLines(double d, double d2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d3 = d2; d3 < d; d3 += d2) {
            arrayList.add(new Double(d3));
        }
        if (arrayList.size() > 5) {
            return this.getYLines(d, d2 * 2.0);
        }
        if (arrayList.size() <= 1) {
            return this.getYLines(d, d2 / 2.0);
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return dArray;
    }

    public void setCloseHandler(ActionListener actionListener) {
        this.chartComponent.closeButton.addActionListener(actionListener);
    }

    public PlotDeviceModel getPlotDeviceModel() {
        return this.plotDeviceModel;
    }

    public void reset() {
        this.chartComponent.reset();
        this.horizontalCursor.setMaxX(Double.POSITIVE_INFINITY);
        this.horizontalCursor.setVisible(false);
        this.setTextValue(0.0);
        this.verticalChartSlider.setValue(0.0);
    }

    public void setViewBounds(Rectangle rectangle) {
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.chartComponent.setViewBounds(rectangle);
            this.verticalChartSlider.setOffsetX(((ChartComponent)this.chartComponent).chart.getVerticalTicks().getMajorTickTextBounds().width + this.getChart().getTitle().getBounds().width);
            this.verticalChartSlider.update();
            int n = 5;
            this.textBox.setBounds(n, this.getChart().getViewBounds().y, this.textBox.getPreferredSize().width, this.textBox.getPreferredSize().height);
            this.textFieldGraphic.setLocation(n, (int)((double)this.getChart().getViewBounds().y + this.offsetManager.getOffset()));
            this.chartComponent.setViewBounds(rectangle);
            Point point = RectangleUtils.getCenter(this.chartComponent.determineBounds());
            this.timeLabel.setLocation(point);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setSliderVisible(bl);
        if (bl) {
            this.horizontalCursor.setVisible(true);
        } else {
            this.horizontalCursor.setVisible(false);
        }
        this.chartComponent.setVisible(bl);
        this.plotDeviceView.getApparatusPanel().setLayout(null);
        this.plotDeviceView.getApparatusPanel().addGraphic(this.showButtonGraphic, Double.POSITIVE_INFINITY);
        this.showButtonGraphic.setLocation(this.buttonLoc.x, this.buttonLoc.y);
        this.plotDeviceView.relayout();
        this.showButtonGraphic.setVisible(!bl);
        this.textBox.setVisible(bl && this.displayTextField);
        this.updateControllable();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlotDevice.this.plotDeviceView.relayout();
            }
        });
    }

    public void update() {
        this.chartComponent.update((float)this.timer.getTime());
    }

    public void setSliderVisible(boolean bl) {
        this.verticalChartSlider.setVisible(bl);
    }

    public VerticalChartSlider2 getVerticalChartSlider() {
        return this.verticalChartSlider;
    }

    public void cursorMovedToTime(double d, int n) {
        if (n < ((ChartComponent)this.chartComponent).seriesAt((int)0).dataSeries.size()) {
            this.horizontalCursor.setX(d);
            DataSeries dataSeries = ((ChartComponent)this.chartComponent).seriesAt((int)0).dataSeries;
            this.verticalChartSlider.setValue(dataSeries.pointAt(n));
            this.setTextValue(dataSeries.pointAt(n));
            this.chartComponent.cursorMovedToTime(d, n);
        }
    }

    public static class ChartButton
    extends JButton {
        private static Font font = PlotDeviceFontManager.getFontSet().getChartButtonFont();

        public ChartButton(String string) throws IOException {
            super(string);
            this.setFont(font);
            this.setVerticalTextPosition(0);
            this.setHorizontalTextPosition(2);
        }
    }

    public class ChartComponent {
        private ArrayList series = new ArrayList();
        private Chart chart;
        private float lastTime;
        private double xShift;
        private Series defaultSeries;
        private PhetGraphic magPlusGraphic;
        private PhetGraphic magMinusGraphic;
        private PhetGraphic closeButtonGraphic;
        private CloseButton closeButton = new CloseButton();

        private Series seriesAt(int n) {
            return (Series)this.series.get(n);
        }

        public void addSeries(DataSeries dataSeries, Color color, String string, Stroke stroke) {
            Series series = new Series(string, (ApparatusPanel)PlotDevice.this.getComponent(), dataSeries, stroke, color);
            this.addSeries(series);
        }

        public void setDataSeriesVisible(int n, boolean bl) {
            this.seriesAt(n).setVisible(bl);
        }

        public void cursorMovedToTime(double d, int n) {
            for (int i = 0; i < this.series.size(); ++i) {
                Series series = (Series)this.series.get(i);
                series.cursorMovedToTime(d, n);
            }
        }

        public void repaintBuffer() {
            for (int i = 0; i < this.series.size(); ++i) {
                Series series = (Series)this.series.get(i);
                series.repaintBuffer();
            }
        }

        public void setBackground(Color color) {
            this.chart.setBackground(color);
        }

        public void clearData() {
            for (int i = 0; i < this.series.size(); ++i) {
                Series series = (Series)this.series.get(i);
                series.clearData();
            }
        }

        public void removeDefaultDataSeries() {
            this.series.remove(this.defaultSeries);
            this.defaultSeries.remove();
        }

        public PhetGraphic getMagPlusGraphic() {
            return this.magPlusGraphic;
        }

        public ChartComponent(ApparatusPanel apparatusPanel, Rectangle2D rectangle2D, DataSeries dataSeries, double d, double d2, double d3, double d4, String string) throws IOException {
            Font font = PlotDeviceFontManager.getFontSet().getAxisFont();
            this.chart = new Chart(apparatusPanel, new Range2D(rectangle2D), new Rectangle(0, 0, 100, 100));
            this.defaultSeries = new Series(PlotDevice.this.title, apparatusPanel, dataSeries, PlotDevice.this.stroke, PlotDevice.this.color);
            this.addSeries(this.defaultSeries);
            this.xShift = d;
            this.chart.setBackground(PlotDevice.this.chartBackgroundColor);
            this.chart.getHorizontalTicks().setVisible(false);
            this.chart.getHorizonalGridlines().setMajorGridlinesColor(Color.darkGray);
            this.chart.getVerticalGridlines().setMajorGridlinesColor(Color.darkGray);
            this.chart.getXAxis().setMajorTickFont(font);
            this.chart.getYAxis().setMajorTicksVisible(false);
            this.chart.getYAxis().setMajorTickFont(font);
            this.chart.getVerticalGridlines().setMinorGridlinesVisible(false);
            this.chart.getXAxis().setMajorGridlines(new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0});
            this.chart.getXAxis().setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f));
            this.chart.getYAxis().setMinorTicksVisible(false);
            double d5 = rectangle2D.getHeight() / 10.0;
            this.chart.getYAxis().setMajorTickSpacing(d5);
            this.chart.getVerticalTicks().setMajorTickSpacing(d5);
            this.chart.getHorizonalGridlines().setMajorTickSpacing(d5);
            this.chart.setVerticalTitle(string, PlotDevice.this.color, PlotDevice.this.verticalTitleFont, 60);
            this.chart.getVerticalTicks().setMajorOffset(new JSlider().getWidth() - 5, 0);
            this.closeButton.setToolTipText(Force1DResources.get("PlotDevice.closeGraph"));
            this.closeButtonGraphic = PhetJComponent.newInstance(apparatusPanel, this.closeButton);
            apparatusPanel.addGraphic(this.closeButtonGraphic, Double.POSITIVE_INFINITY);
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("forces-1d/images/icons/glass-20-plus.gif");
            BufferedImage bufferedImage2 = ImageLoader.loadBufferedImage("forces-1d/images/icons/glass-20-minus.gif");
            Increment increment = new Increment(d2);
            Decrement decrement = new Decrement(d2, d4);
            Increment increment2 = new Increment(d3);
            Decrement decrement2 = new Decrement(d3, d4);
            MagButton magButton = new MagButton(new ImageIcon(bufferedImage), increment, increment2, Force1DResources.get("PlotDevice.zoomIn"));
            MagButton magButton2 = new MagButton(new ImageIcon(bufferedImage2), decrement, decrement2, Force1DResources.get("PlotDevice.zoomOut"));
            this.magPlusGraphic = PhetJComponent.newInstance(apparatusPanel, magButton);
            this.magMinusGraphic = PhetJComponent.newInstance(apparatusPanel, magButton2);
            apparatusPanel.addGraphic(this.magPlusGraphic, Double.POSITIVE_INFINITY);
            apparatusPanel.addGraphic(this.magMinusGraphic, Double.POSITIVE_INFINITY);
        }

        private void addSeries(Series series) {
            this.series.add(series);
        }

        protected Rectangle determineBounds() {
            return this.chart.getVisibleBounds();
        }

        public void setInputRange(Rectangle2D.Double double_) {
            Range2D range2D = new Range2D(double_);
            this.chart.setRange(range2D);
        }

        public double getxShift() {
            return this.xShift;
        }

        public Chart getChart() {
            return this.chart;
        }

        public void reset() {
            for (int i = 0; i < this.series.size(); ++i) {
                Series series = (Series)this.series.get(i);
                series.reset();
            }
        }

        public void setVisible(boolean bl) {
            this.closeButtonGraphic.setVisible(bl);
            this.magPlusGraphic.setVisible(bl);
            this.magMinusGraphic.setVisible(bl);
            for (int i = 0; i < this.series.size(); ++i) {
                Series series = (Series)this.series.get(i);
                series.setVisible(bl);
            }
        }

        public void update(float f) {
            if (f == this.lastTime) {
                return;
            }
            for (int i = 0; i < this.series.size(); ++i) {
                this.seriesAt(i).update(f);
            }
            PlotDevice.this.horizontalCursor.setMaxX(f);
        }

        public void setMagnitude(double d) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(PlotDevice.this.plotDeviceModel.getMinTime(), -d, PlotDevice.this.plotDeviceModel.getMaxTime() - PlotDevice.this.plotDeviceModel.getMinTime(), d * 2.0);
            PlotDevice.this.chartComponent.setInputRange(double_);
            PlotDevice.this.plotDeviceView.repaintBackground(this.getChart().getViewBounds());
        }

        public void setViewBounds(Rectangle rectangle) {
            this.chart.setViewBounds(rectangle);
            this.chart.getVerticalTicks().setMajorOffset(0, 0);
            Rectangle rectangle2 = this.chart.getViewBounds();
            int n = rectangle2.x + rectangle2.width - this.closeButtonGraphic.getWidth();
            int n2 = rectangle2.y;
            this.closeButtonGraphic.setLocation(n - 2, n2 + 2);
            Dimension dimension = new Dimension(this.magPlusGraphic.getWidth(), this.magPlusGraphic.getHeight());
            int n3 = 1;
            int n4 = 7;
            int n5 = this.chart.getViewBounds().y + this.chart.getViewBounds().height - 2 * dimension.height - n3 - n4;
            int n6 = this.chart.getViewBounds().x + 3;
            this.magPlusGraphic.setLocation(n6, n5);
            this.magMinusGraphic.setLocation(n6, n5 + n3 + dimension.height);
            for (int i = 0; i < this.series.size(); ++i) {
                Series series = (Series)this.series.get(i);
                series.setViewBounds(rectangle);
            }
        }

        public void setPaintYLines(double[] dArray) {
            double[] dArray2 = new double[dArray.length * 2 + 1];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = dArray[i];
                dArray2[dArray2.length - 1 - i] = -dArray[i];
            }
            dArray2[dArray.length] = 0.0;
            double[] dArray3 = new double[dArray.length * 2];
            for (int i = 0; i < dArray.length; ++i) {
                dArray3[i] = dArray[i];
                dArray3[dArray3.length - 1 - i] = -dArray[i];
            }
            this.chart.getHorizonalGridlines().setMajorGridlines(dArray3);
            this.chart.getVerticalTicks().setMajorGridlines(dArray2);
            this.chart.getYAxis().setMajorGridlines(dArray2);
        }

        class Decrement
        implements ActionListener {
            double increment;
            double maxRange;

            public Decrement(double d, double d2) {
                this.increment = d;
                this.maxRange = d2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                double d;
                Range2D range2D = ChartComponent.this.chart.getRange();
                double d2 = range2D.getMaxY();
                double d3 = d2 + this.increment;
                if (d3 < (d = this.maxRange)) {
                    ChartComponent.this.setMagnitude(d3);
                    ChartComponent.this.setPaintYLines(PlotDevice.this.getYLines(d3, 5.0));
                    PlotDevice.this.plotDeviceView.repaintBackground();
                }
            }
        }

        class Increment
        implements ActionListener {
            double increment;

            public Increment(double d) {
                this.increment = d;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Range2D range2D = ChartComponent.this.chart.getRange();
                double d = range2D.getMaxY();
                double d2 = d - this.increment;
                if (d2 > 0.0) {
                    ChartComponent.this.setMagnitude(d2);
                    ChartComponent.this.setPaintYLines(PlotDevice.this.getYLines(d2, 5.0));
                    PlotDevice.this.plotDeviceView.repaintBackground();
                }
            }
        }

        public class Series {
            DataSet dataSet;
            DataSeries dataSeries;
            PhetTextGraphic readout;
            PhetTextGraphic readoutValue;
            private BufferedLinePlot bufferedLinePlot;
            DecimalFormat format = new DecimalFormat("0.0");
            private PhetGraphic readoutUnits;
            private boolean visible = true;
            private ApparatusPanel panel;

            public Series(String string, ApparatusPanel apparatusPanel, DataSeries dataSeries, Stroke stroke, Color color) {
                this.panel = apparatusPanel;
                Font font = PlotDeviceFontManager.getFontSet().getReadoutFont();
                this.dataSeries = dataSeries;
                this.dataSet = new DataSet();
                this.bufferedLinePlot = new BufferedLinePlot(ChartComponent.this.chart, this.dataSet, stroke, color, PlotDevice.this.bufferedPhetGraphic);
                dataSeries.addListener(new DataSeries.Listener(){

                    public void changed() {
                        Series.this.update((float)PlotDevice.this.timer.getTime());
                    }
                });
                this.readout = new PhetTextGraphic(apparatusPanel, font, string + " = ", color, 100, 100);
                apparatusPanel.addGraphic(this.readout, 10000.0);
                this.readoutValue = new PhetTextGraphic(apparatusPanel, font, "0.0 ", color, 100, 100);
                this.readoutUnits = PlotDevice.this.units.startsWith("<html>") ? new HTMLGraphic(apparatusPanel, font, PlotDevice.this.units, color) : new PhetTextGraphic(apparatusPanel, font, PlotDevice.this.units, color, 0, 0);
                this.readoutValue.addPhetGraphicListener(new PhetGraphicListener(){

                    public void phetGraphicChanged(PhetGraphic phetGraphic) {
                        int n = phetGraphic.getY() + phetGraphic.getHeight();
                        int n2 = Series.this.readoutUnits.getHeight();
                        Series.this.readoutUnits.setLocation(phetGraphic.getX() + phetGraphic.getWidth(), n - n2);
                    }

                    public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                        Series.this.readoutUnits.setVisible(phetGraphic.isVisible());
                    }
                });
                apparatusPanel.addGraphic(this.readoutValue, 10000.0);
                apparatusPanel.addGraphic(this.readoutUnits, 10000.0);
            }

            public void remove() {
                this.panel.removeGraphic(this.readout);
                this.panel.removeGraphic(this.readoutValue);
                this.panel.removeGraphic(this.readoutUnits);
            }

            public void reset() {
                this.dataSet.clear();
                this.dataSeries.reset();
            }

            public void setVisible(boolean bl) {
                this.visible = bl;
                boolean bl2 = bl && PlotDevice.this.isVisible();
                this.readout.setVisible(bl2);
                this.readoutValue.setVisible(bl2);
                this.bufferedLinePlot.setVisible(bl2);
            }

            public void setViewBounds(Rectangle rectangle) {
                int n = ChartComponent.this.series.indexOf(this);
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    n2 += ((ChartComponent)ChartComponent.this).seriesAt((int)i).readout.getBounds().height + 2;
                }
                this.readout.setLocation(((ChartComponent)ChartComponent.this).chart.getViewBounds().x + 15, ((ChartComponent)ChartComponent.this).chart.getViewBounds().y + this.readout.getHeight() - 5 + n2);
                this.readoutValue.setLocation(this.readout.getLocation().x + this.readout.getWidth() + 5, this.readout.getLocation().y);
            }

            public void update(float f) {
                ChartComponent.this.lastTime = f;
                if (this.dataSeries.size() <= 1) {
                    this.dataSet.clear();
                } else {
                    double d = this.dataSeries.getLastPoint();
                    if (Double.isInfinite(d)) {
                        return;
                    }
                    Point2D.Double double_ = new Point2D.Double((double)f - ChartComponent.this.xShift, d);
                    this.dataSet.addPoint(double_);
                    String string = this.format.format(d) + " ";
                    this.readoutValue.setText(string);
                    PlotDevice.this.horizontalCursor.setMaxX(f);
                }
            }

            public void cursorMovedToTime(double d, int n) {
                double d2 = this.dataSeries.pointAt(n);
                String string = this.format.format(d2) + " ";
                this.readoutValue.setText(string);
            }

            public void repaintBuffer() {
                if (this.visible && PlotDevice.this.isVisible()) {
                    this.bufferedLinePlot.clear();
                    this.dataSet.clear();
                    this.bufferedLinePlot.setAutoRepaint(false);
                    for (int i = 0; i < this.dataSeries.size(); ++i) {
                        double d = this.dataSeries.pointAt(i);
                        double d2 = PlotDevice.this.plotDeviceModel.convertIndexToTime(i);
                        this.dataSet.addPoint(d2, d);
                    }
                    this.bufferedLinePlot.setAutoRepaint(true);
                    this.bufferedLinePlot.repaintAll();
                }
            }

            public void clearData() {
                this.readoutValue.setText(this.format.format(0.0) + " ");
            }
        }
    }

    private static class CloseButton
    extends JButton {
        private static Icon icon;

        public CloseButton() throws IOException {
            super(CloseButton.loadIcon());
        }

        public static Icon loadIcon() throws IOException {
            if (icon == null) {
                BufferedImage bufferedImage = ImageLoader.loadBufferedImage("forces-1d/images/x-30.png");
                icon = new ImageIcon(bufferedImage);
            }
            return icon;
        }
    }

    public static interface Listener {
        public void readoutChanged(double var1);

        public void valueChanged(double var1);
    }

    static class MagButton
    extends JButton {
        public MagButton(Icon icon, ActionListener actionListener, ActionListener actionListener2, String string) {
            super(icon);
            this.addMouseListener(new RepeatClicker(actionListener, actionListener2));
            this.setToolTipText(string);
        }
    }

    public static class ParameterSet {
        private ApparatusPanel panel;
        private String title;
        private PlotDeviceModel plotDeviceModel;
        private PlotDeviceView plotDeviceView;
        private DataSeries series;
        private Color color;
        private Stroke stroke;
        private Rectangle2D.Double inputBox;
        private double xShift;
        private String units;
        private String labelStr;
        private boolean controllable;
        public int singleClickZoom = 5;
        public int holdDownZoom = 1;
        public double maxZoomRange = 100.0;
        public String verticalTitle;

        public ParameterSet(ApparatusPanel apparatusPanel, String string, PlotDeviceModel plotDeviceModel, PlotDeviceView plotDeviceView, DataSeries dataSeries, Color color, Stroke stroke, Rectangle2D.Double double_, double d, String string2, String string3, boolean bl, String string4) {
            this.panel = apparatusPanel;
            this.title = string;
            this.plotDeviceModel = plotDeviceModel;
            this.plotDeviceView = plotDeviceView;
            this.series = dataSeries;
            this.color = color;
            this.stroke = stroke;
            this.inputBox = double_;
            this.xShift = d;
            this.units = string2;
            this.labelStr = string3;
            this.controllable = bl;
            this.verticalTitle = string4;
        }

        public void setZoomRates(int n, int n2, double d) {
            this.singleClickZoom = n;
            this.holdDownZoom = n2;
            this.maxZoomRange = d;
        }
    }

    static class RepeatClicker
    extends MouseAdapter {
        ActionListener target;
        private ActionListener discrete;
        int initDelay = 300;
        int delay = 30;
        Timer timer;
        private long pressTime;

        public RepeatClicker(ActionListener actionListener, ActionListener actionListener2) {
            this.target = actionListener;
            this.discrete = actionListener2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.pressTime = System.currentTimeMillis();
            this.timer = new Timer(this.delay, this.target);
            this.timer.setInitialDelay(this.initDelay);
            this.timer.start();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.timer != null) {
                this.timer.stop();
                long l = System.currentTimeMillis();
                if (l - this.pressTime < (long)this.initDelay) {
                    this.discrete.actionPerformed(null);
                }
            }
        }
    }

    public static class TextBox
    extends JPanel {
        private TypingTextField textField;
        JLabel label;
        static Font font = PlotDeviceFontManager.getFontSet().getTextBoxFont();
        private PlotDevice plotDevice;

        public TextBox(PlotDeviceModel plotDeviceModel, int n, String string, PlotDevice plotDevice) {
            this.plotDevice = plotDevice;
            this.textField = new TypingTextField(n, plotDevice, plotDeviceModel);
            this.label = new JLabel(string);
            this.setLayout(new FlowLayout(1));
            this.label.setFont(font);
            this.textField.setFont(font);
            this.add(this.label);
            this.add(this.textField);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        public synchronized void addKeyListener(KeyListener keyListener) {
            this.textField.addKeyListener(keyListener);
        }

        public void setEditable(boolean bl) {
            this.textField.setEditable(bl);
        }

        public void setHorizontalAlignment(int n) {
            this.textField.setHorizontalAlignment(n);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setText(String string) {
            if (string.length() > this.textField.getColumns()) {
                string = string.subSequence(0, this.textField.getColumns()) + "";
            }
            if (!this.textField.getText().equals(string)) {
                this.textField.setText(string);
            }
        }

        public void setLabelText(String string) {
            this.label.setText(string);
        }
    }

    public static class TypingTextField
    extends JTextField {
        private PlotDevice plotDevice;
        private boolean changedByUser = false;

        public TypingTextField(int n, PlotDevice plotDevice, PlotDeviceModel plotDeviceModel) {
            super(n);
            Font font = new Font(PhetFont.getDefaultFontName(), 0, 12);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Force1DResources.get("PlotDevice.appliedForce"), 0, 0, font, plotDevice.color));
            this.plotDevice = plotDevice;
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (TypingTextField.this.isEnabled()) {
                        TypingTextField.this.selectAll();
                    }
                }
            });
            this.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                    TypingTextField.this.changedByUser = true;
                    if (keyEvent.getKeyCode() == 10) {
                        TypingTextField.this.parseAndSetValue();
                    }
                }
            });
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    TypingTextField.this.changedByUser = true;
                    TypingTextField.this.parseAndSetValue();
                }
            });
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (bl) {
                this.selectAll();
            }
        }

        private void parseAndSetValue() {
            String string = this.getText();
            string = string.replace(',', '.');
            double d = Double.parseDouble(string);
            this.plotDevice.setValue(d);
        }
    }
}

