/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common.plotdevice;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.view.PlotDeviceFontManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JButton;

public class FloatingControl
extends VerticalLayoutPanel {
    private static BufferedImage play;
    private static BufferedImage pause;
    private JButton pauseButton = new ControlButton(Force1DResources.get("FloatingControl.pause"));
    private JButton recordButton;
    private JButton resetButton;

    public JButton getGoButton() {
        return this.recordButton;
    }

    public FloatingControl(final PlotDeviceModel plotDeviceModel, final ApparatusPanel apparatusPanel) {
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                plotDeviceModel.setPaused(true);
            }
        });
        this.recordButton = new ControlButton(Force1DResources.get("FloatingControl.go"));
        this.recordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                plotDeviceModel.setRecordMode();
                plotDeviceModel.setPaused(false);
            }
        });
        this.resetButton = new ControlButton(Force1DResources.get("FloatingControl.clear"));
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = plotDeviceModel.isPaused();
                plotDeviceModel.setPaused(true);
                int n = PhetOptionPane.showYesNoDialog(apparatusPanel, Force1DResources.get("FloatingControl.sureToClear"));
                if (n == 0 || n == 0) {
                    plotDeviceModel.reset();
                } else if (n == 2 || n == 1) {
                    plotDeviceModel.setPaused(bl);
                }
            }
        });
        plotDeviceModel.addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingStarted() {
                FloatingControl.this.setButtons(false, true, true);
            }

            public void recordingPaused() {
                FloatingControl.this.setButtons(true, false, true);
            }

            public void reset() {
                FloatingControl.this.setButtons(true, false, false);
            }

            public void rewind() {
                FloatingControl.this.setButtons(true, false, true);
            }
        });
        this.add(this.recordButton);
        this.add(this.pauseButton);
        this.add(this.resetButton);
        this.pauseButton.setEnabled(false);
    }

    private void setButtons(boolean bl, boolean bl2, boolean bl3) {
        this.recordButton.setEnabled(bl);
        this.pauseButton.setEnabled(bl2);
        this.resetButton.setEnabled(bl3);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    static {
        try {
            play = ImageLoader.loadBufferedImage("forces-1d/images/icons/java/media/Play16.gif");
            pause = ImageLoader.loadBufferedImage("forces-1d/images/icons/java/media/Pause16.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static class ControlButton
    extends JButton {
        static Font font = PlotDeviceFontManager.getFontSet().getControlButtonFont();

        public ControlButton(String string) {
            super(string);
            this.setFont(font);
        }
    }
}

