/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common.phetcomponents;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.MouseInputAdapter;

public class PhetButton
extends CompositePhetGraphic {
    private String text;
    private PhetTextGraphic textGraphic;
    private PhetShapeGraphic backgroundGraphic;
    private ArrayList listeners = new ArrayList();
    private Color backgroundColor = Color.lightGray;
    private Color textColor = Color.black;
    private Color clickColor = Color.gray;
    private Color borderColor = Color.black;
    private Stroke borderStroke = new BasicStroke(2.0f);
    private Font font = new Font(PhetFont.getDefaultFontName(), 1, 18);
    static int eventID = 0;

    public PhetButton(Component component, String string) {
        super(component);
        this.text = string;
        this.textGraphic = new PhetTextGraphic(component, this.font, string, this.textColor, 0, 0);
        this.backgroundGraphic = new PhetShapeGraphic(component, null, this.backgroundColor, this.borderStroke, this.borderColor);
        this.addMouseInputListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PhetButton.this.backgroundGraphic.setColor(PhetButton.this.clickColor);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PhetButton.this.fireEvent();
                PhetButton.this.backgroundGraphic.setColor(PhetButton.this.backgroundColor);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                PhetButton.this.backgroundGraphic.setBorderColor(Color.white);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                PhetButton.this.backgroundGraphic.setBorderColor(PhetButton.this.borderColor);
            }
        });
        this.addGraphic(this.backgroundGraphic);
        this.addGraphic(this.textGraphic);
        this.setCursorHand();
        this.update();
    }

    private void fireEvent() {
        ActionEvent actionEvent = new ActionEvent(this, eventID++, "PhetButtonPress");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.listeners.get(i);
            actionListener.actionPerformed(actionEvent);
        }
    }

    private void update() {
        this.textGraphic.setText(this.text);
        this.textGraphic.setFont(this.font);
        this.textGraphic.setColor(this.textColor);
        this.backgroundGraphic.setBorderPaint(this.borderColor);
        this.backgroundGraphic.setColor(this.backgroundColor);
        this.backgroundGraphic.setStroke(this.borderStroke);
        Rectangle rectangle = this.textGraphic.getLocalBounds();
        rectangle = RectangleUtils.expand(rectangle, 5, 5);
        this.backgroundGraphic.setShape(rectangle);
        this.setBoundsDirty();
        this.autorepaint();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }
}

