/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.common;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.forces1d.common.ShadowHTMLGraphic;
import edu.colorado.phet.forces1d.view.Arrow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;

public class WiggleMe
extends CompositePhetGraphic {
    private long t0 = System.currentTimeMillis();
    private double frequency = 2.5;
    private double amplitude = 30.0;
    private MutableVector2D oscillationAxis;
    private Target target;
    private PhetShapeGraphic phetShapeGraphic;
    private ShadowHTMLGraphic textGraphic;
    private ClockListener tickListener;
    private IClock clock;

    public WiggleMe(Component component, IClock iClock, String string, PhetGraphic phetGraphic) {
        this(component, iClock, string, new PhetGraphicTarget(phetGraphic));
    }

    public WiggleMe(Component component, IClock iClock, String string, Target target) {
        this(component, iClock, string, target, new Font(PhetFont.getDefaultFontName(), 1, 20), 1, 1);
    }

    public WiggleMe(Component component, IClock iClock, String string, Target target, Font font, int n, int n2) {
        super(component);
        this.target = target;
        this.clock = iClock;
        this.oscillationAxis = new MutableVector2D(0.0, 1.0);
        Color color = new Color(39, 27, 184);
        Color color2 = new Color(6, 0, 44);
        this.textGraphic = new ShadowHTMLGraphic(component, string, font, color, n, n2, color2);
        this.addGraphic(this.textGraphic);
        this.textGraphic.setLocation(0, 0);
        this.tickListener = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                WiggleMe.this.tick();
            }
        };
        this.setVisible(true);
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(50.0, 0.0), 20.0, 20.0, 10.0);
        this.phetShapeGraphic = new PhetShapeGraphic(component, arrow.getShape(), Color.blue, new BasicStroke(2.0f), Color.black);
        this.addGraphic(this.phetShapeGraphic);
        this.setRegistrationPoint(this.getBounds().x, this.getBounds().y);
        this.tick();
        this.setIgnoreMouse(true);
        this.phetShapeGraphic.setLocation(this.textGraphic.getWidth() - this.phetShapeGraphic.getWidth() - 5, this.textGraphic.getHeight() + 5);
    }

    public void setOscillationAxis(MutableVector2D mutableVector2D) {
        this.oscillationAxis = mutableVector2D;
    }

    public void setFrequency(double d) {
        this.frequency = d;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (!this.clock.containsClockListener(this.tickListener)) {
                this.clock.addClockListener(this.tickListener);
            }
        } else {
            while (this.clock.containsClockListener(this.tickListener)) {
                this.clock.removeClockListener(this.tickListener);
            }
        }
        this.t0 = System.currentTimeMillis();
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public void setFont(Font font) {
        this.textGraphic.setFont(font);
    }

    public void setArrow(double d, double d2) {
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(d, d2), 20.0, 20.0, 10.0);
        this.phetShapeGraphic.setShape(arrow.getShape());
    }

    private void tick() {
        double d = (double)(System.currentTimeMillis() - this.t0) / 1000.0;
        double d2 = Math.PI * 2 / this.frequency;
        if (this.isVisible() && this.getComponent().isShowing() && d < 3.0 * d2) {
            Point point = this.target.getLocation();
            Point point2 = new Point(point.x - this.getWidth() - 5, point.y);
            double d3 = Math.sin(this.frequency * d) * this.amplitude;
            Vector2D vector2D = this.oscillationAxis.getInstanceOfMagnitude(d3);
            Point2D.Double double_ = vector2D.getDestination(point2);
            this.setLocation((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
        }
    }

    public void setArrowColor(Color color) {
        this.phetShapeGraphic.setColor(color);
    }

    public static class PhetGraphicTarget
    implements Target {
        private PhetGraphic target;

        public PhetGraphicTarget(PhetGraphic phetGraphic) {
            this.target = phetGraphic;
        }

        public Point getLocation() {
            Point point = this.target.getLocation();
            return point;
        }
    }

    public static interface Target {
        public Point getLocation();
    }
}

