/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.charts.controllers;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.forces1d.charts.Chart;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VerticalChartSlider2
extends GraphicLayerSet {
    private Chart chart;
    private JSlider slider;
    private EventChannel eventChannel = new EventChannel(Listener.class);
    private Listener proxy = (Listener)this.eventChannel.getListenerProxy();
    private int numTicks = 1000;
    public int offsetX = 0;
    private boolean changed;
    private PhetGraphic sliderGraphic;
    private int preferredWidth;

    public VerticalChartSlider2(ApparatusPanel apparatusPanel, Chart chart) {
        super(apparatusPanel);
        this.chart = chart;
        this.slider = new JSlider(1, 0, this.numTicks, this.numTicks / 2);
        this.slider.setPaintTicks(true);
        this.preferredWidth = this.slider.getPreferredSize().width;
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = VerticalChartSlider2.this.getValue();
                VerticalChartSlider2.this.proxy.valueChanged(d);
                VerticalChartSlider2.this.changed = true;
            }
        });
        this.sliderGraphic = PhetJComponent.newInstance(apparatusPanel, this.slider);
        this.addGraphic(this.sliderGraphic);
        this.update();
        apparatusPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                VerticalChartSlider2.this.update();
            }
        });
    }

    public double getValue() {
        int n = this.slider.getValue();
        Rectangle rectangle = this.chart.getViewBounds();
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, this.numTicks, rectangle.y + rectangle.height, rectangle.y);
        double d = linearFunction.evaluate(n);
        double d2 = this.chart.getModelViewTransform().viewToModelY((int)d);
        return d2;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public void update() {
        Rectangle rectangle = this.chart.getViewBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        Dimension dimension = this.getIconDimension();
        int n3 = dimension.height / 2;
        int n4 = dimension.width;
        Rectangle rectangle2 = new Rectangle(n - n4 - this.offsetX, n2 - n3, this.slider.getPreferredSize().width, rectangle.height + n3 * 2);
        this.slider.setPreferredSize(new Dimension(rectangle2.width, rectangle2.height));
        this.slider.setOpaque(false);
        this.setLocation(rectangle2.x, rectangle2.y);
        this.sliderGraphic.repaint();
    }

    private Dimension getIconDimension() {
        Icon icon = UIManager.getIcon("Slider.verticalThumbIcon");
        if (icon == null) {
            return new Dimension(this.preferredWidth, this.preferredWidth);
        }
        return new Dimension(icon.getIconWidth(), icon.getIconHeight());
    }

    public void setValue(double d) {
        ChangeListener changeListener;
        int n;
        double d2 = this.chart.getModelViewTransform().modelToViewY(d);
        Rectangle rectangle = this.chart.getViewBounds();
        Function.LinearFunction linearFunction = new Function.LinearFunction(rectangle.y + rectangle.height, rectangle.y, 0.0, this.numTicks);
        int n2 = (int)linearFunction.evaluate(d2);
        ChangeListener[] changeListenerArray = this.slider.getChangeListeners();
        for (n = 0; n < changeListenerArray.length; ++n) {
            changeListener = changeListenerArray[n];
            this.slider.removeChangeListener(changeListener);
        }
        this.slider.setValue(n2);
        for (n = 0; n < changeListenerArray.length; ++n) {
            changeListener = changeListenerArray[n];
            this.slider.addChangeListener(changeListener);
        }
        this.sliderGraphic.repaint();
    }

    public boolean hasMoved() {
        return this.changed;
    }

    public void addListener(Listener listener) {
        this.eventChannel.addListener(listener);
    }

    public PhetGraphic getSliderGraphic() {
        return this.sliderGraphic;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public static interface Listener
    extends EventListener {
        public void valueChanged(double var1);
    }
}

