/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.charts;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.forces1d.charts.AbstractTicks;
import edu.colorado.phet.forces1d.charts.Axis;
import edu.colorado.phet.forces1d.charts.DataSetGraphic;
import edu.colorado.phet.forces1d.charts.GridLineSet;
import edu.colorado.phet.forces1d.charts.Range2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Chart
extends PhetGraphic {
    private Component component;
    private Range2D range;
    private Rectangle viewBounds;
    private ArrayList dataSetGraphics = new ArrayList();
    private Axis xAxis;
    private Axis yAxis;
    private GridLineSet verticalGridlines;
    private GridLineSet horizonalGridlines;
    private TickMarkSet verticalTicks;
    private TickMarkSet horizontalTicks;
    private Paint background = Color.white;
    private Stroke outlineStroke = new BasicStroke(1.0f);
    private Color outlineColor = Color.black;
    private ModelViewTransform2D transform;
    private ArrayList listeners = new ArrayList();
    private AbstractTitle title;

    public Chart(Component component, Range2D range2D, Rectangle rectangle) {
        super(component);
        this.component = component;
        this.range = range2D;
        this.viewBounds = rectangle;
        this.xAxis = new Axis(this, 1);
        this.yAxis = new Axis(this, 2);
        this.verticalGridlines = new GridLineSet(this, 2);
        this.horizonalGridlines = new GridLineSet(this, 1);
        this.verticalTicks = new TickMarkSet(this, 2, 1.0, 2.0);
        this.horizontalTicks = new TickMarkSet(this, 1, 1.0, 2.0);
        this.transform = new ModelViewTransform2D(range2D.getBounds(), rectangle);
    }

    public void setVerticalTitle(String string, Color color, Font font, int n) {
        this.setTitle(new VerticalTitle(this, string, font, color, n));
    }

    public AbstractTitle getTitle() {
        return this.title;
    }

    private void setTitle(AbstractTitle abstractTitle) {
        this.title = abstractTitle;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public TickMarkSet getVerticalTicks() {
        return this.verticalTicks;
    }

    public TickMarkSet getHorizontalTicks() {
        return this.horizontalTicks;
    }

    public ModelViewTransform2D getModelViewTransform() {
        return this.transform;
    }

    public GridLineSet getVerticalGridlines() {
        return this.verticalGridlines;
    }

    public GridLineSet getHorizonalGridlines() {
        return this.horizonalGridlines;
    }

    public void setRange(Range2D range2D) {
        this.range = range2D;
        this.transform.setModelBounds(range2D.getBounds());
        this.fireTransformChanged();
        this.autorepaint();
    }

    public void setBackground(Paint paint) {
        this.background = paint;
    }

    public Component getComponent() {
        return this.component;
    }

    public Point transform(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        return this.transform.modelToView(point2D);
    }

    public Point transform(double d, double d2) {
        return this.transform(new Point2D.Double(d, d2));
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            graphics2D.transform(this.getNetTransform());
            graphics2D.setPaint(this.background);
            graphics2D.fill(this.viewBounds);
            this.horizonalGridlines.paint(graphics2D);
            this.verticalGridlines.paint(graphics2D);
            this.horizontalTicks.paint(graphics2D);
            this.verticalTicks.paint(graphics2D);
            this.xAxis.paint(graphics2D);
            this.yAxis.paint(graphics2D);
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(this.viewBounds);
            for (int i = 0; i < this.dataSetGraphics.size(); ++i) {
                DataSetGraphic dataSetGraphic = (DataSetGraphic)this.dataSetGraphics.get(i);
                dataSetGraphic.paint(graphics2D);
            }
            graphics2D.setClip(shape);
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setColor(this.outlineColor);
            graphics2D.draw(this.viewBounds);
            if (this.title != null) {
                this.title.paint(graphics2D);
            }
            super.restoreGraphicsState();
        }
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public void setViewBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getVisibleBounds();
        this.viewBounds = rectangle;
        this.transform.setViewBounds(rectangle);
        this.fireTransformChanged();
        Rectangle rectangle3 = this.getViewBounds();
        if (rectangle2 != null) {
            this.component.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        if (rectangle3 != null) {
            this.component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    public Rectangle getVisibleBounds() {
        Rectangle rectangle = this.getViewBounds();
        Rectangle rectangle2 = this.verticalTicks.getMajorTickTextBounds();
        Rectangle rectangle3 = this.horizontalTicks.getMajorTickTextBounds();
        Rectangle rectangle4 = RectangleUtils.union(new Rectangle[]{rectangle, rectangle2, rectangle3});
        AffineTransform affineTransform = this.getNetTransform();
        Rectangle rectangle5 = affineTransform.createTransformedShape(rectangle4).getBounds();
        return rectangle5;
    }

    public void repaint() {
        Rectangle rectangle = this.getViewBounds();
        Rectangle rectangle2 = this.verticalTicks.getMajorTickTextBounds();
        Rectangle rectangle3 = this.horizontalTicks.getMajorTickTextBounds();
        Rectangle rectangle4 = RectangleUtils.union(new Rectangle[]{rectangle, rectangle2, rectangle3});
        this.component.repaint(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
    }

    protected Rectangle determineBounds() {
        return this.getVisibleBounds();
    }

    private void fireTransformChanged() {
        Object object;
        int n;
        for (n = 0; n < this.dataSetGraphics.size(); ++n) {
            object = (DataSetGraphic)this.dataSetGraphics.get(n);
            ((DataSetGraphic)object).transformChanged();
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            object = (Listener)this.listeners.get(n);
            object.transformChanged(this);
        }
    }

    public int transformY(double d) {
        return this.transform((Point2D)new Point2D.Double((double)0.0, (double)d)).y;
    }

    public int transformX(double d) {
        return this.transform((Point2D)new Point2D.Double((double)d, (double)0.0)).x;
    }

    public Range2D getRange() {
        return this.range;
    }

    public Rectangle getViewBounds() {
        return this.viewBounds;
    }

    public static abstract class AbstractTitle {
        private Chart chart;
        String title;
        Font font;
        Color color;

        public AbstractTitle(Chart chart, String string, Font font, Color color) {
            this.chart = chart;
            this.title = string;
            this.font = font;
            this.color = color;
        }

        public abstract Rectangle getBounds();

        public abstract void paint(Graphics2D var1);
    }

    public static class GridTicks
    extends AbstractTicks {
        private int dx = 0;
        private int dy = 0;

        public GridTicks(Chart chart, int n, Stroke stroke, Color color, double d) {
            super(chart, n, stroke, color, d);
        }

        public void setOffset(int n, int n2) {
            this.dx = n;
            this.dy = n2;
        }

        public int getVerticalTickX() {
            Chart chart = this.getChart();
            return chart.transformX(chart.getRange().getMinX()) + this.dx;
        }

        public int getHorizontalTickY() {
            Chart chart = this.getChart();
            return chart.transformY(chart.getRange().getMinY()) + this.dy;
        }
    }

    public static interface Listener {
        public void transformChanged(Chart var1);
    }

    public static class TickMarkSet {
        private GridTicks majorTicks;
        private GridTicks minorTicks;

        public TickMarkSet(Chart chart, int n, double d, double d2) {
            this.minorTicks = new GridTicks(chart, n, new BasicStroke(2.0f), Color.black, d);
            this.majorTicks = new GridTicks(chart, n, new BasicStroke(2.0f), Color.black, d2);
            this.minorTicks.setVisible(false);
        }

        public void paint(Graphics2D graphics2D) {
            this.minorTicks.paint(graphics2D);
            this.majorTicks.paint(graphics2D);
        }

        public void setMajorTickSpacing(double d) {
            this.majorTicks.setSpacing(d);
        }

        public void setVisible(boolean bl) {
            this.majorTicks.setVisible(bl);
            this.minorTicks.setVisible(bl);
        }

        public void setMajorGridlines(double[] dArray) {
            this.majorTicks.setGridlines(dArray);
        }

        public void setMajorOffset(int n, int n2) {
            this.majorTicks.setOffset(n, n2);
        }

        public Rectangle getMajorTickTextBounds() {
            return RectangleUtils.union(this.majorTicks.getTextBounds());
        }
    }

    public static class VerticalTitle
    extends AbstractTitle {
        private Chart chart;
        private int offsetX;
        private PhetGraphic graphic;

        public VerticalTitle(Chart chart, String string, Font font, Color color, int n) {
            super(chart, string, font, color);
            this.chart = chart;
            this.offsetX = n;
            this.graphic = string.startsWith("<html>") ? new HTMLGraphic(chart.getComponent(), font, string, color) : new PhetTextGraphic(chart.getComponent(), font, string, color, 0, 0);
        }

        public Rectangle getBounds() {
            Rectangle rectangle = this.graphic.getBounds();
            Rectangle rectangle2 = this.chart.getViewBounds();
            Rectangle rectangle3 = this.chart.getVerticalTicks().getMajorTickTextBounds();
            if (rectangle3 == null) {
                rectangle3 = this.chart.getViewBounds();
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(rectangle2.x - rectangle3.width, rectangle2.y + rectangle2.height - rectangle2.height / 2 + rectangle.getBounds().width / 2);
            affineTransform.rotate(-1.5707963267948966);
            Shape shape = affineTransform.createTransformedShape(rectangle);
            return shape.getBounds();
        }

        public void paint(Graphics2D graphics2D) {
            GraphicsState graphicsState = new GraphicsState(graphics2D);
            Rectangle rectangle = this.graphic.getBounds();
            Rectangle rectangle2 = this.chart.getViewBounds();
            Rectangle rectangle3 = this.chart.getVerticalTicks().getMajorTickTextBounds();
            if (rectangle3 == null) {
                rectangle3 = this.chart.getViewBounds();
            }
            rectangle3.width = this.offsetX;
            graphics2D.translate(rectangle2.x - rectangle3.width, rectangle2.y + rectangle2.height - rectangle2.height / 2 + rectangle.width / 2);
            graphics2D.rotate(-1.5707963267948966);
            this.graphic.paint(graphics2D);
            graphicsState.restoreGraphics();
        }
    }
}

