/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.charts;

import edu.colorado.phet.forces1d.charts.Chart;
import edu.colorado.phet.forces1d.charts.DataSet;
import edu.colorado.phet.forces1d.view.BufferedPhetGraphic;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class BufferedLinePlot
implements DataSet.Observer {
    private boolean visible = true;
    private GeneralPath generalPath;
    private Stroke stroke;
    private Paint paint;
    private BufferedPhetGraphic bufferedPhetGraphic;
    private Chart chart;
    private boolean autorepaint;

    public BufferedLinePlot(Chart chart, DataSet dataSet, Stroke stroke, Paint paint, BufferedPhetGraphic bufferedPhetGraphic) {
        this.chart = chart;
        dataSet.addObserver(this);
        this.stroke = stroke;
        this.paint = paint;
        this.bufferedPhetGraphic = bufferedPhetGraphic;
    }

    public void pointAdded(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        Point point = this.chart.transform(point2D);
        if (this.generalPath == null) {
            this.generalPath = new GeneralPath();
            this.generalPath.moveTo(point.x, point.y);
        } else {
            if (this.isVisible() && this.autorepaint) {
                Line2D.Double double_ = new Line2D.Double(this.generalPath.getCurrentPoint(), point);
                Rectangle rectangle = this.stroke.createStrokedShape(double_).getBounds();
                this.drawToBuffer(double_);
                JComponent jComponent = (JComponent)this.chart.getComponent();
                jComponent.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.generalPath.lineTo((float)point.getX(), (float)point.getY());
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    private void drawToBuffer(Line2D line2D) {
        if (this.isVisible()) {
            Graphics2D graphics2D = this.bufferedPhetGraphic.getBuffer().createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setStroke(this.stroke);
            graphics2D.setPaint(this.paint);
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(this.chart.getViewBounds());
            graphics2D.draw(line2D);
            graphics2D.setClip(shape);
        }
    }

    public void cleared() {
        if (this.generalPath != null) {
            Rectangle rectangle = this.stroke.createStrokedShape(this.generalPath).getBounds();
            this.chart.getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.generalPath = null;
    }

    public void repaintAll() {
        Graphics2D graphics2D = this.bufferedPhetGraphic.getBuffer().createGraphics();
        Shape shape = graphics2D.getClip();
        if (this.generalPath != null) {
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setStroke(this.stroke);
            graphics2D.setPaint(this.paint);
            graphics2D.setClip(this.chart.getViewBounds());
            graphics2D.draw(this.generalPath);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.setClip(shape);
        }
    }

    public void clear() {
        this.generalPath = null;
    }

    public void setAutoRepaint(boolean bl) {
        this.autorepaint = bl;
    }
}

