/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d.charts;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.forces1d.charts.AbstractGrid;
import edu.colorado.phet.forces1d.charts.Chart;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

public abstract class AbstractTicks
extends AbstractGrid {
    private int tickHeight = 6;
    private NumberFormat format = new DecimalFormat("#.#");
    private Font font = new Font(PhetFont.getDefaultFontName(), 0, 12);
    private FontMetrics fontMetrics;
    private boolean showLabels = true;

    public AbstractTicks(Chart chart, int n, Stroke stroke, Color color, double d) {
        this(chart, n, stroke, color, d, 0.0);
    }

    public AbstractTicks(Chart chart, int n, Stroke stroke, Color color, double d, double d2) {
        super(chart, n, stroke, color, d, d2);
        this.fontMetrics = chart.getComponent().getFontMetrics(this.font);
        this.setVisible(true);
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            Stroke stroke = super.getStroke();
            int n = super.getOrientation();
            Color color = super.getColor();
            double d = super.getCrossesOtherAxisAt();
            Chart chart = super.getChart();
            double d2 = super.getSpacing();
            Stroke stroke2 = graphics2D.getStroke();
            Color color2 = graphics2D.getColor();
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
            graphics2D.setFont(this.font);
            if (n == 1) {
                double[] dArray = this.getGridLines(d, chart.getRange().getMinX(), chart.getRange().getMaxX(), d2);
                for (int i = 0; i < dArray.length; ++i) {
                    double d3 = dArray[i];
                    int n2 = chart.transformX(d3);
                    int n3 = this.getHorizontalTickY();
                    graphics2D.drawLine(n2, n3 - this.tickHeight / 2, n2, n3 + this.tickHeight / 2);
                    if (!this.isShowLabels()) continue;
                    String string = this.format.format(d3);
                    int n4 = this.fontMetrics.stringWidth(string);
                    int n5 = this.fontMetrics.getHeight();
                    graphics2D.drawString(string, n2 - n4 / 2, n3 + this.tickHeight / 2 + n5);
                }
            } else if (n == 2) {
                double[] dArray = this.getGridLines(d, chart.getRange().getMinY(), chart.getRange().getMaxY(), d2);
                for (int i = 0; i < dArray.length; ++i) {
                    double d4 = dArray[i];
                    int n6 = this.getVerticalTickX();
                    int n7 = chart.transformY(d4);
                    graphics2D.drawLine(n6 - this.tickHeight / 2, n7, n6 + this.tickHeight / 2, n7);
                    if (!this.isShowLabels()) continue;
                    String string = this.format.format(d4);
                    int n8 = this.fontMetrics.stringWidth(string);
                    int n9 = this.fontMetrics.getHeight();
                    graphics2D.drawString(string, n6 - this.tickHeight / 2 - n8, n7 + n9 / 2);
                }
            }
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(color2);
        }
    }

    public Rectangle[] getTextBounds() {
        ArrayList<Rectangle> arrayList;
        block3: {
            double d;
            Chart chart;
            double d2;
            int n;
            block2: {
                arrayList = new ArrayList<Rectangle>();
                Object var2_2 = null;
                n = super.getOrientation();
                d2 = super.getCrossesOtherAxisAt();
                chart = super.getChart();
                d = super.getSpacing();
                if (n != 1) break block2;
                double[] dArray = this.getGridLines(d2, chart.getRange().getMinX(), chart.getRange().getMaxX(), d);
                for (int i = 0; i < dArray.length; ++i) {
                    double d3 = dArray[i];
                    int n2 = chart.transformX(d3);
                    int n3 = this.getHorizontalTickY();
                    if (!this.isShowLabels()) continue;
                    String string = this.format.format(d3);
                    int n4 = this.fontMetrics.stringWidth(string);
                    int n5 = this.fontMetrics.getHeight();
                    int n6 = n2 - n4 / 2;
                    int n7 = n3 + this.tickHeight / 2 + n5;
                    Rectangle rectangle = new Rectangle(n6, n7, n4, n5);
                    arrayList.add(rectangle);
                }
                break block3;
            }
            if (n != 2) break block3;
            double[] dArray = this.getGridLines(d2, chart.getRange().getMinY(), chart.getRange().getMaxY(), d);
            for (int i = 0; i < dArray.length; ++i) {
                double d4 = dArray[i];
                int n8 = this.getVerticalTickX();
                int n9 = chart.transformY(d4);
                if (!this.isShowLabels()) continue;
                String string = this.format.format(d4);
                int n10 = this.fontMetrics.stringWidth(string);
                int n11 = this.fontMetrics.getHeight();
                int n12 = n8 - this.tickHeight / 2 - n10;
                int n13 = n9 - n11 / 2;
                Rectangle rectangle = new Rectangle(n12, n13, n10, n11);
                arrayList.add(rectangle);
            }
        }
        return arrayList.toArray(new Rectangle[0]);
    }

    public abstract int getVerticalTickX();

    public abstract int getHorizontalTickY();
}

