/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Force1DUtil;
import edu.colorado.phet.forces1d.Forces1DApplication;
import edu.colorado.phet.forces1d.Forces1DControlPanel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;

public class ObjectSelectionPanel
extends VerticalLayoutPanel {
    private Color SELECTION_COLOR = Color.yellow;

    public ObjectSelectionPanel(Force1dObject[] force1dObjectArray, final Forces1DControlPanel forces1DControlPanel) {
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton[] jRadioButtonArray = new JRadioButton[force1dObjectArray.length];
        int n = 0;
        while (n < force1dObjectArray.length) {
            JRadioButton jRadioButton;
            final Force1dObject force1dObject = force1dObjectArray[n];
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage(force1dObjectArray[n].getLocation());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            bufferedImage = BufferedImageUtils.multiScaleToHeight(bufferedImage, 35);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            jRadioButtonArray[n] = jRadioButton = new JRadioButton(force1dObject.getName() + " (" + force1dObject.getMass() + " kg)", imageIcon);
            if (n == 0) {
                jRadioButton.setSelected(true);
                jRadioButton.setBackground(this.SELECTION_COLOR);
            } else {
                jRadioButton.setBackground(Forces1DApplication.FORCES_1D_BACKGROUND_COLOR);
            }
            buttonGroup.add(jRadioButton);
            final int n2 = n++;
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    forces1DControlPanel.setup(force1dObject);
                    for (int i = 0; i < jRadioButtonArray.length; ++i) {
                        JRadioButton jRadioButton = jRadioButtonArray[i];
                        if (i == n2) {
                            jRadioButton.setBackground(ObjectSelectionPanel.this.SELECTION_COLOR);
                            continue;
                        }
                        jRadioButton.setBackground(Forces1DApplication.FORCES_1D_BACKGROUND_COLOR);
                    }
                }
            });
            this.add(jRadioButton);
        }
        this.setBorder(Force1DUtil.createSmoothBorder(Force1DResources.get("ObjectSelectionPanel.chooseObject")));
    }
}

