/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.forces1d.CrashAudioPlayer;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Forces1DControlPanel;
import edu.colorado.phet.forces1d.IForceControl;
import edu.colorado.phet.forces1d.common.ColorDialog;
import edu.colorado.phet.forces1d.common.plotdevice.DefaultPlaybackPanel;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import edu.colorado.phet.forces1d.view.Force1DLookAndFeel;
import edu.colorado.phet.forces1d.view.Force1DPanel;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Forces1DModule
extends PhetGraphicsModule {
    private Color backgroundColor;
    private Force1DModel forceModel;
    private Force1DPanel forcePanel;
    private Forces1DControlPanel simpleControlPanel;
    private Force1dObject[] force1dObjects;
    private DefaultPlaybackPanel playbackPanel;
    private PhetFrame phetFrame;
    private Force1DLookAndFeel force1DLookAndFeel = new Force1DLookAndFeel();
    private int objectIndex;
    private IForceControl currentControlPanel;

    public Forces1DModule(IClock iClock, Color color) throws IOException {
        this(iClock, Force1DResources.get("Force1DModule.moduleName"), color);
    }

    public Forces1DModule(IClock iClock, String string, Color color) throws IOException {
        super(string, iClock);
        this.backgroundColor = color;
        this.forceModel = new Force1DModel(this);
        this.setModel(new BaseModel());
        this.force1dObjects = new Force1dObject[]{new Force1dObject("forces-1d/images/cabinet.gif", Force1DResources.get("Force1DModule.fileCabinet"), 0.8, 200.0, 0.3, 0.2), new Force1dObject("forces-1d/images/fridge.gif", Force1DResources.get("Force1DModule.refrigerator"), 0.35, 400.0, 0.7, 0.5), new Force1dObject("forces-1d/images/phetbook.gif", Force1DResources.get("Force1DModule.textbook"), 0.8, 10.0, 0.3, 0.25), new Force1dObject("forces-1d/images/crate.gif", Force1DResources.get("Force1DModule.crate"), 0.8, 300.0, 0.2, 0.2), new Force1dObject("forces-1d/images/ollie.gif", Force1DResources.get("Force1DModule.sleepyDog"), 0.5, 25.0, 0.1, 0.1)};
        this.forcePanel = new Force1DPanel(this);
        this.setApparatusPanel(this.forcePanel);
        this.restoreDefaults();
        this.simpleControlPanel = new Forces1DControlPanel(this);
        this.setControlPanel(this.simpleControlPanel);
        this.addModelElement(this.forceModel);
        this.playbackPanel = new DefaultPlaybackPanel(this.getForceModel().getPlotDeviceModel());
        this.getForceModel().setBoundsOpen();
        CrashAudioPlayer crashAudioPlayer = new CrashAudioPlayer();
        this.getForceModel().addCollisionListener(crashAudioPlayer);
    }

    public void updateGraphics(ClockEvent clockEvent) {
        super.updateGraphics(clockEvent);
        this.forcePanel.updateGraphics();
        this.simpleControlPanel.updateGraphics();
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this.forcePanel.setHelpEnabled(bl);
    }

    public Force1DModel getForceModel() {
        return this.forceModel;
    }

    public Force1DPanel getForcePanel() {
        return this.forcePanel;
    }

    public void reset() {
        this.forceModel.reset();
        this.forcePanel.reset();
        this.simpleControlPanel.reset();
    }

    public void cursorMovedToTime(double d, int n) {
        this.forcePanel.cursorMovedToTime(d, n);
    }

    public void relayoutPlots() {
        if (this.forcePanel != null) {
            this.forcePanel.layoutPlots();
        }
    }

    void setPhetFrame(PhetFrame phetFrame) {
        this.phetFrame = phetFrame;
    }

    void showColorDialog() {
        String string = Force1DResources.get("Force1DModule.chartcolor");
        ColorDialog.showDialog(string, this.getApparatusPanel(), Color.yellow, new ColorDialog.Listener(){

            public void colorChanged(Color color) {
                Forces1DModule.this.setChartBackground(color);
            }

            public void cancelled(Color color) {
                Forces1DModule.this.setChartBackground(color);
            }

            public void ok(Color color) {
                Forces1DModule.this.setChartBackground(color);
            }
        });
    }

    public void activate() {
        super.activate();
        this.setClockControlPanel(this.playbackPanel);
    }

    private void setChartBackground(Color color) {
        this.forcePanel.setChartBackground(color);
    }

    public static void setup(Forces1DModule forces1DModule) {
        Force1DPanel force1DPanel = forces1DModule.getForcePanel();
        force1DPanel.setReferenceSize();
        force1DPanel.updateLayout(force1DPanel.getWidth(), force1DPanel.getHeight());
        forces1DModule.getApparatusPanel().getGraphic().setVisible(true);
        force1DPanel.paintImmediately(0, 0, force1DPanel.getWidth(), force1DPanel.getHeight());
    }

    public Force1dObject getObject(int n) {
        return this.force1dObjects[n];
    }

    public Force1dObject[] getForce1dObjects() {
        return this.force1dObjects;
    }

    public PhetFrame getPhetFrame() {
        return this.phetFrame;
    }

    public Force1DLookAndFeel getForce1DLookAndFeel() {
        return this.force1DLookAndFeel;
    }

    public void setObject(Force1dObject force1dObject) {
        this.objectIndex = Arrays.asList(this.force1dObjects).indexOf(force1dObject);
        try {
            this.getForcePanel().getBlockGraphic().setImage(force1dObject.getImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.forceModel.getBlock().setMass(force1dObject.getMass());
        this.forceModel.getBlock().setStaticAndKineticFriction(force1dObject.getStaticFriction(), force1dObject.getKineticFriction());
    }

    public void clearData() {
        this.getForcePanel().clearData();
    }

    public void setFrictionEnabled(boolean bl) {
        this.getForceModel().setFrictionEnabled(bl);
    }

    public boolean isFrictionEnabled() {
        return this.getForceModel().isFrictionEnabled();
    }

    public void setImageIndex(int n) {
        try {
            this.getForcePanel().getBlockGraphic().setImage(this.force1dObjects[n].getImage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getImageIndex() {
        return this.objectIndex;
    }

    public void restoreDefaults() {
        this.setObject(this.force1dObjects[this.objectIndex]);
        this.getForceModel().setGravity(9.8);
    }

    public void setControlPanel(IForceControl iForceControl) {
        this.currentControlPanel = iForceControl;
        super.setControlPanel(iForceControl);
        Window window = SwingUtilities.getWindowAncestor(iForceControl);
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.invalidate();
            jFrame.doLayout();
        }
        this.simpleControlPanel.getFreeBodyDiagramSuite().controlsChanged();
    }

    public Paint getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isShowComponentForces() {
        return this.forcePanel.isShowComponentForces();
    }

    public void setShowComponentForces(boolean bl) {
        this.forcePanel.setShowComponentForces(bl);
    }

    public boolean isShowTotalForce() {
        return this.forcePanel.isShowTotalForce();
    }

    public void setShowTotalForce(boolean bl) {
        this.forcePanel.setShowTotalForce(bl);
    }
}

