/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.forces1d.BarrierCheckBox;
import edu.colorado.phet.forces1d.FBDButton;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Forces1DModule;
import edu.colorado.phet.forces1d.FrictionControl;
import edu.colorado.phet.forces1d.IForceControl;
import edu.colorado.phet.forces1d.ObjectSelectionPanel;
import edu.colorado.phet.forces1d.ShowComponentForcesCheckBox;
import edu.colorado.phet.forces1d.ShowTotalForceCheckBox;
import edu.colorado.phet.forces1d.common.plotdevice.PlotDeviceModel;
import edu.colorado.phet.forces1d.model.Block;
import edu.colorado.phet.forces1d.model.Force1DModel;
import edu.colorado.phet.forces1d.model.Force1dObject;
import edu.colorado.phet.forces1d.view.FreeBodyDiagramSuite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Forces1DControlPanel
extends IForceControl {
    private FreeBodyDiagramSuite fbdSuite;
    private BarrierCheckBox barriers;
    private Forces1DModule module;
    private LinearValueControl mass;
    private LinearValueControl gravity;
    private LinearValueControl staticFriction;
    private LinearValueControl kineticFriction;
    private Force1DModel model;
    private FrictionControl frictionControl;
    static final Stroke stroke = new BasicStroke(1.0f);
    private LinearValueControl setPositionControl;

    public Forces1DControlPanel(final Forces1DModule forces1DModule) {
        super(forces1DModule);
        this.module = forces1DModule;
        this.model = forces1DModule.getForceModel();
        this.frictionControl = new FrictionControl(forces1DModule);
        this.fbdSuite = new FreeBodyDiagramSuite(forces1DModule);
        this.fbdSuite.setControlPanel(this);
        this.fbdSuite.setPanelVisible(true);
        this.addControl(new FBDButton(this.fbdSuite));
        this.addControl(this.fbdSuite.getFreeBodyDiagramPanel());
        this.addFullWidth(new ShowComponentForcesCheckBox(forces1DModule));
        this.addFullWidth(new ShowTotalForceCheckBox(forces1DModule));
        this.addControl(this.frictionControl);
        this.barriers = new BarrierCheckBox(forces1DModule);
        this.addFullWidth(this.barriers);
        super.setHelpPanelEnabled(true);
        forces1DModule.getForceModel().getPlotDeviceModel().addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingStarted() {
                Forces1DControlPanel.this.setChangesEnabled(true);
                Forces1DControlPanel.this.setPositionControl.setEnabled(false);
            }

            public void playbackStarted() {
                Forces1DControlPanel.this.setChangesEnabled(false);
            }

            public void playbackPaused() {
                Forces1DControlPanel.this.setChangesEnabled(true);
            }
        });
        ObjectSelectionPanel objectSelectionPanel = new ObjectSelectionPanel(forces1DModule.getForce1dObjects(), this);
        this.addControl(objectSelectionPanel);
        this.setPositionControl = this.createControl(this.model.getBlock().getPosition(), -10.0, 10.0, Force1DResources.get("Force1dControlPanel.initial-position"), Force1DResources.get("Force1DPanel.positionUnits"), new SpinnerHandler(){

            public void changed(double d, boolean bl) {
                Forces1DControlPanel.this.model.getBlock().setPosition(d);
            }
        });
        this.addControl(this.setPositionControl);
        AdvancedPanel advancedPanel = new AdvancedPanel(Force1DResources.get("SimpleControlPanel.moreControls"), Force1DResources.get("Force1dControlPanel.lessControls"));
        this.addControl(advancedPanel);
        JButton jButton = new JButton(Force1DResources.get("Force1dControlPanel.restoreDefaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                forces1DModule.restoreDefaults();
            }
        });
        this.mass = this.createControl(this.model.getBlock().getMass(), 0.1, 1000.0, Force1DResources.get("Force1dControlPanel.mass"), Force1DResources.get("Force1dControlPanel.kg"), new SpinnerHandler(){

            public void changed(double d, boolean bl) {
                Forces1DControlPanel.this.model.getBlock().setMass(d);
            }
        });
        this.mass.setMajorTickSpacing((this.mass.getMaximum() - this.mass.getMinimum()) / 2.0);
        this.mass.getTextField().setColumns(5);
        this.gravity = this.createControl(this.model.getGravity(), 0.0, 30.0, Force1DResources.get("Force1dControlPanel.gravity"), Force1DResources.get("Force1dControlPanel.gravityUnits"), new SpinnerHandler(){

            public void changed(double d, boolean bl) {
                Forces1DControlPanel.this.model.setGravity(d);
            }
        });
        this.model.addListener(new Force1DModel.Listener(){

            public void appliedForceChanged() {
            }

            public void gravityChanged() {
                Forces1DControlPanel.this.gravity.setValue(Forces1DControlPanel.this.model.getGravity());
            }
        });
        this.staticFriction = this.createControl(this.model.getBlock().getStaticFriction(), 0.0, 2.0, Force1DResources.get("Force1dControlPanel.staticFriction"), "", new SpinnerHandler(){

            public void changed(double d, boolean bl) {
                if (Forces1DControlPanel.this.staticFriction == null || Forces1DControlPanel.this.staticFriction.getSlider().hasFocus() || Forces1DControlPanel.this.staticFriction.getTextField().hasFocus() || bl) {
                    Forces1DControlPanel.this.model.getBlock().userSetStaticFriction(d);
                }
            }
        });
        this.staticFriction.getSlider().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (Forces1DControlPanel.this.staticFriction.getSlider().getValue() <= Forces1DControlPanel.this.kineticFriction.getSlider().getValue()) {
                    Forces1DControlPanel.this.model.getBlock().userSetStaticFriction(Forces1DControlPanel.this.model.getBlock().getKineticFriction());
                }
            }
        });
        this.kineticFriction = this.createControl(this.model.getBlock().getKineticFriction(), 0.0, 2.0, Force1DResources.get("Force1dControlPanel.kineticFriction"), "", new SpinnerHandler(){

            public void changed(double d, boolean bl) {
                if (bl || Forces1DControlPanel.this.kineticFriction == null || Forces1DControlPanel.this.kineticFriction.getSlider().hasFocus() || Forces1DControlPanel.this.kineticFriction.getTextField().hasFocus()) {
                    Forces1DControlPanel.this.model.getBlock().userSetKineticFriction(d);
                }
            }
        });
        this.model.getBlock().addListener(new Block.Listener(){

            public void positionChanged() {
            }

            public void propertyChanged() {
                double d = Forces1DControlPanel.this.model.getBlock().getStaticFriction();
                double d2 = Forces1DControlPanel.this.model.getBlock().getKineticFriction();
                Forces1DControlPanel.this.staticFriction.setValue(d);
                Forces1DControlPanel.this.kineticFriction.setValue(d2);
            }
        });
        this.model.getBlock().addListener(new Block.Listener(){

            public void positionChanged() {
            }

            public void propertyChanged() {
                double d = Forces1DControlPanel.this.model.getBlock().getStaticFriction();
                double d2 = Forces1DControlPanel.this.model.getBlock().getKineticFriction();
                Forces1DControlPanel.this.staticFriction.setValue(d);
                Forces1DControlPanel.this.kineticFriction.setValue(d2);
                Forces1DControlPanel.this.mass.setValue(Forces1DControlPanel.this.model.getBlock().getMass());
            }
        });
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(1.67), Forces1DControlPanel.toJLabel(Force1DResources.get("Force1dControlPanel.moon")));
        hashtable.put(new Double(9.8), Forces1DControlPanel.toJLabel(Force1DResources.get("Force1dControlPanel.earth")));
        hashtable.put(new Double(22.9), Forces1DControlPanel.toJLabel(Force1DResources.get("Force1dControlPanel.jupiter")));
        this.gravity.setTickLabels(hashtable);
        forces1DModule.getForceModel().getPlotDeviceModel().addListener(new PlotDeviceModel.ListenerAdapter(){

            public void recordingStarted() {
                Forces1DControlPanel.this.enableChanges();
            }

            public void playbackStarted() {
                Forces1DControlPanel.this.disableChanges();
            }

            public void playbackPaused() {
                Forces1DControlPanel.this.enableChanges();
            }
        });
        advancedPanel.addControl(this.gravity);
        advancedPanel.addControl(this.mass);
        advancedPanel.addControl(this.staticFriction);
        advancedPanel.addControl(this.kineticFriction);
        advancedPanel.addControl(jButton);
    }

    private void disableChanges() {
        this.setChangesEnabled(false);
    }

    private void enableChanges() {
        this.setChangesEnabled(true);
    }

    private void setChangesEnabled(boolean bl) {
        this.barriers.setEnabled(bl);
        this.mass.setEnabled(bl);
        this.gravity.setEnabled(bl);
        this.staticFriction.setEnabled(bl);
        this.kineticFriction.setEnabled(bl);
        this.barriers.setEnabled(bl);
        this.frictionControl.setEnabled(bl);
    }

    public static JLabel toJLabel(String string) {
        JLabel jLabel = new JLabel(string){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                GraphicsState graphicsState = new GraphicsState(graphics2D);
                graphics.setColor(Color.blue);
                int n = this.getWidth() / 2;
                graphics2D.setStroke(stroke);
                graphics.drawLine(n, 0, n, 2);
                graphicsState.restoreGraphics();
                super.paintComponent(graphics);
            }
        };
        jLabel.setFont(new Font(PhetFont.getDefaultFontName(), 0, 10));
        Dimension dimension = jLabel.getPreferredSize();
        jLabel.setPreferredSize(new Dimension(dimension.width, dimension.height + 5));
        return jLabel;
    }

    private LinearValueControl createControl(double d, double d2, double d3, String string, String string2, final SpinnerHandler spinnerHandler) {
        final LinearValueControl linearValueControl = new LinearValueControl(d2, d3, string, "0.0", string2);
        linearValueControl.getTextField().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                spinnerHandler.changed(linearValueControl.getValue(), true);
            }
        });
        linearValueControl.setValue(d);
        linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                spinnerHandler.changed(linearValueControl.getValue(), false);
            }
        });
        spinnerHandler.changed(linearValueControl.getValue(), false);
        linearValueControl.setMinorTicksVisible(false);
        linearValueControl.setMajorTickSpacing((d3 - d2) / 5.0);
        linearValueControl.setBorder(BorderFactory.createEtchedBorder());
        return linearValueControl;
    }

    public void updateGraphics() {
        this.fbdSuite.updateGraphics();
    }

    public void reset() {
        this.fbdSuite.reset();
        this.setPositionControl.setEnabled(true);
        this.setPositionControl.setValue(this.model.getBlock().getPosition());
    }

    public void setup(Force1dObject force1dObject) {
        this.module.setObject(force1dObject);
    }

    public FreeBodyDiagramSuite getFreeBodyDiagramSuite() {
        return this.fbdSuite;
    }

    static interface SpinnerHandler {
        public void changed(double var1, boolean var3);
    }
}

