/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forces1d;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.forces1d.Force1DResources;
import edu.colorado.phet.forces1d.Forces1DModule;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class Forces1DApplication
extends PhetApplication {
    public static Color FORCES_1D_BACKGROUND_COLOR = new Color(200, 240, 200);

    public Forces1DApplication(Forces1DPhetApplicationConfig forces1DPhetApplicationConfig) {
        super(forces1DPhetApplicationConfig);
        ConstantDtClock constantDtClock = new ConstantDtClock(30, 1.0);
        try {
            final Forces1DModule forces1DModule = new Forces1DModule(constantDtClock, FORCES_1D_BACKGROUND_COLOR);
            forces1DModule.setLogoPanelVisible(false);
            Module[] moduleArray = new Module[]{forces1DModule};
            this.setModules(moduleArray);
            JMenu jMenu = new JMenu(Force1DResources.get("Force1DModule.options"));
            JMenuItem jMenuItem = new JMenuItem(Force1DResources.get("Force1DModule.backgroundColor"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    forces1DModule.showColorDialog();
                }
            });
            jMenu.add(jMenuItem);
            this.getPhetFrame().addMenu(jMenu);
            forces1DModule.setPhetFrame(this.getPhetFrame());
            Forces1DModule.setup(forces1DModule);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        new PhetApplicationLauncher().launchSim((PhetApplicationConfig)new Forces1DPhetApplicationConfig(stringArray), Forces1DApplication.class);
    }

    private static class Forces1DPhetApplicationConfig
    extends PhetApplicationConfig {
        public Forces1DPhetApplicationConfig(String[] stringArray) {
            super(stringArray, "forces-1d");
            PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
            phetLookAndFeel.setBackgroundColor(FORCES_1D_BACKGROUND_COLOR);
            this.setLookAndFeel(phetLookAndFeel);
        }
    }
}

