/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetgraphics;

import edu.colorado.phet.common.phetcommon.util.MultiMap;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.MouseInputListener;

public class GraphicLayerSet
extends PhetGraphic {
    private MultiMap graphicMap = new MultiMap();
    private PhetGraphic activeUnit;
    private PhetGraphic keyFocusUnit;
    private SwingAdapter swingAdapter = new SwingAdapter();
    private KeyListener keyAdapter = new KeyAdapter();
    private static int mouseEventID = 0;

    public GraphicLayerSet() {
        super(null);
    }

    public GraphicLayerSet(Component component) {
        super(component);
    }

    public void setComponent(Component component) {
        super.setComponent(component);
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof PhetGraphic)) continue;
            PhetGraphic phetGraphic = (PhetGraphic)e;
            phetGraphic.setComponent(component);
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            Iterator iterator = this.graphicMap.iterator();
            while (iterator.hasNext()) {
                PhetGraphic phetGraphic = (PhetGraphic)iterator.next();
                if (phetGraphic != null) {
                    phetGraphic.paint(graphics2D);
                    continue;
                }
                System.out.println("GraphicLayerSet.paint: graphic == null");
            }
            super.restoreGraphicsState();
        }
    }

    public SwingAdapter getMouseHandler() {
        return this.swingAdapter;
    }

    public boolean contains(int n, int n2) {
        if (this.isVisible()) {
            Iterator iterator = this.graphicMap.iterator();
            while (iterator.hasNext()) {
                PhetGraphic phetGraphic = (PhetGraphic)iterator.next();
                if (!phetGraphic.contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    protected Rectangle determineBounds() {
        PhetGraphic[] phetGraphicArray = this.getGraphics();
        Rectangle[] rectangleArray = new Rectangle[phetGraphicArray.length];
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangleArray[i] = phetGraphicArray[i].getBounds();
        }
        Rectangle rectangle = RectangleUtils.union(rectangleArray);
        return rectangle;
    }

    public void removeGraphic(PhetGraphic phetGraphic) {
        if (this.containsGraphic(phetGraphic)) {
            this.graphicMap.removeValue(phetGraphic);
            phetGraphic.setParent(null);
            this.setBoundsDirty();
            phetGraphic.autorepaint();
        }
    }

    public void setBoundsDirty() {
        super.setBoundsDirty();
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            PhetGraphic phetGraphic = (PhetGraphic)iterator.next();
            phetGraphic.setBoundsDirty();
        }
    }

    protected void forceRepaint() {
        this.syncBounds();
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            PhetGraphic phetGraphic = (PhetGraphic)iterator.next();
            phetGraphic.forceRepaint();
        }
    }

    public void addGraphic(PhetGraphic phetGraphic) {
        this.addGraphic(phetGraphic, 0.0);
        phetGraphic.setParent(this);
    }

    public PhetGraphic[] getGraphics() {
        Iterator iterator = this.graphicMap.iterator();
        ArrayList<PhetGraphic> arrayList = new ArrayList<PhetGraphic>();
        while (iterator.hasNext()) {
            PhetGraphic phetGraphic = (PhetGraphic)iterator.next();
            arrayList.add(phetGraphic);
        }
        return arrayList.toArray(new PhetGraphic[0]);
    }

    public void addGraphic(PhetGraphic phetGraphic, double d) {
        this.graphicMap.put(new Double(d), phetGraphic);
        phetGraphic.setParent(this);
        super.setBoundsDirty();
        phetGraphic.setBoundsDirty();
        phetGraphic.autorepaint();
    }

    public int getNumGraphics() {
        return this.graphicMap.size();
    }

    protected void handleEntranceAndExit(MouseEvent mouseEvent) {
        PhetGraphic phetGraphic = this.getHandler(mouseEvent.getPoint());
        if (phetGraphic == null) {
            if (this.activeUnit != null) {
                this.activeUnit.fireMouseExited(mouseEvent);
                this.activeUnit = null;
            }
        } else if (this.activeUnit != phetGraphic) {
            if (this.activeUnit == null) {
                this.activeUnit = phetGraphic;
                this.activeUnit.fireMouseEntered(mouseEvent);
            } else if (this.activeUnit != phetGraphic) {
                this.activeUnit.fireMouseExited(mouseEvent);
                this.activeUnit = phetGraphic;
                this.activeUnit.fireMouseEntered(mouseEvent);
            }
        }
    }

    protected PhetGraphic getHandler(Point point) {
        if (this.getIgnoreMouse()) {
            return null;
        }
        PhetGraphic[] phetGraphicArray = this.getGraphics();
        PhetGraphic phetGraphic = null;
        for (int i = phetGraphicArray.length - 1; phetGraphic == null && i >= 0; --i) {
            PhetGraphic phetGraphic2 = phetGraphicArray[i];
            if (phetGraphic2 == null || !phetGraphic2.isVisible() || phetGraphic2.getIgnoreMouse()) continue;
            if (phetGraphic2 instanceof GraphicLayerSet) {
                phetGraphic = ((GraphicLayerSet)phetGraphic2).getHandler(point);
                continue;
            }
            if (!phetGraphic2.contains(point.x, point.y)) continue;
            phetGraphic = phetGraphic2;
        }
        if (phetGraphic != null && phetGraphic.numMouseInputListeners() == 0 && this.isVisible() && this.numMouseInputListeners() != 0 && this.contains(point)) {
            phetGraphic = this;
        }
        return phetGraphic;
    }

    public KeyListener getKeyAdapter() {
        return this.keyAdapter;
    }

    public void setKeyFocus(PhetGraphic phetGraphic) {
        if (this.keyFocusUnit != phetGraphic) {
            if (this.keyFocusUnit != null) {
                this.keyFocusUnit.lostKeyFocus();
            }
            this.keyFocusUnit = phetGraphic;
            if (this.keyFocusUnit != null) {
                this.keyFocusUnit.gainedKeyFocus();
            }
        }
    }

    public void childBecameInvisible(PhetGraphic phetGraphic) {
        if (this.keyFocusUnit == phetGraphic) {
            this.setKeyFocus(null);
        }
        if (this.activeUnit == phetGraphic) {
            MouseEvent mouseEvent = new MouseEvent(this.getComponent(), mouseEventID++, System.currentTimeMillis(), 0, 0, 0, 0, false);
            this.activeUnit.fireMouseExitedBecauseInvisible(mouseEvent);
            this.activeUnit = null;
        }
    }

    public MultiMap getGraphicMap() {
        return this.graphicMap;
    }

    public boolean containsGraphic(PhetGraphic phetGraphic) {
        return this.graphicMap.containsValue(phetGraphic);
    }

    public Rectangle getVisibleBounds() {
        PhetGraphic[] phetGraphicArray = this.getGraphics();
        Rectangle[] rectangleArray = new Rectangle[phetGraphicArray.length];
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangleArray[i] = phetGraphicArray[i].getVisibleBounds();
        }
        Rectangle rectangle = RectangleUtils.union(rectangleArray);
        return rectangle;
    }

    protected void fireVisibilityChanged() {
        super.fireVisibilityChanged();
        Iterator iterator = this.graphicMap.iterator();
        while (iterator.hasNext()) {
            PhetGraphic phetGraphic = (PhetGraphic)iterator.next();
            phetGraphic.fireVisibilityChanged();
        }
    }

    public class KeyAdapter
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            if (GraphicLayerSet.this.keyFocusUnit != null) {
                GraphicLayerSet.this.keyFocusUnit.fireKeyTyped(keyEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (GraphicLayerSet.this.keyFocusUnit != null) {
                GraphicLayerSet.this.keyFocusUnit.fireKeyPressed(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (GraphicLayerSet.this.keyFocusUnit != null) {
                GraphicLayerSet.this.keyFocusUnit.fireKeyReleased(keyEvent);
            }
        }
    }

    public class SwingAdapter
    implements MouseInputListener {
        private boolean pressed = false;

        public void mouseClicked(MouseEvent mouseEvent) {
            GraphicLayerSet.this.handleEntranceAndExit(mouseEvent);
            if (GraphicLayerSet.this.activeUnit != null) {
                GraphicLayerSet.this.activeUnit.fireMouseClicked(mouseEvent);
            }
            GraphicLayerSet.this.setKeyFocus(GraphicLayerSet.this.activeUnit);
            this.pressed = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GraphicLayerSet.this.handleEntranceAndExit(mouseEvent);
            if (GraphicLayerSet.this.activeUnit != null) {
                GraphicLayerSet.this.activeUnit.fireMousePressed(mouseEvent);
            }
            GraphicLayerSet.this.setKeyFocus(GraphicLayerSet.this.activeUnit);
            this.pressed = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (GraphicLayerSet.this.activeUnit != null) {
                GraphicLayerSet.this.activeUnit.fireMouseReleased(mouseEvent);
                GraphicLayerSet.this.handleEntranceAndExit(mouseEvent);
            }
            this.pressed = false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.pressed && GraphicLayerSet.this.activeUnit == null) {
                GraphicLayerSet.this.handleEntranceAndExit(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.pressed && GraphicLayerSet.this.activeUnit != null) {
                GraphicLayerSet.this.activeUnit.fireMouseExited(mouseEvent);
                GraphicLayerSet.this.activeUnit = null;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (GraphicLayerSet.this.activeUnit != null) {
                GraphicLayerSet.this.activeUnit.fireMouseDragged(mouseEvent);
            }
            this.pressed = true;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            GraphicLayerSet.this.handleEntranceAndExit(mouseEvent);
            if (GraphicLayerSet.this.activeUnit != null) {
                GraphicLayerSet.this.activeUnit.fireMouseMoved(mouseEvent);
            }
            this.pressed = false;
        }
    }
}

