/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.application;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetgraphics.application.ClockPausedHandler;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.help.HelpManager;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import javax.swing.JComponent;

public class PhetGraphicsModule
extends Module {
    private ApparatusPanel apparatusPanel;
    private HelpManager helpManager = new HelpManager();

    protected PhetGraphicsModule(String string, IClock iClock) {
        super(string, iClock);
        this.updateHelpPanelVisible();
        iClock.addClockListener(new ClockPausedHandler(this));
    }

    public void setApparatusPanel(ApparatusPanel apparatusPanel) {
        this.apparatusPanel = apparatusPanel;
        if (this.helpManager != null) {
            this.helpManager.setComponent(apparatusPanel);
        } else {
            this.helpManager = new HelpManager(apparatusPanel);
        }
        super.setSimulationPanel(apparatusPanel);
    }

    public ApparatusPanel getApparatusPanel() {
        return this.apparatusPanel;
    }

    public HelpManager getHelpManager() {
        return this.helpManager;
    }

    public void updateGraphics(ClockEvent clockEvent) {
        super.updateGraphics(clockEvent);
        PhetJComponent.getRepaintManager().updateGraphics();
    }

    public boolean hasHelp() {
        return this.helpManager != null && this.helpManager.getNumGraphics() > 0;
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this.helpManager.setHelpEnabled(this.apparatusPanel, bl);
    }

    public void refresh() {
        PhetJComponent.getRepaintManager().updateGraphics();
        this.apparatusPanel.paint();
    }

    protected void handleUserInput() {
        super.handleUserInput();
        this.getApparatusPanel().handleUserInput();
    }

    public void setReferenceSize() {
        JComponent jComponent = this.getSimulationPanel();
        if (jComponent instanceof ApparatusPanel2) {
            ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)jComponent;
            apparatusPanel2.setReferenceSize();
        }
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        return new PiccoloClockControlPanel(iClock);
    }
}

