/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import java.awt.geom.Point2D;

public class Vector2D
extends AbstractVector2D {
    public final double x;
    public final double y;
    public static final Vector2D ZERO = new Vector2D();
    public static final Vector2D X_UNIT = new Vector2D(1.0, 0.0);
    public static final Vector2D Y_UNIT = new Vector2D(0.0, 1.0);

    public Vector2D() {
        this(0.0, 0.0);
    }

    public Vector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2D(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public Vector2D(Point2D point2D, Point2D point2D2) {
        this(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector2D)) {
            return false;
        }
        Vector2D vector2D = (Vector2D)object;
        if (!vector2D.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), vector2D.getX()) != 0) {
            return false;
        }
        return Double.compare(this.getY(), vector2D.getY()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof Vector2D;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getX());
        long l2 = Double.doubleToLongBits(this.getY());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        return n;
    }

    public String toString() {
        return "Vector2D(x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

