/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

public interface Function {

    public static class LinearFunction
    implements Function {
        private double minInput;
        private double maxInput;
        private double minOutput;
        private double maxOutput;
        private double t1;
        private double scale;
        private double t2;

        public LinearFunction(double d, double d2, double d3, double d4) {
            this.minInput = d;
            this.maxInput = d2;
            this.minOutput = d3;
            this.maxOutput = d4;
            this.update();
        }

        protected void update() {
            this.t1 = -this.minInput;
            this.scale = (this.maxOutput - this.minOutput) / (this.maxInput - this.minInput);
            this.t2 = this.minOutput;
        }

        public double evaluate(double d) {
            double d2 = this.t1 + d;
            d2 = this.scale * d2;
            d2 = this.t2 + d2;
            return d2;
        }

        public void setOutput(double d, double d2) {
            this.minOutput = d;
            this.maxOutput = d2;
            this.update();
        }

        public String toString() {
            return "Linear Function, [" + this.minInput + "," + this.maxInput + "]->[" + this.minOutput + "," + this.maxOutput + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LinearFunction linearFunction = (LinearFunction)object;
            if (Double.compare(linearFunction.maxInput, this.maxInput) != 0) {
                return false;
            }
            if (Double.compare(linearFunction.maxOutput, this.maxOutput) != 0) {
                return false;
            }
            if (Double.compare(linearFunction.minInput, this.minInput) != 0) {
                return false;
            }
            if (Double.compare(linearFunction.minOutput, this.minOutput) != 0) {
                return false;
            }
            if (Double.compare(linearFunction.scale, this.scale) != 0) {
                return false;
            }
            if (Double.compare(linearFunction.t1, this.t1) != 0) {
                return false;
            }
            return Double.compare(linearFunction.t2, this.t2) == 0;
        }

        public int hashCode() {
            long l = this.minInput != 0.0 ? Double.doubleToLongBits(this.minInput) : 0L;
            int n = (int)(l ^ l >>> 32);
            l = this.maxInput != 0.0 ? Double.doubleToLongBits(this.maxInput) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.minOutput != 0.0 ? Double.doubleToLongBits(this.minOutput) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.maxOutput != 0.0 ? Double.doubleToLongBits(this.maxOutput) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.t1 != 0.0 ? Double.doubleToLongBits(this.t1) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.scale != 0.0 ? Double.doubleToLongBits(this.scale) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.t2 != 0.0 ? Double.doubleToLongBits(this.t2) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }
}

