/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.phys2d_efield.propagators;

import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.propagators.BoundsBounce;

public class SouthBounce
extends BoundsBounce {
    double yMax;
    double distFromWall;

    public SouthBounce(double d, double d2) {
        this.yMax = d;
        this.distFromWall = d2;
    }

    public boolean isOutOfBounds(DoublePoint doublePoint) {
        return doublePoint.getY() > this.yMax;
    }

    public DoublePoint getNewVelocity(DoublePoint doublePoint) {
        double d = -Math.abs(doublePoint.getY());
        return new DoublePoint(doublePoint.getX(), d);
    }

    public DoublePoint getPointAtBounds(DoublePoint doublePoint) {
        return new DoublePoint(doublePoint.getX(), this.yMax - this.distFromWall);
    }
}

